/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.lookup.LeafSearchLookup;
import org.opensearch.search.lookup.SearchLookup;

public class SourceFieldMatchQuery
extends Query {
    private final Query delegateQuery;
    private final Query filter;
    private final SearchLookup lookup;
    private final MappedFieldType fieldType;
    private final SourceValueFetcher valueFetcher;
    private final QueryShardContext context;

    public SourceFieldMatchQuery(Query delegateQuery, Query filter, MappedFieldType fieldType, QueryShardContext context) {
        this.delegateQuery = delegateQuery;
        this.filter = filter;
        this.fieldType = fieldType;
        this.context = context;
        this.lookup = context.lookup();
        if (!context.documentMapper("").sourceMapper().enabled()) {
            throw new IllegalArgumentException("SourceFieldMatchQuery error: unable to fetch fields from _source field: _source is disabled in the mappings for index [" + context.index().getName() + "]");
        }
        this.valueFetcher = (SourceValueFetcher)fieldType.valueFetcher(context, this.lookup, null);
    }

    public void visit(QueryVisitor visitor) {
        this.delegateQuery.visit(visitor);
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.delegateQuery.rewrite(indexSearcher);
        if (rewritten == this.delegateQuery) {
            return this;
        }
        return new SourceFieldMatchQuery(rewritten, this.filter, this.fieldType, this.context);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        final Weight weight = this.delegateQuery.createWeight(searcher, ScoreMode.TOP_DOCS, boost);
        return new ConstantScoreWeight(this, this, boost){
            final /* synthetic */ SourceFieldMatchQuery this$0;
            {
                this.this$0 = this$0;
                super(query, score);
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                Scorer scorer = weight.scorer(context);
                if (scorer == null) {
                    return null;
                }
                DocIdSetIterator approximation = scorer.iterator();
                final LeafSearchLookup leafSearchLookup = this.this$0.lookup.getLeafSearchLookup(context);
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(this, approximation){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(approximation);
                    }

                    public boolean matches() {
                        leafSearchLookup.setDocument(this.approximation.docID());
                        List<Object> values = this.this$1.this$0.valueFetcher.fetchValues(leafSearchLookup.source());
                        if (values.isEmpty()) {
                            return false;
                        }
                        MemoryIndex memoryIndex = new MemoryIndex();
                        for (Object value : values) {
                            memoryIndex.addField(this.this$1.this$0.fieldType.name(), (String)value, (Analyzer)this.this$1.this$0.fieldType.indexAnalyzer());
                        }
                        float score = memoryIndex.search(this.this$1.this$0.filter);
                        return score > 0.0f;
                    }

                    public float matchCost() {
                        return 1000.0f;
                    }
                };
                return new Weight.DefaultScorerSupplier((Scorer)new ConstantScoreScorer(this.score(), ScoreMode.TOP_DOCS, twoPhase));
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return weight.isCacheable(ctx);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        SourceFieldMatchQuery other = (SourceFieldMatchQuery)((Object)o);
        return Objects.equals(this.delegateQuery, other.delegateQuery) && Objects.equals(this.filter, other.filter) && Objects.equals(this.fieldType, other.fieldType) && Objects.equals(this.context, other.context);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.delegateQuery, this.filter, this.fieldType, this.context);
    }

    public String toString(String f) {
        return "SourceFieldMatchQuery (delegate query: [ " + this.delegateQuery.toString(f) + " ], filter query: [ " + this.filter.toString(f) + "])";
    }
}

