/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core.schedule;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.core.JobRunner;
import org.opensearch.alerting.core.schedule.JobSchedulerMetrics;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.alerting.model.Schedule;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0014\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aJ\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\rJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001dJ\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u000eH\u0002J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00112\b\u0010#\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0012J\u000e\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/opensearch/alerting/core/schedule/JobScheduler;", "", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "jobRunner", "Lorg/opensearch/alerting/core/JobRunner;", "<init>", "(Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/alerting/core/JobRunner;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "scheduledJobIdToInfo", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/opensearch/alerting/core/schedule/JobScheduler$ScheduledJobInfo;", "monitorV2Type", "schedule", "", "Lorg/opensearch/commons/alerting/model/ScheduledJob;", "jobsToSchedule", "", "([Lorg/opensearch/commons/alerting/model/ScheduledJob;)Ljava/util/List;", "", "scheduledJob", "deschedule", "ids", "", "id", "scheduledJobs", "", "reschedule", "scheduleJob", "scheduledJobInfo", "getJobSchedulerMetric", "Lorg/opensearch/alerting/core/schedule/JobSchedulerMetrics;", "showAlertingV2ScheduledJobs", "(Ljava/lang/Boolean;)Ljava/util/List;", "postIndex", "", "job", "postDelete", "jobId", "ScheduledJobInfo", "alerting-core"})
@SourceDebugExtension(value={"SMAP\nJobScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobScheduler.kt\norg/opensearch/alerting/core/schedule/JobScheduler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n3829#2:247\n4344#2,2:248\n72#3,2:250\n1#4:252\n774#5:253\n865#5,2:254\n774#5:256\n865#5,2:257\n774#5:259\n865#5,2:260\n*S KotlinDebug\n*F\n+ 1 JobScheduler.kt\norg/opensearch/alerting/core/schedule/JobScheduler\n*L\n45#1:247\n45#1:248,2\n77#1:250,2\n77#1:252\n97#1:253\n97#1:254,2\n207#1:256\n207#1:257,2\n209#1:259\n209#1:260,2\n*E\n"})
public final class JobScheduler {
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final JobRunner jobRunner;
    private final Logger logger;
    @NotNull
    private final ConcurrentHashMap<String, ScheduledJobInfo> scheduledJobIdToInfo;
    @NotNull
    private final String monitorV2Type;

    public JobScheduler(@NotNull ThreadPool threadPool, @NotNull JobRunner jobRunner) {
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)jobRunner, (String)"jobRunner");
        this.threadPool = threadPool;
        this.jobRunner = jobRunner;
        this.logger = LogManager.getLogger(JobScheduler.class);
        this.scheduledJobIdToInfo = new ConcurrentHashMap();
        this.monitorV2Type = "monitor_v2";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ScheduledJob> schedule(ScheduledJob ... jobsToSchedule) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)jobsToSchedule, (String)"jobsToSchedule");
        ScheduledJob[] $this$filter$iv = jobsToSchedule;
        boolean $i$f$filter = false;
        ScheduledJob[] scheduledJobArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(!this.schedule((ScheduledJob)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean schedule(@NotNull ScheduledJob scheduledJob) {
        ScheduledJobInfo scheduledJobInfo;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)scheduledJob, (String)"scheduledJob");
        this.logger.info("Scheduling jobId : " + scheduledJob.getId() + ", name: " + scheduledJob.getName());
        if (!scheduledJob.getEnabled()) {
            return false;
        }
        ConcurrentMap concurrentMap = this.scheduledJobIdToInfo;
        String key$iv = scheduledJob.getId();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            ScheduledJobInfo default$iv = new ScheduledJobInfo(scheduledJob.getId(), scheduledJob, false, null, null, null, 60, null);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        if ((scheduledJobInfo = (ScheduledJobInfo)object).getScheduledCancellable() != null) {
            return true;
        }
        Intrinsics.checkNotNull((Object)scheduledJobInfo);
        return this.reschedule(scheduledJob, scheduledJobInfo);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> deschedule(@NotNull Collection<String> ids) {
        List list;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$filter$iv = ids;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!this.deschedule(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        if (!((Collection)it).isEmpty()) {
            this.logger.error("Unable to deschedule jobs " + it);
        }
        return list;
    }

    public final boolean deschedule(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ScheduledJobInfo scheduledJobInfo = this.scheduledJobIdToInfo.get(id);
        if (scheduledJobInfo == null) {
            this.logger.info("JobId " + id + " does not exist.");
            return true;
        }
        this.logger.info("Descheduling jobId : " + id);
        scheduledJobInfo.setDescheduled(true);
        scheduledJobInfo.setActualPreviousExecutionTime(null);
        scheduledJobInfo.setExpectedNextExecutionTime(null);
        boolean result = true;
        Scheduler.ScheduledCancellable scheduledFuture = scheduledJobInfo.getScheduledCancellable();
        if (scheduledFuture != null && !scheduledFuture.isCancelled()) {
            result = scheduledFuture.cancel();
        }
        if (result) {
            this.scheduledJobIdToInfo.remove(scheduledJobInfo.getScheduledJobId(), scheduledJobInfo);
        }
        return result;
    }

    @NotNull
    public final Set<String> scheduledJobs() {
        Set set = this.scheduledJobIdToInfo.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return set;
    }

    private final boolean reschedule(ScheduledJob scheduleJob, ScheduledJobInfo scheduledJobInfo) {
        if (scheduleJob.getEnabledTime() == null) {
            this.logger.info(scheduleJob.getName() + " there is no enabled time. This job should never have been scheduled.");
            return false;
        }
        Schedule schedule = scheduleJob.getSchedule();
        Instant instant = scheduleJob.getEnabledTime();
        Intrinsics.checkNotNull((Object)instant);
        scheduledJobInfo.setExpectedNextExecutionTime(schedule.getExpectedNextExecutionTime(instant, scheduledJobInfo.getExpectedNextExecutionTime()));
        if (scheduledJobInfo.getExpectedNextExecutionTime() == null) {
            this.logger.info(scheduleJob.getName() + " there is no next execution time.");
            return true;
        }
        Duration duration = Duration.between(Instant.now(), scheduledJobInfo.getExpectedNextExecutionTime());
        Runnable runnable = () -> JobScheduler.reschedule$lambda$4(scheduledJobInfo, scheduleJob, this);
        if (scheduledJobInfo.getDescheduled()) {
            return false;
        }
        Scheduler.ScheduledCancellable scheduledCancellable = this.threadPool.schedule(runnable, new TimeValue(duration.toNanos(), TimeUnit.NANOSECONDS), "same");
        scheduledJobInfo.setScheduledCancellable(scheduledCancellable);
        return true;
    }

    @NotNull
    public final List<JobSchedulerMetrics> getJobSchedulerMetric(@Nullable Boolean showAlertingV2ScheduledJobs) {
        Collection collection;
        Set<Map.Entry<String, ScheduledJobInfo>> set = this.scheduledJobIdToInfo.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Set<Map.Entry<String, ScheduledJobInfo>> scheduledJobEntries = set;
        if (showAlertingV2ScheduledJobs == null) {
            collection = scheduledJobEntries;
        } else if (showAlertingV2ScheduledJobs.booleanValue()) {
            $this$filter$iv = scheduledJobEntries;
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((ScheduledJobInfo)it.getValue()).getScheduledJob().getType(), (Object)this.monitorV2Type)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            $this$filter$iv = scheduledJobEntries;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)((ScheduledJobInfo)it.getValue()).getScheduledJob().getType(), (Object)this.monitorV2Type))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        }
        Collection filteredScheduledJobEntries = collection;
        List<JobSchedulerMetrics> list = filteredScheduledJobEntries.stream().map(arg_0 -> JobScheduler.getJobSchedulerMetric$lambda$8(JobScheduler::getJobSchedulerMetric$lambda$7, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    public final void postIndex(@NotNull ScheduledJob job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        this.jobRunner.postIndex(job);
    }

    public final void postDelete(@NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        this.jobRunner.postDelete(jobId);
    }

    private static final void reschedule$lambda$4(ScheduledJobInfo $scheduledJobInfo, ScheduledJob $scheduleJob, JobScheduler this$0) {
        if ($scheduledJobInfo.getDescheduled()) {
            return;
        }
        Pair pair = $scheduleJob.getSchedule().getPeriodEndingAt($scheduledJobInfo.getExpectedNextExecutionTime());
        Instant startTime = (Instant)pair.component1();
        Instant endTime = (Instant)pair.component2();
        $scheduledJobInfo.setActualPreviousExecutionTime(Instant.now());
        this$0.reschedule($scheduleJob, $scheduledJobInfo);
        this$0.jobRunner.runJob($scheduleJob, startTime, endTime);
    }

    private static final JobSchedulerMetrics getJobSchedulerMetric$lambda$7(Map.Entry entry) {
        Instant instant = ((ScheduledJobInfo)entry.getValue()).getActualPreviousExecutionTime();
        return new JobSchedulerMetrics(((ScheduledJobInfo)entry.getValue()).getScheduledJobId(), instant != null ? Long.valueOf(instant.toEpochMilli()) : null, ((ScheduledJobInfo)entry.getValue()).getScheduledJob().getSchedule().runningOnTime(((ScheduledJobInfo)entry.getValue()).getActualPreviousExecutionTime()));
    }

    private static final JobSchedulerMetrics getJobSchedulerMetric$lambda$8(Function1 $tmp0, Object p0) {
        return (JobSchedulerMetrics)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\fH\u00c6\u0003JK\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010(\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\n\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Lorg/opensearch/alerting/core/schedule/JobScheduler$ScheduledJobInfo;", "", "scheduledJobId", "", "scheduledJob", "Lorg/opensearch/commons/alerting/model/ScheduledJob;", "descheduled", "", "actualPreviousExecutionTime", "Ljava/time/Instant;", "expectedNextExecutionTime", "scheduledCancellable", "Lorg/opensearch/threadpool/Scheduler$ScheduledCancellable;", "<init>", "(Ljava/lang/String;Lorg/opensearch/commons/alerting/model/ScheduledJob;ZLjava/time/Instant;Ljava/time/Instant;Lorg/opensearch/threadpool/Scheduler$ScheduledCancellable;)V", "getScheduledJobId", "()Ljava/lang/String;", "getScheduledJob", "()Lorg/opensearch/commons/alerting/model/ScheduledJob;", "getDescheduled", "()Z", "setDescheduled", "(Z)V", "getActualPreviousExecutionTime", "()Ljava/time/Instant;", "setActualPreviousExecutionTime", "(Ljava/time/Instant;)V", "getExpectedNextExecutionTime", "setExpectedNextExecutionTime", "getScheduledCancellable", "()Lorg/opensearch/threadpool/Scheduler$ScheduledCancellable;", "setScheduledCancellable", "(Lorg/opensearch/threadpool/Scheduler$ScheduledCancellable;)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "alerting-core"})
    private static final class ScheduledJobInfo {
        @NotNull
        private final String scheduledJobId;
        @NotNull
        private final ScheduledJob scheduledJob;
        private boolean descheduled;
        @Nullable
        private Instant actualPreviousExecutionTime;
        @Nullable
        private Instant expectedNextExecutionTime;
        @Nullable
        private Scheduler.ScheduledCancellable scheduledCancellable;

        public ScheduledJobInfo(@NotNull String scheduledJobId, @NotNull ScheduledJob scheduledJob, boolean descheduled, @Nullable Instant actualPreviousExecutionTime, @Nullable Instant expectedNextExecutionTime, @Nullable Scheduler.ScheduledCancellable scheduledCancellable) {
            Intrinsics.checkNotNullParameter((Object)scheduledJobId, (String)"scheduledJobId");
            Intrinsics.checkNotNullParameter((Object)scheduledJob, (String)"scheduledJob");
            this.scheduledJobId = scheduledJobId;
            this.scheduledJob = scheduledJob;
            this.descheduled = descheduled;
            this.actualPreviousExecutionTime = actualPreviousExecutionTime;
            this.expectedNextExecutionTime = expectedNextExecutionTime;
            this.scheduledCancellable = scheduledCancellable;
        }

        public /* synthetic */ ScheduledJobInfo(String string, ScheduledJob scheduledJob, boolean bl, Instant instant, Instant instant2, Scheduler.ScheduledCancellable scheduledCancellable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                instant = null;
            }
            if ((n & 0x10) != 0) {
                instant2 = null;
            }
            if ((n & 0x20) != 0) {
                scheduledCancellable = null;
            }
            this(string, scheduledJob, bl, instant, instant2, scheduledCancellable);
        }

        @NotNull
        public final String getScheduledJobId() {
            return this.scheduledJobId;
        }

        @NotNull
        public final ScheduledJob getScheduledJob() {
            return this.scheduledJob;
        }

        public final boolean getDescheduled() {
            return this.descheduled;
        }

        public final void setDescheduled(boolean bl) {
            this.descheduled = bl;
        }

        @Nullable
        public final Instant getActualPreviousExecutionTime() {
            return this.actualPreviousExecutionTime;
        }

        public final void setActualPreviousExecutionTime(@Nullable Instant instant) {
            this.actualPreviousExecutionTime = instant;
        }

        @Nullable
        public final Instant getExpectedNextExecutionTime() {
            return this.expectedNextExecutionTime;
        }

        public final void setExpectedNextExecutionTime(@Nullable Instant instant) {
            this.expectedNextExecutionTime = instant;
        }

        @Nullable
        public final Scheduler.ScheduledCancellable getScheduledCancellable() {
            return this.scheduledCancellable;
        }

        public final void setScheduledCancellable(@Nullable Scheduler.ScheduledCancellable scheduledCancellable) {
            this.scheduledCancellable = scheduledCancellable;
        }

        @NotNull
        public final String component1() {
            return this.scheduledJobId;
        }

        @NotNull
        public final ScheduledJob component2() {
            return this.scheduledJob;
        }

        public final boolean component3() {
            return this.descheduled;
        }

        @Nullable
        public final Instant component4() {
            return this.actualPreviousExecutionTime;
        }

        @Nullable
        public final Instant component5() {
            return this.expectedNextExecutionTime;
        }

        @Nullable
        public final Scheduler.ScheduledCancellable component6() {
            return this.scheduledCancellable;
        }

        @NotNull
        public final ScheduledJobInfo copy(@NotNull String scheduledJobId, @NotNull ScheduledJob scheduledJob, boolean descheduled, @Nullable Instant actualPreviousExecutionTime, @Nullable Instant expectedNextExecutionTime, @Nullable Scheduler.ScheduledCancellable scheduledCancellable) {
            Intrinsics.checkNotNullParameter((Object)scheduledJobId, (String)"scheduledJobId");
            Intrinsics.checkNotNullParameter((Object)scheduledJob, (String)"scheduledJob");
            return new ScheduledJobInfo(scheduledJobId, scheduledJob, descheduled, actualPreviousExecutionTime, expectedNextExecutionTime, scheduledCancellable);
        }

        public static /* synthetic */ ScheduledJobInfo copy$default(ScheduledJobInfo scheduledJobInfo, String string, ScheduledJob scheduledJob, boolean bl, Instant instant, Instant instant2, Scheduler.ScheduledCancellable scheduledCancellable, int n, Object object) {
            if ((n & 1) != 0) {
                string = scheduledJobInfo.scheduledJobId;
            }
            if ((n & 2) != 0) {
                scheduledJob = scheduledJobInfo.scheduledJob;
            }
            if ((n & 4) != 0) {
                bl = scheduledJobInfo.descheduled;
            }
            if ((n & 8) != 0) {
                instant = scheduledJobInfo.actualPreviousExecutionTime;
            }
            if ((n & 0x10) != 0) {
                instant2 = scheduledJobInfo.expectedNextExecutionTime;
            }
            if ((n & 0x20) != 0) {
                scheduledCancellable = scheduledJobInfo.scheduledCancellable;
            }
            return scheduledJobInfo.copy(string, scheduledJob, bl, instant, instant2, scheduledCancellable);
        }

        @NotNull
        public String toString() {
            return "ScheduledJobInfo(scheduledJobId=" + this.scheduledJobId + ", scheduledJob=" + this.scheduledJob + ", descheduled=" + this.descheduled + ", actualPreviousExecutionTime=" + this.actualPreviousExecutionTime + ", expectedNextExecutionTime=" + this.expectedNextExecutionTime + ", scheduledCancellable=" + this.scheduledCancellable + ")";
        }

        public int hashCode() {
            int result = this.scheduledJobId.hashCode();
            result = result * 31 + this.scheduledJob.hashCode();
            result = result * 31 + Boolean.hashCode(this.descheduled);
            result = result * 31 + (this.actualPreviousExecutionTime == null ? 0 : this.actualPreviousExecutionTime.hashCode());
            result = result * 31 + (this.expectedNextExecutionTime == null ? 0 : this.expectedNextExecutionTime.hashCode());
            result = result * 31 + (this.scheduledCancellable == null ? 0 : this.scheduledCancellable.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScheduledJobInfo)) {
                return false;
            }
            ScheduledJobInfo scheduledJobInfo = (ScheduledJobInfo)other;
            if (!Intrinsics.areEqual((Object)this.scheduledJobId, (Object)scheduledJobInfo.scheduledJobId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scheduledJob, (Object)scheduledJobInfo.scheduledJob)) {
                return false;
            }
            if (this.descheduled != scheduledJobInfo.descheduled) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.actualPreviousExecutionTime, (Object)scheduledJobInfo.actualPreviousExecutionTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expectedNextExecutionTime, (Object)scheduledJobInfo.expectedNextExecutionTime)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.scheduledCancellable, (Object)scheduledJobInfo.scheduledCancellable);
        }
    }
}

