/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils.counters;

import org.graalvm.visualvm.heapviewer.utils.counters.PrimitiveCounter;

public final class ShortCounter
extends PrimitiveCounter {
    private int size;
    private final int[] counts = new int[65536];

    public void count(short key) {
        int index = key - Short.MIN_VALUE;
        if (this.counts[index] == 0) {
            ++this.size;
        }
        int n = index;
        this.counts[n] = this.counts[n] + 1;
    }

    @Override
    public void count(String value) {
        this.count(Short.parseShort(value));
    }

    public Iterator iterator() {
        return new Iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    public final class Iterator
    implements java.util.Iterator<Record> {
        private int index;
        private int count;

        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ShortCounter.this.size;
        }

        @Override
        public Record next() {
            Record entry = new Record();
            entry.count = ShortCounter.this.counts[this.index];
            while (entry.count == 0) {
                entry.count = ShortCounter.this.counts[++this.index];
            }
            entry.value = (short)(this.index++ + Short.MIN_VALUE);
            ++this.count;
            return entry;
        }
    }

    public static final class Record
    extends PrimitiveCounter.Record {
        private short value;
        private int count;

        private Record() {
        }

        public short getPrimitive() {
            return this.value;
        }

        @Override
        public String getValue() {
            return Short.toString(this.value);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        public int hashCode() {
            return Short.hashCode(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            return this.value == ((Record)o).value;
        }
    }
}

