/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.LabelAndLocalMapper;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.stmt.GotoStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.ArrayList;

public class EndRemover
implements Transformer {
    private static final LabelAndLocalMapper keepLocal = new LabelAndLocalMapper(){

        @Override
        public Local map(Local local) {
            return local;
        }
    };

    @Override
    public void transform(IrMethod irMethod) {
        for (Trap trap : new ArrayList<Trap>(irMethod.traps)) {
            LabelStmt start = null;
            boolean removeTrap = true;
            Stmt p = trap.start.getNext();
            block5: while (p != null && p != trap.end) {
                boolean notThrow = Cfg.notThrow(p);
                if (!notThrow) {
                    start = null;
                    p = p.getNext();
                    removeTrap = false;
                    continue;
                }
                switch (p.st) {
                    case LABEL: {
                        if (start != null) {
                            this.move4Label(irMethod.stmts, start, p.getPre(), (LabelStmt)p);
                        }
                        start = (LabelStmt)p;
                        p = p.getNext();
                        continue block5;
                    }
                    case GOTO: 
                    case RETURN: 
                    case RETURN_VOID: {
                        if (start != null) {
                            Stmt tmp = p.getNext();
                            this.move4End(irMethod.stmts, start, p);
                            start = null;
                            p = tmp;
                            continue block5;
                        }
                        p = p.getNext();
                        continue block5;
                    }
                }
                p = p.getNext();
            }
            if (!removeTrap) continue;
            irMethod.traps.remove(trap);
        }
        StmtList stmts = irMethod.stmts;
        for (Stmt p = stmts.getFirst(); p != null; p = p.getNext()) {
            LabelStmt target;
            Stmt next;
            if (p.st != Stmt.ST.GOTO || (next = (target = ((GotoStmt)p).target).getNext()) == null || next.st != Stmt.ST.RETURN && next.st != Stmt.ST.RETURN_VOID) continue;
            Stmt nnext = next.clone(keepLocal);
            stmts.insertAfter(p, nnext);
            stmts.remove(p);
            p = nnext;
        }
    }

    private void move4Label(StmtList stmts, LabelStmt start, Stmt end, LabelStmt label) {
        this.move4End(stmts, start, end);
        stmts.insertAfter(end, Stmts.nGoto(label));
    }

    private void move4End(StmtList stmts, LabelStmt start, Stmt end) {
        GotoStmt g1 = Stmts.nGoto(start);
        stmts.insertBefore(start, g1);
        Stmt last = stmts.getLast();
        while (last.st == Stmt.ST.GOTO && ((GotoStmt)last).target == start) {
            stmts.remove(last);
            last = stmts.getLast();
        }
        stmts.move(start, end, last);
    }
}

