/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class Region
extends FreeColGameObject
implements Nameable {
    private static final Logger logger = Logger.getLogger(Region.class.getName());
    public static final String TAG = "region";
    public static final List<String> predefinedRegionKeys = CollectionUtils.makeUnmodifiableList("model.region.arctic", "model.region.antarctic", "model.region.northWest", "model.region.north", "model.region.northEast", "model.region.west", "model.region.center", "model.region.east", "model.region.southWest", "model.region.south", "model.region.southEast", "model.region.atlantic", "model.region.northAtlantic", "model.region.southAtlantic", "model.region.pacific", "model.region.northPacific", "model.region.southPacific");
    public static final String PACIFIC_KEY = "model.region.pacific";
    protected String name;
    protected String key;
    protected RegionType type;
    protected Region parent;
    protected List<Region> children = null;
    protected boolean claimable = false;
    protected boolean discoverable = false;
    protected Turn discoveredIn;
    protected Player discoveredBy;
    private String discoverer = null;
    protected int scoreValue = 0;
    private static final String CHILD_TAG = "child";
    private static final String CLAIMABLE_TAG = "claimable";
    private static final String DISCOVERABLE_TAG = "discoverable";
    private static final String DISCOVERED_BY_TAG = "discoveredBy";
    private static final String DISCOVERED_IN_TAG = "discoveredIn";
    private static final String KEY_TAG = "key";
    private static final String NAME_TAG = "name";
    private static final String PARENT_TAG = "parent";
    private static final String SCORE_VALUE_TAG = "scoreValue";
    private static final String TYPE_TAG = "type";
    private static final String NAME_KEY_TAG = "nameKey";

    public Region(Game game) {
        super(game);
    }

    public Region(Game game, String id) {
        super(game, id);
    }

    public String getKey() {
        return this.key;
    }

    public boolean hasName() {
        return this.name != null || this.key != null;
    }

    public boolean isPacific() {
        return PACIFIC_KEY.equals(this.key) || this.parent != null && this.parent.isPacific();
    }

    public StringTemplate getLabel() {
        return this.key != null ? StringTemplate.key(Messages.nameKey(this.key)) : (this.name != null ? StringTemplate.name(this.name) : StringTemplate.key(this.type.getUnknownKey()));
    }

    public final RegionType getType() {
        return this.type;
    }

    public final Region getParent() {
        return this.parent;
    }

    public final void setParent(Region newParent) {
        this.parent = newParent;
    }

    public final List<Region> getChildren() {
        return this.children == null ? Collections.emptyList() : this.children;
    }

    public final void setChildren(List<Region> newChildren) {
        this.children = newChildren;
    }

    public void addChild(Region child) {
        if (this.children == null) {
            this.children = new ArrayList<Region>();
        }
        this.children.add(child);
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public final boolean getClaimable() {
        return this.claimable;
    }

    public final void setClaimable(boolean newClaimable) {
        this.claimable = newClaimable;
    }

    public final boolean getDiscoverable() {
        return this.discoverable;
    }

    public final void setDiscoverable(boolean newDiscoverable) {
        this.discoverable = newDiscoverable;
    }

    public final String getDiscoverer() {
        return this.discoverer;
    }

    public Region getDiscoverableRegion() {
        return this.getDiscoverable() ? this : (this.getParent() != null ? this.getParent().getDiscoverableRegion() : null);
    }

    public final Turn getDiscoveredIn() {
        return this.discoveredIn;
    }

    public final void setDiscoveredIn(Turn newDiscoveredIn) {
        this.discoveredIn = newDiscoveredIn;
    }

    public final Player getDiscoveredBy() {
        return this.discoveredBy;
    }

    public final void setDiscoveredBy(Player newDiscoveredBy) {
        this.discoveredBy = newDiscoveredBy;
    }

    public final int getScoreValue() {
        return this.scoreValue;
    }

    public final void setScoreValue(int newScoreValue) {
        this.scoreValue = newScoreValue;
    }

    public synchronized boolean checkDiscover(Unit unit) {
        if (this.discoverable) {
            if (this.discoverer == null) {
                this.discoverer = unit.getId();
                return true;
            }
            if (this.discoverer.equals(unit.getId())) {
                return true;
            }
        }
        return false;
    }

    public List<Region> discover(Player player, Unit unit, Turn turn) {
        if (unit == null || this.discoverer == null || !this.discoverer.equals(unit.getId())) {
            return Collections.emptyList();
        }
        this.discoveredBy = player;
        this.discoveredIn = turn;
        this.discoverable = false;
        List<Region> discov = CollectionUtils.transform(this.getChildren(), Region::getDiscoverable);
        for (Region r : discov) {
            r.discoveredBy = player;
            r.discoverer = unit.getId();
            r.discoveredIn = turn;
            r.discoverable = false;
        }
        ArrayList<Region> result = new ArrayList<Region>(discov.size() + 1);
        result.add(this);
        result.addAll(discov);
        return result;
    }

    private String fixRegionKey(String key) {
        if (key == null) {
            return key;
        }
        for (String r : predefinedRegionKeys) {
            if (key.equals(r)) {
                return r;
            }
            if (!key.equals(Messages.nameKey(r))) continue;
            return StringUtils.lastPart(key, ".");
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Region o = this.copyInCast(other, Region.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.name = o.getName();
        this.key = o.getKey();
        this.type = o.getType();
        this.parent = game.updateRef(o.getParent());
        this.children = game.updateRef(o.getChildren());
        this.claimable = o.getClaimable();
        this.discoverable = o.getDiscoverable();
        this.discoveredIn = o.getDiscoveredIn();
        this.discoveredBy = game.updateRef(o.getDiscoveredBy());
        this.discoverer = o.getDiscoverer();
        this.scoreValue = o.getScoreValue();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.name != null) {
            xw.writeAttribute(NAME_TAG, this.name);
        }
        if (this.key != null) {
            xw.writeAttribute(KEY_TAG, this.key);
        }
        xw.writeAttribute(TYPE_TAG, this.type);
        xw.writeAttribute(CLAIMABLE_TAG, this.claimable);
        xw.writeAttribute(DISCOVERABLE_TAG, this.discoverable);
        if (this.parent != null) {
            xw.writeAttribute(PARENT_TAG, this.parent);
        }
        if (this.discoveredIn != null) {
            xw.writeAttribute(DISCOVERED_IN_TAG, this.discoveredIn.getNumber());
        }
        if (this.discoveredBy != null) {
            xw.writeAttribute(DISCOVERED_BY_TAG, this.discoveredBy);
        }
        if (this.scoreValue > 0) {
            xw.writeAttribute(SCORE_VALUE_TAG, this.scoreValue);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Region child : this.getChildren()) {
            xw.writeStartElement(CHILD_TAG);
            xw.writeAttribute("id", child);
            xw.writeEndElement();
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.name = xr.getAttribute(NAME_TAG, null);
        if (xr.hasAttribute(NAME_KEY_TAG)) {
            this.key = xr.getAttribute(NAME_KEY_TAG, null);
            this.key = this.fixRegionKey(this.key);
        } else {
            this.key = xr.getAttribute(KEY_TAG, null);
        }
        this.type = xr.getAttribute(TYPE_TAG, RegionType.class, null);
        this.claimable = xr.getAttribute(CLAIMABLE_TAG, false);
        this.discoverable = xr.getAttribute(DISCOVERABLE_TAG, false);
        this.scoreValue = xr.getAttribute(SCORE_VALUE_TAG, 0);
        int turn = xr.getAttribute(DISCOVERED_IN_TAG, Integer.MIN_VALUE);
        this.discoveredIn = turn == Integer.MIN_VALUE ? null : new Turn(turn);
        this.discoveredBy = xr.findFreeColGameObject(this.getGame(), DISCOVERED_BY_TAG, Player.class, null, false);
        this.parent = xr.makeFreeColObject(this.getGame(), PARENT_TAG, Region.class, false);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.children = null;
        super.readChildren(xr);
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (CHILD_TAG.equals(tag)) {
            this.addChild(xr.makeFreeColObject(this.getGame(), "id", Region.class, true));
            xr.closeTag(CHILD_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append('[').append(this.getId()).append(' ').append(this.key != null ? this.key : (this.name != null ? this.name : "<unnamed>")).append(' ').append(this.type);
        if (this.getDiscoverable()) {
            sb.append('!');
        } else {
            sb.append("discoverer=").append(this.discoverer);
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum RegionType implements Named
    {
        OCEAN(false),
        COAST(false),
        LAKE(false),
        RIVER(true),
        LAND(true),
        MOUNTAIN(true),
        DESERT(true);

        private final boolean claimable;

        private RegionType(boolean claimable) {
            this.claimable = claimable;
        }

        public boolean getClaimable() {
            return this.claimable;
        }

        public String getKey() {
            return "regionType." + StringUtils.getEnumKey(this);
        }

        public String getUnknownKey() {
            return "model." + this.getKey() + ".unknown";
        }

        @Override
        public String getNameKey() {
            return Messages.nameKey("model." + this.getKey());
        }
    }
}

