/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.libreoffice.report.pentaho.model.OfficeReport;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.chart.ChartReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.DetailRootTableReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.FunctionReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.GroupReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.RootTableReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportReadHandler
extends ElementReadHandler {
    private RootTableReadHandler pageHeader;
    private RootTableReadHandler pageFooter;
    private RootTableReadHandler reportHeader;
    private RootTableReadHandler reportFooter;
    private RootTableReadHandler detail;
    private GroupReadHandler groups;
    private final OfficeReport rootSection = new OfficeReport();
    private final List<FunctionReadHandler> functionHandlers;
    private final List<ElementReadHandler> preBodyHandlers;
    private final List<ElementReadHandler> postBodyHandlers;
    private boolean pre = true;

    public ReportReadHandler() {
        this.rootSection.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "simple-report-structure", Boolean.TRUE);
        this.functionHandlers = new ArrayList<FunctionReadHandler>();
        this.preBodyHandlers = new ArrayList<ElementReadHandler>();
        this.postBodyHandlers = new ArrayList<ElementReadHandler>();
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        AbstractXmlReadHandler abstractXmlReadHandler;
        if ("urn:oasis:names:tc:opendocument:xmlns:chart:1.0".equals(string)) {
            ChartReadHandler chartReadHandler = new ChartReadHandler(this);
            if (this.pre) {
                this.preBodyHandlers.add(chartReadHandler);
            } else {
                this.postBodyHandlers.add(chartReadHandler);
            }
            abstractXmlReadHandler = chartReadHandler;
        } else if ("http://openoffice.org/2005/report".equals(string)) {
            if ("function".equals(string2)) {
                FunctionReadHandler functionReadHandler = new FunctionReadHandler();
                this.functionHandlers.add(functionReadHandler);
                abstractXmlReadHandler = functionReadHandler;
            } else if ("page-header".equals(string2)) {
                this.pageHeader = new RootTableReadHandler();
                abstractXmlReadHandler = this.pageHeader;
            } else if ("report-header".equals(string2)) {
                this.reportHeader = new RootTableReadHandler();
                abstractXmlReadHandler = this.reportHeader;
            } else if ("report-footer".equals(string2)) {
                this.reportFooter = new RootTableReadHandler();
                abstractXmlReadHandler = this.reportFooter;
            } else if ("page-footer".equals(string2)) {
                this.pageFooter = new RootTableReadHandler();
                abstractXmlReadHandler = this.pageFooter;
            } else if ("detail".equals(string2)) {
                this.pre = false;
                this.detail = new DetailRootTableReadHandler();
                abstractXmlReadHandler = this.detail;
            } else if ("group".equals(string2)) {
                this.groups = new GroupReadHandler(this);
                abstractXmlReadHandler = this.groups;
            } else {
                abstractXmlReadHandler = null;
            }
        } else {
            abstractXmlReadHandler = null;
        }
        return abstractXmlReadHandler;
    }

    protected void doneParsing() throws SAXException {
        Section section;
        if (this.pageHeader != null) {
            this.rootSection.setPageHeader(this.pageHeader.getElement());
        }
        if (this.pageFooter != null) {
            this.rootSection.setPageFooter(this.pageFooter.getElement());
        }
        if (this.reportHeader != null) {
            this.rootSection.setReportHeader(this.reportHeader.getElement());
        }
        if ((section = this.createSection("report-pre-body", this.preBodyHandlers)) != null) {
            this.rootSection.setPreBodySection(section);
        }
        Section section2 = new Section();
        section2.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
        section2.setType("report-body");
        this.rootSection.setBodySection(section2);
        if (this.groups != null) {
            section2.addNode(this.groups.getElement());
        } else if (this.detail != null) {
            section2.addNode(this.detail.getElement());
        }
        Section section3 = this.createSection("report-post-body", this.postBodyHandlers);
        if (section3 != null) {
            this.rootSection.setPostBodySection(section3);
        }
        if (this.reportFooter != null) {
            this.rootSection.setReportFooter(this.reportFooter.getElement());
        }
        for (int i = 0; i < this.functionHandlers.size(); ++i) {
            FunctionReadHandler functionReadHandler = this.functionHandlers.get(i);
            this.rootSection.addExpression(functionReadHandler.getExpression());
        }
    }

    @Override
    public Element getElement() {
        return this.rootSection;
    }

    private final Section createSection(String string, List<ElementReadHandler> list) {
        if (!list.isEmpty()) {
            Section section = new Section();
            section.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
            section.setType(string);
            for (int i = 0; i < list.size(); ++i) {
                ElementReadHandler elementReadHandler = list.get(i);
                section.addNode(elementReadHandler.getElement());
            }
            return section;
        }
        return null;
    }

    public void setDetail(RootTableReadHandler rootTableReadHandler) {
        this.detail = rootTableReadHandler;
    }

    public final RootTableReadHandler getDetail() {
        return this.detail;
    }
}

