/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jrjackson.JavaBigDecimalValueConverter;
import com.jrjackson.JavaBigIntValueConverter;
import com.jrjackson.JavaConverter;
import com.jrjackson.JavaFloatValueConverter;
import com.jrjackson.JavaHandler;
import com.jrjackson.JavaLongValueConverter;
import com.jrjackson.JjParse;
import com.jrjackson.JrJacksonBase;
import com.jrjackson.RubyJacksonModule;
import com.jrjackson.RubyUtils;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"JrJacksonJava"})
public class JrJacksonJava
extends JrJacksonBase {
    public JrJacksonJava(Ruby ruby, RubyClass metaclass) {
        super(ruby, metaclass);
    }

    @JRubyMethod(module=true, name={"parse", "load"}, required=2)
    public static IRubyObject parse(ThreadContext context, IRubyObject self, IRubyObject arg, IRubyObject opts) throws JsonProcessingException, IOException, RaiseException {
        JsonParser jp;
        RubyHash options;
        JavaConverter ikonv = new JavaBigIntValueConverter();
        JavaConverter dkonv = new JavaBigDecimalValueConverter();
        if (opts != context.nil && (options = opts.convertToHash()).size() > 0) {
            if (!JrJacksonJava.flagged(options, RubyUtils.rubySymbol(context.runtime, "use_bigdecimal"), true)) {
                dkonv = new JavaFloatValueConverter();
            }
            if (JrJacksonJava.flagged(options, RubyUtils.rubySymbol(context.runtime, "use_smallint"))) {
                ikonv = new JavaLongValueConverter();
            }
        }
        JavaHandler handler = new JavaHandler(ikonv, dkonv);
        JjParse parse = new JjParse(handler);
        try {
            jp = JrJacksonJava.buildParser(context, RubyJacksonModule.factory, arg);
        }
        catch (IOException e) {
            throw context.runtime.newIOError(e.getLocalizedMessage());
        }
        parse.deserialize(jp);
        jp.close();
        return RubyUtils.rubyObject(context.runtime, handler.getResult());
    }

    @JRubyMethod(module=true, name={"parse_raw", "load_raw"}, required=2)
    public static IRubyObject parse_raw(ThreadContext context, IRubyObject self, IRubyObject arg, IRubyObject opts) throws JsonProcessingException, IOException, RaiseException {
        JsonParser jp;
        JavaBigIntValueConverter ikonv = new JavaBigIntValueConverter();
        JavaBigDecimalValueConverter dkonv = new JavaBigDecimalValueConverter();
        JavaHandler handler = new JavaHandler(ikonv, dkonv);
        JjParse parse = new JjParse(handler);
        try {
            jp = JrJacksonJava.buildParser(context, RubyJacksonModule.factory, arg);
        }
        catch (IOException e) {
            throw context.runtime.newIOError(e.getLocalizedMessage());
        }
        parse.deserialize(jp);
        jp.close();
        return RubyUtils.rubyObject(context.runtime, handler.getResult());
    }
}

