/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class UTF8Reader
extends Reader {
    private static final String READER_CLOSED = "Reader closed";
    private static final int MAXIMUM_BUFFER_SIZE = 8192;
    private InputStream in;
    private final PositionedStream positionedIn;
    private long rawStreamPos = 0L;
    private long utfCount;
    private long readerCharCount;
    private final char[] buffer;
    private int charactersInBuffer;
    private int readPositionInBuffer;
    private boolean noMoreReads;
    private ConnectionChild parent;
    private final CharacterStreamDescriptor csd;

    public UTF8Reader(CharacterStreamDescriptor csd, ConnectionChild conChild, Object sync) throws IOException {
        super(sync);
        this.csd = csd;
        this.positionedIn = csd.isPositionAware() ? csd.getPositionedStream() : null;
        this.parent = conChild;
        int buffersize = this.calculateBufferSize(csd);
        this.buffer = new char[buffersize];
        if (csd.isPositionAware()) {
            SanityManager.ASSERT((csd.getCurBytePos() == this.positionedIn.getPosition() ? 1 : 0) != 0);
            this.rawStreamPos = this.positionedIn.getPosition();
            if (this.rawStreamPos < csd.getDataOffset()) {
                this.rawStreamPos = csd.getDataOffset();
            }
        } else if (csd.getCurBytePos() < csd.getDataOffset()) {
            csd.getStream().skip(csd.getDataOffset() - csd.getCurBytePos());
        }
        this.in = csd.isBufferable() ? new BufferedInputStream(csd.getStream(), buffersize) : csd.getStream();
        this.utfCount = csd.getDataOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            return this.buffer[this.readPositionInBuffer++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            int remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer;
            if (len > remainingInBuffer) {
                len = remainingInBuffer;
            }
            System.arraycopy(this.buffer, this.readPositionInBuffer, cbuf, off, len);
            this.readPositionInBuffer += len;
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long len) throws IOException {
        if (len < 0L) {
            throw new IllegalArgumentException("Number of characters to skip must be positive: " + len);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return 0L;
            }
            int remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer;
            if (len > (long)remainingInBuffer) {
                len = remainingInBuffer;
            }
            this.readPositionInBuffer = (int)((long)this.readPositionInBuffer + len);
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closeIn();
            this.parent = null;
            this.noMoreReads = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInto(StringBuffer sb, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            int remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer;
            if (len > remainingInBuffer) {
                len = remainingInBuffer;
            }
            sb.append(this.buffer, this.readPositionInBuffer, len);
            this.readPositionInBuffer += len;
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readAsciiInto(byte[] abuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            int remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer;
            if (len > remainingInBuffer) {
                len = remainingInBuffer;
            }
            char[] lbuffer = this.buffer;
            for (int i = 0; i < len; ++i) {
                char c = lbuffer[this.readPositionInBuffer + i];
                int cb = c <= '\u00ff' ? (int)((byte)c) : 63;
                abuf[off + i] = cb;
            }
            this.readPositionInBuffer += len;
            return len;
        }
    }

    private void closeIn() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
            }
        }
    }

    private IOException utfFormatException(String s) {
        this.noMoreReads = true;
        this.closeIn();
        return new UTFDataFormatException(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fillBuffer() throws IOException {
        if (this.in == null) {
            return true;
        }
        this.charactersInBuffer = 0;
        this.readPositionInBuffer = 0;
        try {
            try {
                boolean bl;
                this.parent.setupContextStack();
                if (this.positionedIn != null) {
                    try {
                        this.positionedIn.reposition(this.rawStreamPos);
                    }
                    catch (StandardException se) {
                        throw Util.generateCsSQLException(se);
                    }
                }
                long utfLen = this.csd.getByteLength();
                long maxFieldSize = this.csd.getMaxCharLength();
                block13: while (!(this.charactersInBuffer >= this.buffer.length || this.utfCount >= utfLen && utfLen != 0L || maxFieldSize != 0L && this.readerCharCount >= maxFieldSize)) {
                    int finalChar;
                    int c = this.in.read();
                    if (c == -1) {
                        if (utfLen != 0L) throw this.utfFormatException("Reached EOF prematurely, read " + this.utfCount + " out of " + utfLen + " bytes");
                        if (this.csd.isPositionAware()) break;
                        this.closeIn();
                        break;
                    }
                    switch (c >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            ++this.utfCount;
                            finalChar = c;
                            break;
                        }
                        case 12: 
                        case 13: {
                            this.utfCount += 2L;
                            int char2 = this.in.read();
                            if (char2 == -1) {
                                throw this.utfFormatException("Reached EOF when reading second byte in a two byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            }
                            if ((char2 & 0xC0) != 128) {
                                throw this.utfFormatException("Second byte in a two bytecharacter encoding invalid: (int)" + char2 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            }
                            finalChar = (c & 0x1F) << 6 | char2 & 0x3F;
                            break;
                        }
                        case 14: {
                            this.utfCount += 3L;
                            int char2 = this.in.read();
                            int char3 = this.in.read();
                            if (char2 == -1) throw this.utfFormatException("Reached EOF when reading second/third byte in a three byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            if (char3 == -1) {
                                throw this.utfFormatException("Reached EOF when reading second/third byte in a three byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            }
                            if (c == 224 && char2 == 0 && char3 == 0) {
                                if (utfLen != 0L) throw this.utfFormatException("Internal error: Derby-specific EOF marker read");
                                if (this.csd.isPositionAware()) break block13;
                                this.closeIn();
                                break block13;
                            }
                            if ((char2 & 0xC0) != 128) throw this.utfFormatException("Second/third byte in a three byte character encoding invalid: (int)" + char2 + "/" + char3 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            if ((char3 & 0xC0) != 128) {
                                throw this.utfFormatException("Second/third byte in a three byte character encoding invalid: (int)" + char2 + "/" + char3 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            }
                            finalChar = (c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0;
                            break;
                        }
                        default: {
                            throw this.utfFormatException("Invalid UTF encoding at byte/char position " + this.utfCount + "/" + this.readerCharCount + ": (int)" + c);
                        }
                    }
                    this.buffer[this.charactersInBuffer++] = (char)finalChar;
                    ++this.readerCharCount;
                }
                if (utfLen != 0L && this.utfCount > utfLen) {
                    throw this.utfFormatException("Incorrect encoded length in stream, expected " + utfLen + ", have " + this.utfCount + " bytes");
                }
                if (this.charactersInBuffer != 0) {
                    if (this.positionedIn != null) {
                        this.rawStreamPos = this.positionedIn.getPosition();
                    }
                    bl = false;
                    return bl;
                }
                if (!this.csd.isPositionAware()) {
                    this.closeIn();
                }
                bl = true;
                return bl;
            }
            finally {
                ConnectionChild.restoreIntrFlagIfSeen(true, this.parent.getEmbedConnection());
                this.parent.restoreContextStack();
            }
        }
        catch (SQLException sqle) {
            throw Util.newIOException(sqle);
        }
    }

    private void resetUTF8Reader() throws IOException, StandardException {
        this.positionedIn.reposition(this.csd.getDataOffset());
        this.utfCount = this.rawStreamPos = this.positionedIn.getPosition();
        if (this.csd.isBufferable()) {
            this.in = new BufferedInputStream(this.csd.getStream(), this.buffer.length);
        }
        this.readerCharCount = 0L;
        this.readPositionInBuffer = 0;
        this.charactersInBuffer = 0;
    }

    void reposition(long requestedCharPos) throws IOException, StandardException {
        long currentCharPos;
        long difference;
        SanityManager.ASSERT((this.positionedIn != null ? 1 : 0) != 0);
        SanityManager.ASSERT((requestedCharPos > 0L ? 1 : 0) != 0);
        if (requestedCharPos <= this.readerCharCount - (long)this.charactersInBuffer) {
            this.resetUTF8Reader();
        }
        if ((difference = requestedCharPos - 1L - (currentCharPos = this.readerCharCount - (long)this.charactersInBuffer + (long)this.readPositionInBuffer)) <= 0L) {
            this.readPositionInBuffer = (int)((long)this.readPositionInBuffer + difference);
        } else {
            this.persistentSkip(difference);
        }
    }

    private final int calculateBufferSize(CharacterStreamDescriptor csd) {
        int bufferSize = 8192;
        long knownLength = csd.getCharLength();
        long maxCharLength = csd.getMaxCharLength();
        if (knownLength < 1L) {
            knownLength = csd.getByteLength();
        }
        if (knownLength > 0L && knownLength < (long)bufferSize) {
            bufferSize = (int)knownLength;
        }
        if (maxCharLength > 0L && maxCharLength < (long)bufferSize) {
            bufferSize = (int)maxCharLength;
        }
        return bufferSize;
    }

    private final void persistentSkip(long toSkip) throws IOException {
        long skipped;
        for (long remaining = toSkip; remaining > 0L; remaining -= skipped) {
            skipped = this.skip(remaining);
            if (skipped != 0L) continue;
            throw new EOFException("Reached end-of-stream after " + this.readerCharCount + " characters, " + remaining + " remaining to skip");
        }
    }
}

