/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner.ui.hints;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.netbeans.modules.gsf.testrunner.plugin.CommonTestUtilProvider;
import org.netbeans.modules.gsf.testrunner.plugin.GuiUtilsProvider;
import org.netbeans.modules.java.testrunner.CommonTestUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class Utils {
    private static final String TEST_CLASS_SUFFIX = "Test";
    private static List<String> testingFrameworks;
    private static Object[] locations;

    public static String getLocationText(Object location) {
        String text = location instanceof SourceGroup ? ((SourceGroup)location).getDisplayName() : (location instanceof FileObject ? FileUtil.getFileDisplayName((FileObject)((FileObject)location)) : location.toString());
        return text;
    }

    public static Map<Object, List<String>> getValidCombinations(CompilationInfo info, String methodName) {
        Utils.populateTestingFrameworks();
        if (testingFrameworks.isEmpty()) {
            return null;
        }
        Utils.populateLocations(info.getFileObject());
        HashMap<Object, List<String>> validCombinations = new HashMap<Object, List<String>>();
        for (Object location : locations) {
            String targetFolderPath = Utils.getTargetFolderPath(location);
            ArrayList<String> framework2Add = new ArrayList<String>();
            for (String framework : testingFrameworks) {
                String preffiledName = Utils.getPreffiledName(info, framework);
                preffiledName = preffiledName.replace(".", "/").concat(".java");
                String path = targetFolderPath.concat("/").concat(preffiledName);
                File f = new File(path);
                FileObject fo = FileUtil.toFileObject((File)f);
                if (methodName == null) {
                    if (fo != null) continue;
                    framework2Add.add(framework);
                    continue;
                }
                try {
                    String testMethodName = Utils.getTestMethodName(methodName);
                    if (fo == null || fo.asText().replace("\n", "").trim().contains(testMethodName.concat("("))) continue;
                    framework2Add.add(framework);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (framework2Add.isEmpty()) continue;
            validCombinations.put(location, framework2Add);
        }
        testingFrameworks.clear();
        locations = null;
        return validCombinations;
    }

    private static String getTestMethodName(String methodName) {
        return "test" + Utils.capitalizeFirstLetter(methodName);
    }

    private static String capitalizeFirstLetter(String str) {
        if (str == null || str.length() <= 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private static void populateTestingFrameworks() {
        testingFrameworks = new ArrayList<String>();
        Collection testCreatorProviders = Lookup.getDefault().lookupResult(TestCreatorProvider.class).allItems();
        for (Lookup.Item provider : testCreatorProviders) {
            testingFrameworks.add(provider.getDisplayName());
        }
    }

    private static void populateLocations(FileObject activeFO) {
        SourceGroup sourceGroupOwner;
        Collection testUtilProviders = Lookup.getDefault().lookupAll(CommonTestUtilProvider.class);
        Iterator iterator = testUtilProviders.iterator();
        if (iterator.hasNext()) {
            CommonTestUtilProvider provider = (CommonTestUtilProvider)iterator.next();
            locations = provider.getTestTargets(activeFO);
        }
        if (locations != null && locations.length == 0 && (sourceGroupOwner = CommonTestUtil.findSourceGroupOwner((FileObject)activeFO)) != null) {
            locations = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroupOwner.getRootFolder());
        }
    }

    private static String getPreffiledName(CompilationInfo info, String selectedFramework) {
        FileObject fileObj = info.getFileObject();
        ClassPath cp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
        String className = cp.getResourceName(fileObj, '.', false);
        return className + Utils.getTestingFrameworkSuffix(selectedFramework) + TEST_CLASS_SUFFIX;
    }

    private static String getTestingFrameworkSuffix(String selectedFramework) {
        if (selectedFramework == null) {
            return "";
        }
        String testngFramework = "";
        Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
        Iterator iterator = providers.iterator();
        if (iterator.hasNext()) {
            GuiUtilsProvider provider = (GuiUtilsProvider)iterator.next();
            testngFramework = provider.getTestngFramework();
        }
        return selectedFramework.equals(testngFramework) ? "NG" : "";
    }

    private static String getTargetFolderPath(Object selectedLocation) {
        if (selectedLocation == null) {
            return null;
        }
        if (selectedLocation instanceof SourceGroup) {
            return ((SourceGroup)selectedLocation).getRootFolder().getPath();
        }
        if (selectedLocation instanceof URL) {
            return ((URL)selectedLocation).getPath();
        }
        assert (selectedLocation instanceof FileObject);
        return ((FileObject)selectedLocation).getPath();
    }
}

