/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class StringBuilderAppend {
    public static ErrorDescription builder(HintContext ctx) {
        return StringBuilderAppend.hint(ctx, "StringBuilder");
    }

    public static ErrorDescription buffer(HintContext ctx) {
        return StringBuilderAppend.hint(ctx, "StringBuffer");
    }

    private static ErrorDescription hint(HintContext ctx, String clazzName) {
        CompilationInfo info = ctx.getInfo();
        MethodInvocationTree mit = (MethodInvocationTree)ctx.getPath().getLeaf();
        ExpressionTree param = mit.getArguments().get(0);
        List<List<TreePath>> sorted = Utilities.splitStringConcatenationToElements(info, new TreePath(ctx.getPath(), param));
        if (sorted.size() > 1) {
            String error = NbBundle.getMessage(StringBuilderAppend.class, (String)"ERR_StringBuilderAppend", (Object)clazzName);
            return ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)param, (String)error, (Fix[])new Fix[]{new FixImpl(info, ctx.getPath()).toEditorFix()});
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        public String getText() {
            return NbBundle.getMessage(StringBuilderAppend.class, (String)"FIX_StringBuilderAppend");
        }

        private ExpressionTree merge(TreeMaker make, ExpressionTree arg1, ExpressionTree arg2) {
            if (arg1 == null) {
                return arg2;
            }
            if (arg2 == null) {
                return arg1;
            }
            if (arg1 == arg2) {
                return arg1;
            }
            return make.Binary(Tree.Kind.PLUS, arg1, arg2);
        }

        private ExpressionTree merge(TreeMaker make, ExpressionTree arg, ExpressionTree singleLeaf, StringBuilder literal, ExpressionTree l) {
            ExpressionTree n;
            if (singleLeaf != null) {
                n = singleLeaf;
                literal.delete(0, literal.length());
                n = this.merge(make, n, l);
            } else if (literal.length() > 0) {
                n = make.Literal((Object)literal.toString());
                literal.delete(0, literal.length());
                n = this.merge(make, n, l);
            } else {
                n = l;
            }
            return this.merge(make, arg, n);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            MethodInvocationTree mit = (MethodInvocationTree)tp.getLeaf();
            ExpressionTree param = mit.getArguments().get(0);
            List<List<TreePath>> sorted = Utilities.splitStringConcatenationToElements((CompilationInfo)copy, new TreePath(tp, param));
            ExpressionTree site = ((MemberSelectTree)mit.getMethodSelect()).getExpression();
            TreeMaker make = copy.getTreeMaker();
            for (List<TreePath> cluster : sorted) {
                StringBuilder literal = new StringBuilder();
                ExpressionTree singleLeaf = null;
                ExpressionTree arg = null;
                if (cluster.size() == 1 && !Utilities.isConstantString((CompilationInfo)copy, cluster.get(0), true)) {
                    arg = (ExpressionTree)cluster.get(0).getLeaf();
                } else {
                    for (TreePath p : cluster) {
                        ExpressionTree l = (ExpressionTree)p.getLeaf();
                        if (Utilities.isStringOrCharLiteral(l)) {
                            singleLeaf = literal.length() == 0 ? l : null;
                            literal.append(((LiteralTree)l).getValue().toString());
                            continue;
                        }
                        arg = this.merge(make, arg, singleLeaf, literal, l);
                        singleLeaf = null;
                    }
                }
                arg = this.merge(make, arg, singleLeaf, literal, null);
                site = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(site, (CharSequence)"append"), Collections.singletonList(arg));
            }
            copy.rewrite((Tree)mit, (Tree)site);
        }
    }
}

