/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.support.ReferencesCount;
import org.netbeans.modules.editor.java.Utilities;

final class LazySortText
implements CharSequence {
    private final String simpleName;
    private final String enclName;
    private final ElementHandle<TypeElement> handle;
    private final ReferencesCount referencesCount;
    private String importanceLevel = null;

    LazySortText(String simpleName, String enclName, ElementHandle<TypeElement> handle, ReferencesCount referencesCount) {
        this.simpleName = simpleName;
        this.enclName = enclName != null ? Utilities.getImportanceLevel(enclName) + "#" + enclName : "";
        this.handle = handle;
        this.referencesCount = referencesCount;
    }

    @Override
    public int length() {
        return this.simpleName.length() + this.enclName.length() + 10;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (index < this.simpleName.length()) {
            return this.simpleName.charAt(index);
        }
        index -= this.simpleName.length();
        if (index-- == 0) {
            return '#';
        }
        if (index < 8) {
            return this.getImportanceLevel().charAt(index);
        }
        index -= 8;
        if (index-- == 0) {
            return '#';
        }
        return this.enclName.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String toString() {
        return new StringBuilder(this).toString();
    }

    private String getImportanceLevel() {
        if (this.importanceLevel == null) {
            this.importanceLevel = String.format("%8d", Utilities.getImportanceLevel(this.referencesCount, this.handle));
        }
        return this.importanceLevel;
    }

    public static CharSequence link(CharSequence first, CharSequence second) {
        return new LinkedLazyCharSequence(first, second);
    }

    public static CharSequence link(CharSequence first, CharSequence second, CharSequence third) {
        return new LinkedLazyCharSequence(first, new LinkedLazyCharSequence(second, third));
    }

    private static final class LinkedLazyCharSequence
    implements CharSequence {
        private final CharSequence first;
        private final CharSequence second;
        private final int length;

        private LinkedLazyCharSequence(CharSequence first, CharSequence second) {
            this.first = first;
            this.second = second;
            this.length = first.length() + second.length() + 1;
        }

        @Override
        public char charAt(int index) {
            if (index < this.first.length()) {
                return this.first.charAt(index);
            }
            index -= this.first.length();
            if (index-- == 0) {
                return '#';
            }
            return this.second.charAt(index);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

