/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.SymbolPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.builtins.JSSymbolObject;

public final class SymbolPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<SymbolPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new SymbolPrototypeBuiltins();

    protected SymbolPrototypeBuiltins() {
        super(JSSymbol.PROTOTYPE_NAME, SymbolPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SymbolPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return SymbolPrototypeBuiltinsFactory.SymbolToStringNodeGen.create(context, builtin, SymbolPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: 
            case 2: {
                return SymbolPrototypeBuiltinsFactory.SymbolValueOfNodeGen.create(context, builtin, SymbolPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 3: {
                return SymbolPrototypeBuiltinsFactory.SymbolGetDescriptionNodeGen.create(context, builtin, SymbolPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SymbolPrototype implements BuiltinEnum<SymbolPrototype>
    {
        toString(0),
        valueOf(0),
        _toPrimitive(1){

            @Override
            public Object getKey() {
                return Symbol.SYMBOL_TO_PRIMITIVE;
            }

            @Override
            public boolean isWritable() {
                return false;
            }
        }
        ,
        description(0);

        private final int length;

        private SymbolPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            if (this == description) {
                return 10;
            }
            return 6;
        }

        @Override
        public boolean isGetter() {
            return this == description;
        }
    }

    public static abstract class SymbolToStringNode
    extends JSBuiltinNode {
        protected SymbolToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static TruffleString symbolToString(Symbol thisObj) {
            return thisObj.toTString();
        }

        @Specialization
        protected static TruffleString symbolObjectToString(JSSymbolObject thisObj) {
            return SymbolToStringNode.symbolToString(thisObj.getSymbol());
        }

        @Fallback
        protected final TruffleString notSymbol(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    public static abstract class SymbolValueOfNode
    extends JSBuiltinNode {
        protected SymbolValueOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static Symbol symbol(Symbol thisObj) {
            return thisObj;
        }

        @Specialization
        protected static Symbol symbolObject(JSSymbolObject thisObj) {
            return thisObj.getSymbol();
        }

        @Fallback
        protected final Symbol notSymbol(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }

    public static abstract class SymbolGetDescriptionNode
    extends JSBuiltinNode {
        protected SymbolGetDescriptionNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static Object symbol(Symbol thisObj) {
            return thisObj.getDescription();
        }

        @Specialization
        protected static Object symbolObject(JSSymbolObject thisObj) {
            return thisObj.getSymbol().getDescription();
        }

        @Fallback
        protected final Object notSymbol(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }
}

