/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainYearMonthPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerThrowOnInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.TemporalAddDateNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarGetterNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalRoundDurationNode;
import com.oracle.truffle.js.nodes.temporal.TemporalYearMonthFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalYearMonthNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;
import java.util.List;

public class TemporalPlainYearMonthPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainYearMonthPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainYearMonthPrototypeBuiltins();

    protected TemporalPlainYearMonthPrototypeBuiltins() {
        super(JSTemporalPlainYearMonth.PROTOTYPE_NAME, TemporalPlainYearMonthPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainYearMonthPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthGetterNodeGen.create(context, builtin, builtinEnum, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 9: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthAddSubNodeGen.create(context, builtin, 1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 10: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthAddSubNodeGen.create(context, builtin, -1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 11: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthUntilSinceNodeGen.create(context, builtin, 1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 12: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthUntilSinceNodeGen.create(context, builtin, -1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 8: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthWithNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 13: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthEqualsNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 18: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthToPlainDateNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 19: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthGetISOFieldsNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 14: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthToStringNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 15: 
            case 16: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthToLocaleStringNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 17: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthValueOfNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalPlainYearMonthPrototype implements BuiltinEnum<TemporalPlainYearMonthPrototype>
    {
        calendar(0),
        year(0),
        month(0),
        monthCode(0),
        daysInMonth(0),
        daysInYear(0),
        monthsInYear(0),
        inLeapYear(0),
        with(1),
        add(1),
        subtract(1),
        until(1),
        since(1),
        equals(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0),
        toPlainDate(1),
        getISOFields(0);

        private final int length;

        private TemporalPlainYearMonthPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(calendar, new TemporalPlainYearMonthPrototype[]{year, month, monthCode, daysInMonth, daysInYear, monthsInYear, inLeapYear}).contains(this);
        }
    }

    public static abstract class JSTemporalPlainYearMonthGetterNode
    extends JSBuiltinNode {
        protected final TemporalPlainYearMonthPrototype property;

        protected JSTemporalPlainYearMonthGetterNode(JSContext context, JSBuiltin builtin, TemporalPlainYearMonthPrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected Object dateGetter(JSTemporalPlainYearMonthObject temporalYM, @Cached TemporalCalendarGetterNode calendarGetterNode) {
            switch (this.property.ordinal()) {
                case 0: {
                    return temporalYM.getCalendar();
                }
                case 1: {
                    return TemporalUtil.calendarYear(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 2: {
                    return TemporalUtil.calendarMonth(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 3: {
                    return TemporalUtil.calendarMonthCode(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 5: {
                    return TemporalUtil.calendarDaysInYear(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 4: {
                    return TemporalUtil.calendarDaysInMonth(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 6: {
                    return TemporalUtil.calendarMonthsInYear(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
                case 7: {
                    return TemporalUtil.calendarInLeapYear(calendarGetterNode, temporalYM.getCalendar(), temporalYM);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int operation;
        @Node.Child
        private GetMethodNode getMethodDateAddNode;
        @Node.Child
        private GetMethodNode getMethodDateUntilNode;

        protected JSTemporalPlainYearMonthAddSubNode(JSContext context, JSBuiltin builtin, int operation) {
            super(context, builtin);
            this.operation = operation;
            this.getMethodDateAddNode = GetMethodNode.create(context, TemporalConstants.DATE_ADD);
            this.getMethodDateUntilNode = GetMethodNode.create(context, TemporalConstants.DATE_UNTIL);
        }

        @Specialization
        protected JSTemporalPlainYearMonthObject addDurationToOrSubtractDurationFromPlainYearMonth(JSTemporalPlainYearMonthObject ym, Object temporalDurationLike, Object optParam, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached TemporalAddDateNode addDateNode, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarGetterNode calendarGetterNode, @Cached JSToIntegerThrowOnInfinityNode toIntNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            JSRealm realm = this.getRealm();
            if (this.operation == -1) {
                duration = JSTemporalDuration.createNegatedTemporalDuration(this.getContext(), realm, duration);
            }
            TimeDurationRecord balanceResult = TemporalUtil.balanceTimeDuration(duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds(), TemporalUtil.Unit.DAY);
            int sign = TemporalUtil.durationSign(duration.getYears(), duration.getMonths(), duration.getWeeks(), balanceResult.days(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            JSDynamicObject calendar = ym.getCalendar();
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateAddDateUntil(calendar, this.getMethodDateAddNode.executeWithTarget((Object)calendar), this.getMethodDateUntilNode.executeWithTarget((Object)calendar));
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), ym, fieldNames, TemporalUtil.listEmpty);
            int day = 0;
            if (sign < 0) {
                Object dayFromCalendar = TemporalUtil.calendarDaysInMonth(calendarGetterNode, calendar, ym);
                day = TemporalUtil.toPositiveIntegerConstrainInt(dayFromCalendar, toIntNode, this, errorBranch);
            } else {
                day = 1;
            }
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), fields, TemporalConstants.DAY, day);
            JSTemporalPlainDateObject date = dateFromFieldsNode.execute(calendar, fields, (Object)Undefined.instance);
            JSTemporalDurationObject durationToAdd = JSTemporalDuration.createTemporalDuration(this.getContext(), realm, duration.getYears(), duration.getMonths(), duration.getWeeks(), balanceResult.days(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
            JSTemporalPlainDateObject addedDate = addDateNode.execute(calendarRec, date, durationToAdd, options);
            JSObject addedDateFields = TemporalUtil.prepareTemporalFields(this.getContext(), addedDate, fieldNames, TemporalUtil.listEmpty);
            return yearMonthFromFieldsNode.execute(calendar, addedDateFields, options);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDurationLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final int sign;
        @Node.Child
        private GetMethodNode getMethodDateAddNode;
        @Node.Child
        private GetMethodNode getMethodDateUntilNode;

        protected JSTemporalPlainYearMonthUntilSinceNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
            this.getMethodDateAddNode = GetMethodNode.create(context, TemporalConstants.DATE_ADD);
            this.getMethodDateUntilNode = GetMethodNode.create(context, TemporalConstants.DATE_UNTIL);
        }

        @Specialization
        protected JSTemporalDurationObject differenceTemporalPlainYearMonth(JSTemporalPlainYearMonthObject thisYearMonth, Object otherParam, Object optParam, @Cached InlinedConditionProfile unitIsMonth, @Cached JSToStringNode toStringNode, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached JSToNumberNode toNumberNode, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode, @Cached TemporalGetOptionNode getOptionNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalRoundDurationNode roundDurationNode, @Cached ToTemporalYearMonthNode toTemporalYearMonthNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalPlainYearMonthObject other = toTemporalYearMonthNode.execute(otherParam, Undefined.instance);
            JSDynamicObject calendar = thisYearMonth.getCalendar();
            if (!TemporalUtil.calendarEquals(calendar, other.getCalendar(), toStringNode)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorIdenticalCalendarExpected();
            }
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            List<TruffleString> disallowedUnits = TemporalUtil.listWDHMSMMN;
            TemporalUtil.Unit smallestUnit = JSTemporalPlainYearMonthUntilSinceNode.toSmallestTemporalUnit(options, disallowedUnits, TemporalConstants.MONTH, equalNode, getOptionNode, this, errorBranch);
            TemporalUtil.Unit largestUnit = JSTemporalPlainYearMonthUntilSinceNode.toLargestTemporalUnit(options, disallowedUnits, TemporalConstants.AUTO, TemporalUtil.Unit.YEAR, equalNode, getOptionNode, this, errorBranch);
            TemporalUtil.validateTemporalUnitRange(largestUnit, smallestUnit);
            TemporalUtil.RoundingMode roundingMode = JSTemporalPlainYearMonthUntilSinceNode.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            if (this.sign == -1) {
                roundingMode = TemporalUtil.negateTemporalRoundingMode(roundingMode);
            }
            double roundingIncrement = TemporalUtil.toTemporalRoundingIncrement(options, null, false, this.isObjectNode, toNumberNode);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listMCY);
            JSObject otherFields = TemporalUtil.prepareTemporalFields(this.getContext(), other, fieldNames, TemporalUtil.listEmpty);
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), otherFields, TemporalConstants.DAY, 1);
            JSTemporalPlainDateObject otherDate = dateFromFieldsNode.execute(calendar, otherFields, (Object)Undefined.instance);
            JSObject thisFields = TemporalUtil.prepareTemporalFields(this.getContext(), thisYearMonth, fieldNames, TemporalUtil.listEmpty);
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), thisFields, TemporalConstants.DAY, 1);
            JSTemporalPlainDateObject thisDate = dateFromFieldsNode.execute(calendar, thisFields, (Object)Undefined.instance);
            Object dateAdd = this.getMethodDateAddNode.executeWithTarget((Object)calendar);
            Object dateUntil = this.getMethodDateUntilNode.executeWithTarget((Object)calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateAddDateUntil(calendar, dateAdd, dateUntil);
            JSDynamicObject untilOptions = TemporalUtil.mergeLargestUnitOption(this.getContext(), namesNode, options, largestUnit);
            JSTemporalDurationObject result = TemporalUtil.calendarDateUntil(calendarRec, thisDate, otherDate, untilOptions);
            JSRealm realm = this.getRealm();
            if (unitIsMonth.profile((Node)this, TemporalUtil.Unit.MONTH == smallestUnit && roundingIncrement == 1.0)) {
                return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, (double)this.sign * result.getYears(), (double)this.sign * result.getMonths(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
            }
            JSTemporalDurationRecord result2 = roundDurationNode.execute(result.getYears(), result.getMonths(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, (long)roundingIncrement, smallestUnit, roundingMode, thisDate, calendarRec);
            return JSTemporalDuration.createTemporalDuration(this.getContext(), realm, (double)this.sign * result2.getYears(), (double)this.sign * result2.getMonths(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherParam, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthWithNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthWithNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainYearMonthObject with(JSTemporalPlainYearMonthObject ym, Object temporalYearMonthLike, Object optParam, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            if (!this.isObjectNode.executeBoolean(temporalYearMonthLike)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError("Object expected");
            }
            JSDynamicObject ymLikeObj = (JSDynamicObject)((Object)temporalYearMonthLike);
            TemporalUtil.rejectTemporalCalendarType(ymLikeObj, this, errorBranch);
            Object calendarProperty = JSObject.get(ymLikeObj, TemporalConstants.CALENDAR);
            if (calendarProperty != Undefined.instance) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorUnexpectedCalendar();
            }
            Object timezoneProperty = JSObject.get(ymLikeObj, TemporalConstants.TIME_ZONE);
            if (timezoneProperty != Undefined.instance) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorUnexpectedTimeZone();
            }
            JSDynamicObject calendar = ym.getCalendar();
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listMMCY);
            JSObject partialMonthDay = TemporalUtil.preparePartialTemporalFields(this.getContext(), ymLikeObj, fieldNames);
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            JSDynamicObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), ym, fieldNames, TemporalUtil.listEmpty);
            fields = TemporalUtil.calendarMergeFields(this.getContext(), this.getRealm(), calendar, fields, partialMonthDay, namesNode, this, errorBranch);
            fields = TemporalUtil.prepareTemporalFields(this.getContext(), fields, fieldNames, TemporalUtil.listEmpty);
            return yearMonthFromFieldsNode.execute(calendar, fields, options);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalYearMonthLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthEqualsNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthEqualsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean equals(JSTemporalPlainYearMonthObject yearMonth, Object otherParam, @Cached JSToStringNode toStringNode, @Cached ToTemporalYearMonthNode toTemporalYearMonthNode) {
            JSTemporalPlainYearMonthObject other = toTemporalYearMonthNode.execute(otherParam, Undefined.instance);
            if (yearMonth.getMonth() != other.getMonth()) {
                return false;
            }
            if (yearMonth.getDay() != other.getDay()) {
                return false;
            }
            if (yearMonth.getYear() != other.getYear()) {
                return false;
            }
            return TemporalUtil.calendarEquals(yearMonth.getCalendar(), other.getCalendar(), toStringNode);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthToPlainDateNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthToPlainDateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainDateObject toPlainDate(JSTemporalPlainYearMonthObject yearMonth, Object item, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch) {
            if (!JSRuntime.isObject(item)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
            }
            JSDynamicObject calendar = yearMonth.getCalendar();
            List<TruffleString> receiverFieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), yearMonth, receiverFieldNames, TemporalUtil.listEmpty);
            List<TruffleString> inputFieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listD);
            JSObject inputFields = TemporalUtil.prepareTemporalFields(this.getContext(), TemporalUtil.toJSDynamicObject(item, this, errorBranch), inputFieldNames, TemporalUtil.listEmpty);
            JSDynamicObject mergedFields = TemporalUtil.calendarMergeFields(this.getContext(), this.getRealm(), calendar, fields, inputFields, namesNode, this, errorBranch);
            List<TruffleString> mergedFieldNames = TemporalUtil.listJoinRemoveDuplicates(receiverFieldNames, inputFieldNames);
            mergedFields = TemporalUtil.prepareTemporalFields(this.getContext(), mergedFields, mergedFieldNames, TemporalUtil.listEmpty);
            JSObject options = JSOrdinary.createWithNullPrototype(this.getContext());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), options, TemporalConstants.OVERFLOW, TemporalConstants.REJECT);
            return dateFromFieldsNode.execute(calendar, mergedFields, (Object)options);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object item) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthGetISOFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthGetISOFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSObject getISOFields(JSTemporalPlainYearMonthObject ym) {
            JSObject obj = JSOrdinary.create(this.getContext(), this.getRealm());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.CALENDAR, (Object)ym.getCalendar());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_DAY, ym.getDay());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MONTH, ym.getMonth());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_YEAR, ym.getYear());
            return obj;
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalPlainYearMonthObject yearMonth, Object optParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            TemporalUtil.ShowCalendar showCalendar = TemporalUtil.toShowCalendarOption(options, getOptionNode, equalNode);
            return JSTemporalPlainYearMonth.temporalYearMonthToString(yearMonth, showCalendar);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toLocaleString(JSTemporalPlainYearMonthObject yearMonth) {
            return JSTemporalPlainYearMonth.temporalYearMonthToString(yearMonth, TemporalUtil.ShowCalendar.AUTO);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthValueOf
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthValueOf(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object valueOf(Object thisObj) {
            throw Errors.createTypeError("Not supported.");
        }
    }
}

