/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.netbeans.api.debugger.ActionsManagerAdapter;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;

public abstract class LazyActionsManagerListener
extends ActionsManagerAdapter {
    protected abstract void destroy();

    public abstract String[] getProperties();

    static class ContextAware
    extends LazyActionsManagerListener
    implements ContextAwareService<LazyActionsManagerListener> {
        private String serviceName;

        private ContextAware(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public LazyActionsManagerListener forContext(ContextProvider context) {
            return (LazyActionsManagerListener)ContextAwareSupport.createInstance(this.serviceName, context);
        }

        @Override
        protected void destroy() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public String[] getProperties() {
            throw new UnsupportedOperationException("Not supported.");
        }

        static ContextAwareService createService(Map attrs) throws ClassNotFoundException {
            String serviceName = (String)attrs.get("serviceName");
            return new ContextAware(serviceName);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";
    }
}

