/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette.tester.locate;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.modules.php.spi.testing.locate.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class TesterTestLocator
implements TestLocator {
    private final PhpModule phpModule;

    public TesterTestLocator(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    public Set<Locations.Offset> findSources(FileObject testFile) {
        int lastDot;
        FileObject testDirectory;
        FileObject sourceDirectory = this.phpModule.getSourceDirectory();
        assert (sourceDirectory != null) : "Source directory must exist";
        List testDirectories = this.phpModule.getTestDirectories();
        assert (!testDirectories.isEmpty());
        String relativePath = null;
        Iterator iterator = testDirectories.iterator();
        while (iterator.hasNext() && (relativePath = FileUtil.getRelativePath((FileObject)(testDirectory = (FileObject)iterator.next()), (FileObject)testFile)) == null) {
        }
        assert (relativePath != null) : "File " + testFile + "must be found underneath " + testDirectories;
        List extensions = FileUtil.getMIMETypeExtensions((String)"text/x-php5");
        HashSet<Locations.Offset> result = new HashSet<Locations.Offset>();
        while ((lastDot = relativePath.lastIndexOf(46)) != -1) {
            relativePath = relativePath.substring(0, lastDot);
            for (String extension : extensions) {
                FileObject fileObject = sourceDirectory.getFileObject(relativePath + "." + extension);
                if (fileObject == null || !FileUtils.isPhpFile((FileObject)fileObject)) continue;
                result.add(new Locations.Offset(fileObject, -1));
            }
        }
        return result;
    }

    public Set<Locations.Offset> findTests(FileObject testedFile) {
        FileObject testDirectory;
        FileObject sourceDirectory = this.phpModule.getSourceDirectory();
        assert (sourceDirectory != null) : "Source directory must exist";
        List testDirectories = this.phpModule.getTestDirectories();
        assert (!testDirectories.isEmpty());
        String relativePath = FileUtil.getRelativePath((FileObject)sourceDirectory, (FileObject)testedFile.getParent());
        assert (relativePath != null) : "File " + testedFile.getParent() + "must be found underneath " + sourceDirectory;
        FileObject parentTestFolder = null;
        Iterator iterator = testDirectories.iterator();
        while (iterator.hasNext() && (parentTestFolder = (testDirectory = (FileObject)iterator.next()).getFileObject(relativePath)) == null) {
        }
        if (parentTestFolder == null) {
            return Collections.emptySet();
        }
        HashSet<Locations.Offset> result = new HashSet<Locations.Offset>();
        for (FileObject child : parentTestFolder.getChildren()) {
            if (!child.getName().startsWith(testedFile.getName()) || !FileUtils.isPhpFile((FileObject)child)) continue;
            result.add(new Locations.Offset(child, -1));
        }
        return result;
    }
}

