/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolLocation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.Icons;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class BaseSymbolProvider {
    private static final Pattern WORD_START = Pattern.compile("(^|[^\\p{L}])(\\p{L})");
    private final AtomicBoolean cancel = new AtomicBoolean();
    private CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> currentQuery;
    private static final Logger LOG = Logger.getLogger(BaseSymbolProvider.class.getName());

    public String name() {
        return "lsp-client";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeSymbolNames(SearchType searchType, String searchText, BiConsumer<Either<SymbolInformation, WorkspaceSymbol>, String> found) {
        this.cancel.set(false);
        ArrayList<CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>>> queries = new ArrayList<CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>>>();
        try {
            for (LSPBindings b : LSPBindings.getAllBindings()) {
                if (this.cancel.get()) {
                    return;
                }
                queries.add(b.getWorkspaceService().symbol(new WorkspaceSymbolParams(searchText)));
            }
        }
        finally {
            if (this.cancel.get()) {
                if (this.currentQuery != null) {
                    this.currentQuery.cancel(true);
                }
                queries.forEach(cf -> cf.cancel(true));
            }
            this.currentQuery = null;
        }
    }

    public void cancel() {
        this.cancel.set(true);
        if (this.currentQuery != null) {
            this.currentQuery.cancel(true);
        }
    }

    public void cleanup() {
    }

    public static interface BaseSymbolDescriptor {
        public Either<SymbolInformation, WorkspaceSymbol> getInfo();

        default public Icon getIcon() {
            return Icons.getSymbolIcon(this.getInfo().isLeft() ? ((SymbolInformation)this.getInfo().getLeft()).getKind() : ((WorkspaceSymbol)this.getInfo().getRight()).getKind());
        }

        default public String getSymbolName() {
            return this.getInfo().isLeft() ? ((SymbolInformation)this.getInfo().getLeft()).getName() : ((WorkspaceSymbol)this.getInfo().getRight()).getName();
        }

        default public String getOwnerName() {
            String container;
            String string = container = this.getInfo().isLeft() ? ((SymbolInformation)this.getInfo().getLeft()).getContainerName() : ((WorkspaceSymbol)this.getInfo().getRight()).getContainerName();
            if (container == null || "".equals(container)) {
                String uri = this.getUri();
                container = uri.substring(uri.lastIndexOf(47) + 1);
            }
            return container;
        }

        default public String getProjectName() {
            return this.getProjectInformation().map(pi -> pi.getDisplayName()).orElse(null);
        }

        default public Icon getProjectIcon() {
            return this.getProjectInformation().map(pi -> pi.getIcon()).orElse(null);
        }

        default public Optional<ProjectInformation> getProjectInformation() {
            Project owningProject;
            FileObject file = this.getFileObject();
            if (file != null && (owningProject = FileOwnerQuery.getOwner((FileObject)file)) != null) {
                return Optional.of(ProjectUtils.getInformation((Project)owningProject));
            }
            return Optional.empty();
        }

        default public FileObject getFileObject() {
            try {
                URI target = URI.create(this.getUri());
                return URLMapper.findFileObject((URL)target.toURL());
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        default public int getOffset() {
            return -1;
        }

        default public void open() {
            Utils.open(this.getUri(), this.getRange());
        }

        default public String getUri() {
            if (this.getInfo().isLeft()) {
                return ((SymbolInformation)this.getInfo().getLeft()).getLocation().getUri();
            }
            Either<Location, WorkspaceSymbolLocation> location = ((WorkspaceSymbol)this.getInfo().getRight()).getLocation();
            if (location.isLeft()) {
                return ((Location)location.getLeft()).getUri();
            }
            return ((WorkspaceSymbolLocation)location.getRight()).getUri();
        }

        default public Range getRange() {
            if (this.getInfo().isLeft()) {
                return ((SymbolInformation)this.getInfo().getLeft()).getLocation().getRange();
            }
            Either<Location, WorkspaceSymbolLocation> location = ((WorkspaceSymbol)this.getInfo().getRight()).getLocation();
            if (location.isLeft()) {
                return ((Location)location.getLeft()).getRange();
            }
            return new Range(new Position(0, 0), new Position(0, 0));
        }
    }
}

