/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.textile.core.Textile;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class PreformattedBlock
extends Block {
    private static final int LINE_REMAINDER_GROUP_OFFSET = 9;
    private static final int EXTENDED_GROUP = 8;
    static final Pattern startPattern = Pattern.compile("pre(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\(\\)]+))?\\))|(?:\\{([^\\{\\}]+)\\})|(?:\\[([^\\[\\]]+)\\])){0,3}\\.(\\.)?\\s+(.*)");
    private boolean extended;
    private int blockLineCount = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        String lineText;
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            Textile.configureAttributes(attributes, this.matcher, 1, true);
            offset = this.matcher.start(9);
            this.extended = this.matcher.group(8) != null;
            this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, attributes);
        }
        if (this.markupLanguage.isEmptyLine(line) && !this.extended) {
            this.setClosed(true);
            return 0;
        }
        if (this.extended && Textile.explicitBlockBegins(line, offset)) {
            this.setClosed(true);
            return offset;
        }
        ++this.blockLineCount;
        String string = lineText = offset > 0 ? line.substring(offset) : line;
        if (this.blockLineCount > 1 || lineText.trim().length() > 0) {
            this.builder.characters(lineText);
            this.builder.characters("\n");
        }
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

