/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;

public class AddDefaultCase
implements ErrorRule<Void> {
    private static final Set<String> CODES = Set.of("compiler.err.not.exhaustive", "compiler.err.not.exhaustive.statement");
    private static final String THROW_ISE = "throw new IllegalStateException(\"Unexpected value: \" + %1$s);";

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        return List.of(new AddDefaultCaseFix(info, treePath).toEditorFix());
    }

    public String getId() {
        return AddDefaultCase.class.getName();
    }

    public String getDisplayName() {
        return Bundle.FIX_Add_Default_Case();
    }

    public void cancel() {
    }

    private static final class AddDefaultCaseFix
    extends JavaFix {
        public AddDefaultCaseFix(CompilationInfo info, TreePath path) {
            super(info, path);
        }

        protected String getText() {
            return Bundle.FIX_Add_Default_Case();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreeMaker make = wc.getTreeMaker();
            TreePath path = ctx.getPath();
            switch (path.getLeaf().getKind()) {
                case SWITCH_EXPRESSION: {
                    SwitchExpressionTree expTree = (SwitchExpressionTree)path.getLeaf();
                    List<? extends CaseTree> cases = expTree.getCases();
                    if (cases.isEmpty()) {
                        return;
                    }
                    ParenthesizedTree expression = (ParenthesizedTree)expTree.getExpression();
                    String text = AddDefaultCase.THROW_ISE.formatted(expression.toString());
                    StatementTree parseStatement = wc.getTreeUtilities().parseStatement(text, new SourcePositions[1]);
                    CaseTree caseSwitchPatterns = cases.get(0).getCaseKind() == CaseTree.CaseKind.RULE ? make.CasePatterns(List.of(), (Tree)parseStatement) : make.CasePatterns(List.of(), List.of(parseStatement));
                    ArrayList<? extends CaseTree> newCases = new ArrayList<CaseTree>(cases.size() + 1);
                    newCases.addAll(cases);
                    newCases.add(caseSwitchPatterns);
                    Tree switchExpression = make.SwitchExpression((ExpressionTree)expression, newCases);
                    wc.rewrite((Tree)expTree, switchExpression);
                    break;
                }
                case SWITCH: {
                    CaseTree caseSwitchPatterns;
                    SwitchTree switchTree = (SwitchTree)path.getLeaf();
                    List<? extends CaseTree> cases = switchTree.getCases();
                    if (cases.isEmpty()) {
                        return;
                    }
                    ExpressionTree expression = ((ParenthesizedTree)switchTree.getExpression()).getExpression();
                    String text = AddDefaultCase.THROW_ISE.formatted(expression.toString());
                    StatementTree parseStatement = wc.getTreeUtilities().parseStatement(text, new SourcePositions[1]);
                    if (cases.get(0).getCaseKind() == CaseTree.CaseKind.RULE) {
                        caseSwitchPatterns = make.CasePatterns(List.of(), (Tree)parseStatement);
                    } else {
                        AddDefaultCaseFix.handleLastCase(cases.get(cases.size() - 1), wc, make);
                        caseSwitchPatterns = make.CasePatterns(List.of(), List.of(parseStatement));
                    }
                    SwitchTree insertSwitchCase = make.addSwitchCase(switchTree, caseSwitchPatterns);
                    wc.rewrite((Tree)switchTree, (Tree)insertSwitchCase);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(path.getLeaf().getKind() + " not implemented");
                }
            }
        }

        private static void handleLastCase(CaseTree lastCase, WorkingCopy wc, TreeMaker make) {
            List<? extends StatementTree> statements = lastCase.getStatements();
            if (statements.isEmpty() || !(statements.get(statements.size() - 1) instanceof BreakTree)) {
                ArrayList<? extends StatementTree> expanded = new ArrayList<StatementTree>(statements.size() + 1);
                expanded.addAll(statements);
                expanded.add(make.Break(null));
                wc.rewrite((Tree)lastCase, (Tree)make.CasePatterns(lastCase.getLabels(), expanded));
            }
        }
    }
}

