/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import org.netbeans.lib.ddl.impl.AddColumn;
import org.netbeans.lib.ddl.impl.CreateIndex;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.lib.ddl.util.CommandBuffer;
import org.netbeans.modules.db.explorer.dlg.ColumnItem;

public class AddTableColumnDDL {
    private Specification spec;
    private String schema;
    private String tablename;

    public AddTableColumnDDL(Specification spec, String schema, String tablename) {
        this.spec = spec;
        this.schema = schema;
        this.tablename = tablename;
    }

    public boolean execute(String colname, ColumnItem citem) throws Exception {
        assert (citem != null);
        assert (colname != null);
        CommandBuffer cbuff = new CommandBuffer();
        AddColumn cmd = this.spec.createCommandAddColumn(this.tablename);
        cmd.setObjectOwner(this.schema);
        TableColumn col = null;
        col = citem.isPrimaryKey() ? cmd.createPrimaryKeyColumn(colname) : (citem.isUnique() ? cmd.createUniqueColumn(colname) : (TableColumn)cmd.createColumn(colname));
        col.setColumnType(Specification.getType(citem.getType().getType()));
        col.setColumnSize(citem.getSize());
        col.setDecimalSize(citem.getScale());
        col.setNullAllowed(citem.allowsNull());
        if (citem.hasDefaultValue()) {
            col.setDefaultValue(citem.getDefaultValue());
        }
        if (citem.hasCheckConstraint()) {
            col.setCheckCondition(citem.getCheckConstraint());
        }
        cbuff.add(cmd);
        if (citem.isIndexed() && !citem.isPrimaryKey() && !citem.isUnique()) {
            CreateIndex xcmd = this.spec.createCommandCreateIndex(this.tablename);
            xcmd.setIndexName(this.tablename + "_" + colname + "_idx");
            xcmd.setIndexType(new String());
            xcmd.setObjectOwner(this.schema);
            xcmd.specifyNewColumn(colname);
            cbuff.add(xcmd);
        }
        cbuff.execute();
        return cbuff.wasException();
    }
}

