/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.breakpoints.BreakpointModel;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.netbeans.modules.php.dbgp.packets.FeatureGetCommand;
import org.netbeans.modules.php.dbgp.packets.FeatureSetCommand;
import org.w3c.dom.Node;

public class FeatureSetResponse
extends DbgpResponse {
    private static final String SUCCESS = "success";
    private static final String FEATURE_NAME = "feature_name";
    private static final String ERROR = "error";

    FeatureSetResponse(Node node) {
        super(node);
    }

    public String getFeature() {
        return FeatureSetResponse.getAttribute(this.getNode(), FEATURE_NAME);
    }

    public boolean isSuccess() {
        return FeatureSetResponse.getBoolean(this.getNode(), SUCCESS);
    }

    @Override
    public void process(DebugSession session, DbgpCommand command) {
        String feature;
        if (command instanceof FeatureSetCommand && (feature = ((FeatureSetCommand)command).getFeature()).equals(FeatureGetCommand.Feature.BREAKPOINT_DETAILS.toString())) {
            Node error = FeatureSetResponse.getChild(this.getNode(), ERROR);
            this.setSearchCurrentBreakpointById(session, error == null);
        }
    }

    private void setSearchCurrentBreakpointById(DebugSession session, boolean value) {
        BreakpointModel breakpointModel;
        DebugSession.IDESessionBridge bridge = session.getBridge();
        if (bridge != null && (breakpointModel = bridge.getBreakpointModel()) != null) {
            breakpointModel.setSearchCurrentBreakpointById(value);
        }
    }
}

