/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;
import org.netbeans.modules.java.lsp.server.ui.IOContext;

abstract class WorkspaceIOContext
extends IOContext {
    WorkspaceIOContext() {
    }

    @Override
    protected void stdIn(String line) throws IOException {
    }

    @Override
    protected InputStream getStdIn() throws IOException {
        return new EmptyBlockingInputStream();
    }

    @Override
    protected void stdOut(String line) {
        if ("\n".equals(line)) {
            return;
        }
        if (this.client() != null) {
            this.client().logMessage(new MessageParams(MessageType.Info, line));
        }
    }

    @Override
    protected void stdErr(String line) {
        if ("\n".equals(line)) {
            return;
        }
        if (this.client() != null) {
            this.client().logMessage(new MessageParams(MessageType.Error, line));
        }
    }

    @Override
    protected boolean isValid() {
        return this.client() != null;
    }

    protected abstract LanguageClient client();

    private static class EmptyBlockingInputStream
    extends InputStream {
        private boolean closed = false;

        private EmptyBlockingInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            EmptyBlockingInputStream emptyBlockingInputStream = this;
            synchronized (emptyBlockingInputStream) {
                if (!this.closed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        throw new IOException(ex);
                    }
                }
                this.closed = false;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            EmptyBlockingInputStream emptyBlockingInputStream = this;
            synchronized (emptyBlockingInputStream) {
                this.closed = true;
                this.notifyAll();
            }
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int available() throws IOException {
            return 0;
        }
    }
}

