/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.impl.SchemaImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.schema.model.impl.Util;
import org.netbeans.modules.xml.schema.model.impl.resolver.MultivalueMap;
import org.netbeans.modules.xml.schema.model.impl.resolver.ResolveSession;
import org.netbeans.modules.xml.xam.NamedReferenceable;

public class IncludeResolver {
    public static <T extends NamedReferenceable> T resolve(SchemaModelImpl sModel, String namespace, String localName, Class<T> type) {
        ResolveSession session = new ResolveSession(sModel, namespace);
        T found = null;
        found = IncludeResolver.resolveRecursiveDown(sModel, localName, type, session);
        if (found != null) {
            return found;
        }
        found = IncludeResolver.resolveUpwards(sModel, namespace, localName, type, session);
        if (found != null) {
            return found;
        }
        return null;
    }

    static <T extends NamedReferenceable> T resolveRecursiveDown(SchemaModelImpl sModel, String localName, Class<T> type, ResolveSession session) {
        T found = null;
        ResolveSession.Checked checked = session.getChecked(sModel);
        if (!checked.itself) {
            found = sModel.findByNameAndType(localName, type);
            if (found != null) {
                return found;
            }
            checked.itself = true;
        }
        if (!checked.included) {
            checked.included = true;
            Collection<SchemaModelReference> modelRefs = sModel.getNotImportRefrences();
            for (SchemaModelReference ref : modelRefs) {
                assert (!(ref instanceof Import));
                SchemaModelImpl resolvedRef = sModel.resolve(ref);
                if (resolvedRef == null || (found = (T)IncludeResolver.resolveRecursiveDown(resolvedRef, localName, type, session)) == null) continue;
                return found;
            }
        }
        return null;
    }

    static <T extends NamedReferenceable> T resolveUpwards(SchemaModelImpl sModel, String namespace, String localName, Class<T> type, ResolveSession session) {
        Set<SchemaModelImpl> models = IncludeResolver.getMegaIncludedModels(sModel, namespace, session);
        for (SchemaModelImpl sm : models) {
            ResolveSession.Checked checked = session.getChecked(sm);
            if (sm == null || checked.itself) continue;
            T found = sm.findByNameAndType(localName, type);
            if (found != null) {
                return found;
            }
            checked.itself = true;
        }
        return null;
    }

    static Set<SchemaModelImpl> getMegaIncludedModels(SchemaModelImpl sModel, String soughtNs, ResolveSession session) {
        SchemaImpl mySchema = sModel.getSchema();
        if (mySchema == null) {
            return Collections.EMPTY_SET;
        }
        String myTargetNs = mySchema.getTargetNamespace();
        if (myTargetNs != null && !Util.equal(soughtNs, myTargetNs)) {
            return Collections.EMPTY_SET;
        }
        MultivalueMap.BidirectionalGraph<SchemaModelImpl> graph = session.getInclusionGraph(sModel, soughtNs);
        if (graph.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Set<SchemaModelImpl> inclusionRoots = graph.getRoots(sModel, false);
        HashSet<SchemaModelImpl> result = new HashSet<SchemaModelImpl>();
        for (SchemaModelImpl root : inclusionRoots) {
            if (!Util.equal(root.getSchema().getTargetNamespace(), soughtNs)) continue;
            MultivalueMap.Utils.populateAllSubItems(graph, root, sModel, result);
        }
        result.remove(sModel);
        return result;
    }
}

