/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveBase;
import org.eclipse.persistence.jpa.Archive;

public class JarInputStreamURLArchive
extends ArchiveBase
implements Archive {
    private List<String> entries = new ArrayList<String>();
    private Logger logger;

    public JarInputStreamURLArchive(URL url, String descriptorLocation) throws IOException {
        this(url, descriptorLocation, Logger.global);
    }

    public JarInputStreamURLArchive(URL url, String descriptorLocation, Logger logger) throws IOException {
        super(url, descriptorLocation);
        logger.entering("JarInputStreamURLArchive", "JarInputStreamURLArchive", new Object[]{url});
        this.logger = logger;
        this.init();
    }

    private void init() throws IOException {
        try (JarInputStream jis = new JarInputStream(new BufferedInputStream(this.rootURL.openStream()));){
            ZipEntry ze;
            while ((ze = jis.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                this.entries.add(ze.getName());
            }
        }
    }

    @Override
    public Iterator<String> getEntries() {
        return this.entries.iterator();
    }

    @Override
    public InputStream getEntry(String entryPath) throws IOException {
        ZipEntry ze;
        if (!this.entries.contains(entryPath)) {
            return null;
        }
        JarInputStream jis = new JarInputStream(new BufferedInputStream(this.rootURL.openStream()));
        while ((ze = jis.getNextEntry()) != null) {
            if (!ze.getName().equals(entryPath)) continue;
            return jis;
        }
        assert (false);
        return null;
    }

    @Override
    public URL getEntryAsURL(String entryPath) throws IOException {
        URL result;
        result = this.entries.contains(entryPath) ? (result = new URL("jar:" + this.rootURL + "!/" + entryPath)) : null;
        return result;
    }

    @Override
    public void close() {
    }
}

