/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.eval;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javascript2.debug.NamesTranslator;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.javascript.debugger.eval.EvaluatorService;
import org.netbeans.modules.web.javascript.debugger.eval.VarNamesTranslatorFactory;
import org.netbeans.modules.web.javascript.debugger.locals.VariablesModel;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.spi.debugger.ContextProvider;

public class EvaluatorServiceImpl
implements EvaluatorService,
Debugger.Listener {
    private static final VariablesModel.ScopedRemoteObject NULL_SCOPED_REMOTE_OBJECT = new VariablesModel.ScopedRemoteObject(null, null, VariablesModel.ViewScope.DEFAULT);
    private static final Logger LOG = Logger.getLogger(EvaluatorServiceImpl.class.getName());
    private final Debugger debugger;
    private final ProjectContext pc;
    private final Map<String, VariablesModel.ScopedRemoteObject> expressionsCache = new HashMap<String, VariablesModel.ScopedRemoteObject>();

    public EvaluatorServiceImpl(ContextProvider contextProvider) {
        this.debugger = (Debugger)contextProvider.lookupFirst(null, Debugger.class);
        this.pc = (ProjectContext)contextProvider.lookupFirst(null, ProjectContext.class);
        this.debugger.addListener((Debugger.Listener)this);
    }

    private static String getKey(CallFrame frame, String expression) {
        return frame.getCallFrameID() + " - " + expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VariablesModel.ScopedRemoteObject evaluateExpression(CallFrame frame, String expression, boolean doCacheResults) {
        VariablesModel.ScopedRemoteObject var;
        RemoteObject prop;
        if (doCacheResults) {
            Map<String, VariablesModel.ScopedRemoteObject> map = this.expressionsCache;
            synchronized (map) {
                VariablesModel.ScopedRemoteObject var2 = this.expressionsCache.get(EvaluatorServiceImpl.getKey(frame, expression));
                if (var2 != null) {
                    if (NULL_SCOPED_REMOTE_OBJECT == var2) {
                        return null;
                    }
                    return var2;
                }
            }
        }
        String rtExpression = expression;
        VarNamesTranslatorFactory vtf = VarNamesTranslatorFactory.get(frame, this.debugger, this.pc.getProject());
        NamesTranslator namesTranslator = vtf.getNamesTranslator();
        if (namesTranslator != null) {
            rtExpression = namesTranslator.reverseTranslate(expression);
        }
        if ((prop = frame.evaluate(rtExpression)) != null) {
            var = new VariablesModel.ScopedRemoteObject(prop, expression, VariablesModel.ViewScope.LOCAL);
        } else {
            LOG.log(Level.WARNING, "expression was not evaluated: '" + expression + "'");
            var = null;
        }
        if (doCacheResults) {
            Map<String, VariablesModel.ScopedRemoteObject> map = this.expressionsCache;
            synchronized (map) {
                if (var != null) {
                    this.expressionsCache.put(EvaluatorServiceImpl.getKey(frame, expression), var);
                } else {
                    this.expressionsCache.put(EvaluatorServiceImpl.getKey(frame, expression), NULL_SCOPED_REMOTE_OBJECT);
                }
            }
        }
        return var;
    }

    public void paused(List<CallFrame> callStack, String reason) {
    }

    public void resumed() {
        this.cleanCache();
    }

    public void reset() {
        this.cleanCache();
    }

    public void enabled(boolean enabled) {
        this.cleanCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache() {
        Map<String, VariablesModel.ScopedRemoteObject> map = this.expressionsCache;
        synchronized (map) {
            this.expressionsCache.clear();
        }
    }
}

