/*
 * Decompiled with CFR 0.152.
 */
package com.github.rzymek.opczip.reader.ordered;

import com.github.rzymek.opczip.reader.InputStreamUtils;
import com.github.rzymek.opczip.reader.skipping.ZipStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public abstract class OrderedZipStreamReader {
    private Map<String, ConsumerEntry> consumers = new HashMap<String, ConsumerEntry>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(InputStream in) throws IOException {
        this.validateDependencies();
        try (ZipStreamReader zip = this.open(in);){
            while (this.hasPendingConsumers()) {
                OutputStream out;
                block25: {
                    ZipEntry entry = zip.nextEntry();
                    if (entry == null) {
                        return;
                    }
                    String name = entry.getName();
                    ConsumerEntry consumer = this.consumers.get(name);
                    if (consumer == null) {
                        zip.skipStream();
                        continue;
                    }
                    if (this.isEveryConsumed(consumer.dependencies)) {
                        this.process(zip.getUncompressedStream(), consumer);
                        this.consumers.entrySet().stream().filter(e -> !((ConsumerEntry)e.getValue()).consumed).filter(e -> ((ConsumerEntry)e.getValue()).dependencies.contains(name)).filter(e -> this.isEveryConsumedBut(((ConsumerEntry)e.getValue()).dependencies, name)).forEach(e -> this.process(ZipStreamReader.uncompressed(this.getTempInputStream((String)e.getKey())), (ConsumerEntry)e.getValue()));
                        continue;
                    }
                    out = this.getTempOutputStream(name);
                    Throwable throwable = null;
                    try {
                        InputStreamUtils.transferTo(zip.getCompressedStream(), out);
                        if (out == null) continue;
                        if (throwable == null) break block25;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    out.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            out.close();
                            throw throwable3;
                        }
                    }
                    try {
                        out.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                out.close();
            }
            return;
        }
    }

    public OrderedZipStreamReader with(Consumer consumer, String entry, String ... dependencies) {
        ConsumerEntry prev = this.consumers.put(entry, new ConsumerEntry(consumer, dependencies));
        if (prev != null) {
            throw new IllegalStateException(entry + " already registered");
        }
        return this;
    }

    private boolean isEveryConsumedBut(Set<String> dependencies, String name) {
        return dependencies.stream().filter(dep -> !dep.equals(name)).noneMatch(this::isUnconsumedDependency);
    }

    private void validateDependencies() {
        this.consumers.forEach((name, consumer) -> {
            Set notProcessedDeps = consumer.dependencies.stream().filter(dep -> !this.consumers.containsKey(dep)).collect(Collectors.toSet());
            if (notProcessedDeps.isEmpty()) {
                return;
            }
            throw new IllegalStateException(name + " has a dependencies that are not registered for processing: " + notProcessedDeps);
        });
    }

    private boolean isEveryConsumed(Set<String> dependencies) {
        return dependencies.stream().noneMatch(this::isUnconsumedDependency);
    }

    protected void process(InputStream in, ConsumerEntry entry) throws UncheckedIOException {
        try {
            entry.processor.accept(in);
            entry.consumed = true;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected abstract OutputStream getTempOutputStream(String var1) throws IOException;

    protected abstract InputStream getTempInputStream(String var1) throws UncheckedIOException;

    protected ZipStreamReader open(InputStream in) {
        return new ZipStreamReader(in);
    }

    private boolean isUnconsumedDependency(String name) {
        return this.consumers.values().stream().filter(e -> !e.consumed).anyMatch(e -> e.dependencies.contains(name));
    }

    private boolean hasPendingConsumers() {
        return this.consumers.values().stream().anyMatch(e -> !e.consumed);
    }

    @FunctionalInterface
    public static interface Consumer {
        public void accept(InputStream var1) throws IOException;
    }

    private static class ConsumerEntry {
        Consumer processor;
        Set<String> dependencies;
        boolean consumed = false;

        ConsumerEntry(Consumer consumer, String ... dependencies) {
            this.processor = consumer;
            this.dependencies = new HashSet<String>(Arrays.asList(dependencies));
        }
    }
}

