# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("activeds.dll")
prototypes = \
    {
        #
        'ADsGetObject': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszPathName", "riid", "ppObject"]),
        #
        'ADsBuildEnumerator': SimTypeFunction([SimTypeBottom(label="IADsContainer"), SimTypePointer(SimTypeBottom(label="IEnumVARIANT"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pADsContainer", "ppEnumVariant"]),
        #
        'ADsFreeEnumerator': SimTypeFunction([SimTypeBottom(label="IEnumVARIANT")], SimTypeInt(signed=True, label="Int32"), arg_names=["pEnumVariant"]),
        #
        'ADsEnumerateNext': SimTypeFunction([SimTypeBottom(label="IEnumVARIANT"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"llVal": SimTypeLongLong(signed=True, label="Int64"), "lVal": SimTypeInt(signed=True, label="Int32"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "parray": SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pllVal": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "__OBSOLETE__VARIANT_PBOOL": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="VARIANT"), offset=0), "byref": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cVal": SimTypeBottom(label="CHAR"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "ullVal": SimTypeLongLong(signed=False, label="UInt64"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pullVal": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "Anonymous": SimStruct({"pvRecord": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pRecInfo": SimTypeBottom(label="IRecordInfo")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="VARIANT", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pEnumVariant", "cElements", "pvar", "pcElementsFetched"]),
        #
        'ADsBuildVarArrayStr': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"llVal": SimTypeLongLong(signed=True, label="Int64"), "lVal": SimTypeInt(signed=True, label="Int32"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "parray": SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pllVal": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "__OBSOLETE__VARIANT_PBOOL": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="VARIANT"), offset=0), "byref": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cVal": SimTypeBottom(label="CHAR"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "ullVal": SimTypeLongLong(signed=False, label="UInt64"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pullVal": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "Anonymous": SimStruct({"pvRecord": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pRecInfo": SimTypeBottom(label="IRecordInfo")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="VARIANT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lppPathNames", "dwPathNames", "pVar"]),
        #
        'ADsBuildVarArrayInt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"llVal": SimTypeLongLong(signed=True, label="Int64"), "lVal": SimTypeInt(signed=True, label="Int32"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "parray": SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pllVal": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "__OBSOLETE__VARIANT_PBOOL": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="VARIANT"), offset=0), "byref": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cVal": SimTypeBottom(label="CHAR"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "ullVal": SimTypeLongLong(signed=False, label="UInt64"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pullVal": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "Anonymous": SimStruct({"pvRecord": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pRecInfo": SimTypeBottom(label="IRecordInfo")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="VARIANT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwObjectTypes", "dwObjectTypes", "pVar"]),
        #
        'ADsOpenObject': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="ADS_AUTHENTICATION_ENUM"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszPathName", "lpszUserName", "lpszPassword", "dwReserved", "riid", "ppObject"]),
        #
        'ADsGetLastError': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpError", "lpErrorBuf", "dwErrorBufLen", "lpNameBuf", "dwNameBufLen"]),
        #
        'ADsSetLastError': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwErr", "pszError", "pszProvider"]),
        #
        'AllocADsMem': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cb"]),
        #
        'FreeADsMem': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pMem"]),
        #
        'ReallocADsMem': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["pOldMem", "cbOld", "cbNew"]),
        #
        'AllocADsStr': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["pStr"]),
        #
        'FreeADsStr': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pStr"]),
        #
        'ReallocADsStr': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ppStr", "pStr"]),
        #
        'ADsEncodeBinaryData': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pbSrcData", "dwSrcLen", "ppszDestData"]),
        #
        'ADsDecodeBinaryData': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szSrcData", "ppbDestData", "pdwDestLen"]),
        #
        'PropVariantToAdsType': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"llVal": SimTypeLongLong(signed=True, label="Int64"), "lVal": SimTypeInt(signed=True, label="Int32"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "parray": SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pllVal": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "__OBSOLETE__VARIANT_PBOOL": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="VARIANT"), offset=0), "byref": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cVal": SimTypeBottom(label="CHAR"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "ullVal": SimTypeLongLong(signed=False, label="UInt64"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pullVal": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "Anonymous": SimStruct({"pvRecord": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pRecInfo": SimTypeBottom(label="IRecordInfo")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="VARIANT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="ADSTYPEENUM"), "Anonymous": SimUnion({"DNString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseExactString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseIgnoreString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "PrintableString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "NumericString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Boolean": SimTypeInt(signed=False, label="UInt32"), "Integer": SimTypeInt(signed=False, label="UInt32"), "OctetString": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_OCTET_STRING", pack=False, align=None), "UTCTime": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), "LargeInteger": SimTypeBottom(label="LARGE_INTEGER"), "ClassName": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "ProviderSpecific": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_PROV_SPECIFIC", pack=False, align=None), "pCaseIgnoreList": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="ADS_CASEIGNORE_LIST"), offset=0), "String": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_CASEIGNORE_LIST", pack=False, align=None), offset=0), "pOctetList": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="ADS_OCTET_LIST"), offset=0), "Length": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_OCTET_LIST", pack=False, align=None), offset=0), "pPath": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "VolumeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Path": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_PATH", pack=False, align=None), offset=0), "pPostalAddress": SimTypePointer(SimStruct({"PostalAddress": SimTypeFixedSizeArray(SimTypePointer(SimTypeChar(label="Char"), offset=0), 6)}, name="ADS_POSTALADDRESS", pack=False, align=None), offset=0), "Timestamp": SimStruct({"WholeSeconds": SimTypeInt(signed=False, label="UInt32"), "EventID": SimTypeInt(signed=False, label="UInt32")}, name="ADS_TIMESTAMP", pack=False, align=None), "BackLink": SimStruct({"RemoteID": SimTypeInt(signed=False, label="UInt32"), "ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_BACKLINK", pack=False, align=None), "pTypedName": SimTypePointer(SimStruct({"ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Level": SimTypeInt(signed=False, label="UInt32"), "Interval": SimTypeInt(signed=False, label="UInt32")}, name="ADS_TYPEDNAME", pack=False, align=None), offset=0), "Hold": SimStruct({"ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Amount": SimTypeInt(signed=False, label="UInt32")}, name="ADS_HOLD", pack=False, align=None), "pNetAddress": SimTypePointer(SimStruct({"AddressType": SimTypeInt(signed=False, label="UInt32"), "AddressLength": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NETADDRESS", pack=False, align=None), offset=0), "pReplicaPointer": SimTypePointer(SimStruct({"ServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ReplicaType": SimTypeInt(signed=False, label="UInt32"), "ReplicaNumber": SimTypeInt(signed=False, label="UInt32"), "Count": SimTypeInt(signed=False, label="UInt32"), "ReplicaAddressHints": SimTypePointer(SimStruct({"AddressType": SimTypeInt(signed=False, label="UInt32"), "AddressLength": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NETADDRESS", pack=False, align=None), offset=0)}, name="ADS_REPLICAPOINTER", pack=False, align=None), offset=0), "pFaxNumber": SimTypePointer(SimStruct({"TelephoneNumber": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NumberOfBits": SimTypeInt(signed=False, label="UInt32"), "Parameters": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_FAXNUMBER", pack=False, align=None), offset=0), "Email": SimStruct({"Address": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Type": SimTypeInt(signed=False, label="UInt32")}, name="ADS_EMAIL", pack=False, align=None), "SecurityDescriptor": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NT_SECURITY_DESCRIPTOR", pack=False, align=None), "pDNWithBinary": SimTypePointer(SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpBinaryValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pszDNString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_DN_WITH_BINARY", pack=False, align=None), offset=0), "pDNWithString": SimTypePointer(SimStruct({"pszStringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszDNString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_DN_WITH_STRING", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="ADSVALUE", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pVariant", "dwNumVariant", "ppAdsValues", "pdwNumValues"]),
        #
        'AdsTypeToPropVariant': SimTypeFunction([SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="ADSTYPEENUM"), "Anonymous": SimUnion({"DNString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseExactString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseIgnoreString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "PrintableString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "NumericString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Boolean": SimTypeInt(signed=False, label="UInt32"), "Integer": SimTypeInt(signed=False, label="UInt32"), "OctetString": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_OCTET_STRING", pack=False, align=None), "UTCTime": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), "LargeInteger": SimTypeBottom(label="LARGE_INTEGER"), "ClassName": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "ProviderSpecific": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_PROV_SPECIFIC", pack=False, align=None), "pCaseIgnoreList": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="ADS_CASEIGNORE_LIST"), offset=0), "String": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_CASEIGNORE_LIST", pack=False, align=None), offset=0), "pOctetList": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="ADS_OCTET_LIST"), offset=0), "Length": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_OCTET_LIST", pack=False, align=None), offset=0), "pPath": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "VolumeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Path": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_PATH", pack=False, align=None), offset=0), "pPostalAddress": SimTypePointer(SimStruct({"PostalAddress": SimTypeFixedSizeArray(SimTypePointer(SimTypeChar(label="Char"), offset=0), 6)}, name="ADS_POSTALADDRESS", pack=False, align=None), offset=0), "Timestamp": SimStruct({"WholeSeconds": SimTypeInt(signed=False, label="UInt32"), "EventID": SimTypeInt(signed=False, label="UInt32")}, name="ADS_TIMESTAMP", pack=False, align=None), "BackLink": SimStruct({"RemoteID": SimTypeInt(signed=False, label="UInt32"), "ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_BACKLINK", pack=False, align=None), "pTypedName": SimTypePointer(SimStruct({"ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Level": SimTypeInt(signed=False, label="UInt32"), "Interval": SimTypeInt(signed=False, label="UInt32")}, name="ADS_TYPEDNAME", pack=False, align=None), offset=0), "Hold": SimStruct({"ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Amount": SimTypeInt(signed=False, label="UInt32")}, name="ADS_HOLD", pack=False, align=None), "pNetAddress": SimTypePointer(SimStruct({"AddressType": SimTypeInt(signed=False, label="UInt32"), "AddressLength": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NETADDRESS", pack=False, align=None), offset=0), "pReplicaPointer": SimTypePointer(SimStruct({"ServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ReplicaType": SimTypeInt(signed=False, label="UInt32"), "ReplicaNumber": SimTypeInt(signed=False, label="UInt32"), "Count": SimTypeInt(signed=False, label="UInt32"), "ReplicaAddressHints": SimTypePointer(SimStruct({"AddressType": SimTypeInt(signed=False, label="UInt32"), "AddressLength": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NETADDRESS", pack=False, align=None), offset=0)}, name="ADS_REPLICAPOINTER", pack=False, align=None), offset=0), "pFaxNumber": SimTypePointer(SimStruct({"TelephoneNumber": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NumberOfBits": SimTypeInt(signed=False, label="UInt32"), "Parameters": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_FAXNUMBER", pack=False, align=None), offset=0), "Email": SimStruct({"Address": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Type": SimTypeInt(signed=False, label="UInt32")}, name="ADS_EMAIL", pack=False, align=None), "SecurityDescriptor": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NT_SECURITY_DESCRIPTOR", pack=False, align=None), "pDNWithBinary": SimTypePointer(SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpBinaryValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pszDNString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_DN_WITH_BINARY", pack=False, align=None), offset=0), "pDNWithString": SimTypePointer(SimStruct({"pszStringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszDNString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_DN_WITH_STRING", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="ADSVALUE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"llVal": SimTypeLongLong(signed=True, label="Int64"), "lVal": SimTypeInt(signed=True, label="Int32"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "parray": SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pllVal": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "__OBSOLETE__VARIANT_PBOOL": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="VARIANT"), offset=0), "byref": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cVal": SimTypeBottom(label="CHAR"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "ullVal": SimTypeLongLong(signed=False, label="UInt64"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pullVal": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "Anonymous": SimStruct({"pvRecord": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pRecInfo": SimTypeBottom(label="IRecordInfo")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="VARIANT", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAdsValues", "dwNumValues", "pVariant"]),
        #
        'AdsFreeAdsValues': SimTypeFunction([SimTypePointer(SimStruct({"dwType": SimTypeInt(signed=False, label="ADSTYPEENUM"), "Anonymous": SimUnion({"DNString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseExactString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "CaseIgnoreString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "PrintableString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "NumericString": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "Boolean": SimTypeInt(signed=False, label="UInt32"), "Integer": SimTypeInt(signed=False, label="UInt32"), "OctetString": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_OCTET_STRING", pack=False, align=None), "UTCTime": SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), "LargeInteger": SimTypeBottom(label="LARGE_INTEGER"), "ClassName": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "ProviderSpecific": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_PROV_SPECIFIC", pack=False, align=None), "pCaseIgnoreList": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="ADS_CASEIGNORE_LIST"), offset=0), "String": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_CASEIGNORE_LIST", pack=False, align=None), offset=0), "pOctetList": SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="ADS_OCTET_LIST"), offset=0), "Length": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_OCTET_LIST", pack=False, align=None), offset=0), "pPath": SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "VolumeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Path": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_PATH", pack=False, align=None), offset=0), "pPostalAddress": SimTypePointer(SimStruct({"PostalAddress": SimTypeFixedSizeArray(SimTypePointer(SimTypeChar(label="Char"), offset=0), 6)}, name="ADS_POSTALADDRESS", pack=False, align=None), offset=0), "Timestamp": SimStruct({"WholeSeconds": SimTypeInt(signed=False, label="UInt32"), "EventID": SimTypeInt(signed=False, label="UInt32")}, name="ADS_TIMESTAMP", pack=False, align=None), "BackLink": SimStruct({"RemoteID": SimTypeInt(signed=False, label="UInt32"), "ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_BACKLINK", pack=False, align=None), "pTypedName": SimTypePointer(SimStruct({"ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Level": SimTypeInt(signed=False, label="UInt32"), "Interval": SimTypeInt(signed=False, label="UInt32")}, name="ADS_TYPEDNAME", pack=False, align=None), offset=0), "Hold": SimStruct({"ObjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Amount": SimTypeInt(signed=False, label="UInt32")}, name="ADS_HOLD", pack=False, align=None), "pNetAddress": SimTypePointer(SimStruct({"AddressType": SimTypeInt(signed=False, label="UInt32"), "AddressLength": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NETADDRESS", pack=False, align=None), offset=0), "pReplicaPointer": SimTypePointer(SimStruct({"ServerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ReplicaType": SimTypeInt(signed=False, label="UInt32"), "ReplicaNumber": SimTypeInt(signed=False, label="UInt32"), "Count": SimTypeInt(signed=False, label="UInt32"), "ReplicaAddressHints": SimTypePointer(SimStruct({"AddressType": SimTypeInt(signed=False, label="UInt32"), "AddressLength": SimTypeInt(signed=False, label="UInt32"), "Address": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NETADDRESS", pack=False, align=None), offset=0)}, name="ADS_REPLICAPOINTER", pack=False, align=None), offset=0), "pFaxNumber": SimTypePointer(SimStruct({"TelephoneNumber": SimTypePointer(SimTypeChar(label="Char"), offset=0), "NumberOfBits": SimTypeInt(signed=False, label="UInt32"), "Parameters": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_FAXNUMBER", pack=False, align=None), offset=0), "Email": SimStruct({"Address": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Type": SimTypeInt(signed=False, label="UInt32")}, name="ADS_EMAIL", pack=False, align=None), "SecurityDescriptor": SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ADS_NT_SECURITY_DESCRIPTOR", pack=False, align=None), "pDNWithBinary": SimTypePointer(SimStruct({"dwLength": SimTypeInt(signed=False, label="UInt32"), "lpBinaryValue": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pszDNString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_DN_WITH_BINARY", pack=False, align=None), offset=0), "pDNWithString": SimTypePointer(SimStruct({"pszStringValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszDNString": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="ADS_DN_WITH_STRING", pack=False, align=None), offset=0)}, name="<anon>", label="None")}, name="ADSVALUE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pAdsValues", "dwNumValues"]),
        #
        'BinarySDToSecurityDescriptor': SimTypeFunction([SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"llVal": SimTypeLongLong(signed=True, label="Int64"), "lVal": SimTypeInt(signed=True, label="Int32"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "parray": SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pllVal": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "__OBSOLETE__VARIANT_PBOOL": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="VARIANT"), offset=0), "byref": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cVal": SimTypeBottom(label="CHAR"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "ullVal": SimTypeLongLong(signed=False, label="UInt64"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pullVal": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "Anonymous": SimStruct({"pvRecord": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pRecInfo": SimTypeBottom(label="IRecordInfo")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="VARIANT", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSecurityDescriptor", "pVarsec", "pszServerName", "userName", "passWord", "dwFlags"]),
        #
        'SecurityDescriptorToBinarySD': SimTypeFunction([SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"vt": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "wReserved2": SimTypeShort(signed=False, label="UInt16"), "wReserved3": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"llVal": SimTypeLongLong(signed=True, label="Int64"), "lVal": SimTypeInt(signed=True, label="Int32"), "bVal": SimTypeChar(label="Byte"), "iVal": SimTypeShort(signed=True, label="Int16"), "fltVal": SimTypeFloat(size=32), "dblVal": SimTypeFloat(size=64), "boolVal": SimTypeShort(signed=True, label="Int16"), "__OBSOLETE__VARIANT_BOOL": SimTypeShort(signed=True, label="Int16"), "scode": SimTypeInt(signed=True, label="Int32"), "cyVal": SimTypeBottom(label="CY"), "date": SimTypeFloat(size=64), "bstrVal": SimTypePointer(SimTypeChar(label="Char"), offset=0), "punkVal": SimTypeBottom(label="IUnknown"), "pdispVal": SimTypeBottom(label="IDispatch"), "parray": SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), "pbVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "piVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "plVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pllVal": SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), "pfltVal": SimTypePointer(SimTypeFloat(size=32), offset=0), "pdblVal": SimTypePointer(SimTypeFloat(size=64), offset=0), "pboolVal": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "__OBSOLETE__VARIANT_PBOOL": SimTypePointer(SimTypeShort(signed=True, label="Int16"), offset=0), "pscode": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pcyVal": SimTypePointer(SimTypeBottom(label="CY"), offset=0), "pdate": SimTypePointer(SimTypeFloat(size=64), offset=0), "pbstrVal": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), "ppunkVal": SimTypePointer(SimTypeBottom(label="IUnknown"), offset=0), "ppdispVal": SimTypePointer(SimTypeBottom(label="IDispatch"), offset=0), "pparray": SimTypePointer(SimTypePointer(SimStruct({"cDims": SimTypeShort(signed=False, label="UInt16"), "fFeatures": SimTypeShort(signed=False, label="UInt16"), "cbElements": SimTypeInt(signed=False, label="UInt32"), "cLocks": SimTypeInt(signed=False, label="UInt32"), "pvData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "rgsabound": SimTypePointer(SimStruct({"cElements": SimTypeInt(signed=False, label="UInt32"), "lLbound": SimTypeInt(signed=True, label="Int32")}, name="SAFEARRAYBOUND", pack=False, align=None), offset=0)}, name="SAFEARRAY", pack=False, align=None), offset=0), offset=0), "pvarVal": SimTypePointer(SimTypeBottom(label="VARIANT"), offset=0), "byref": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cVal": SimTypeBottom(label="CHAR"), "uiVal": SimTypeShort(signed=False, label="UInt16"), "ulVal": SimTypeInt(signed=False, label="UInt32"), "ullVal": SimTypeLongLong(signed=False, label="UInt64"), "intVal": SimTypeInt(signed=True, label="Int32"), "uintVal": SimTypeInt(signed=False, label="UInt32"), "pdecVal": SimTypePointer(SimTypeBottom(label="DECIMAL"), offset=0), "pcVal": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "puiVal": SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), "pulVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "pullVal": SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), "pintVal": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "puintVal": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), "Anonymous": SimStruct({"pvRecord": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pRecInfo": SimTypeBottom(label="IRecordInfo")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None), "decVal": SimTypeBottom(label="DECIMAL")}, name="<anon>", label="None")}, name="VARIANT", pack=False, align=None), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["vVarSecDes", "ppSecurityDescriptor", "pdwSDLength", "pszServerName", "userName", "passWord", "dwFlags"]),
    }

lib.set_prototypes(prototypes)
