/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.feature.json;

import com.jetbrains.mlapi.feature.BooleanFeatureHolder;
import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureDeclaration;
import com.jetbrains.mlapi.feature.NullFeatureHolder;
import com.jetbrains.mlapi.feature.StringFeatureHolder;
import com.jetbrains.mlapi.feature.json.JsonEmptyArrayFeature;
import com.jetbrains.mlapi.feature.json.JsonFloatingArrayFeature;
import com.jetbrains.mlapi.feature.json.JsonFloatingFeature;
import com.jetbrains.mlapi.feature.json.JsonIntegerArrayFeature;
import com.jetbrains.mlapi.feature.json.JsonIntegerFeature;
import com.jetbrains.mlapi.logs.LogsMetadata;
import com.jetbrains.mlapi.logs.ObjectArrayDeclaration;
import com.jetbrains.mlapi.logs.ObjectArrayFeature;
import com.jetbrains.mlapi.logs.ObjectFeature;
import com.jetbrains.mlapi.logs.ObjectFeatureDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \t2\u00020\u0001:\u000e\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&\u0082\u0001\u0002\u0016\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature;", "", "toFeature", "Lcom/jetbrains/mlapi/feature/Feature;", "name", "", "toJsonElement", "Lkotlinx/serialization/json/JsonElement;", "Boolean", "Companion", "EmptyArray", "Floating", "FloatingArray", "Integer", "IntegerArray", "Nested", "Null", "Number", "Object", "ObjectArray", "Primitive", "String", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Nested;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Primitive;", "mlapi-core"})
public interface JsonFeature {
    @NotNull
    public static final Companion Companion = com.jetbrains.mlapi.feature.json.JsonFeature$Companion.$$INSTANCE;

    @NotNull
    public JsonElement toJsonElement();

    @NotNull
    public Feature toFeature(@NotNull java.lang.String var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$Boolean;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Primitive;", "value", "", "(Z)V", "getValue", "()Z", "equals", "other", "", "hashCode", "", "toFeature", "Lcom/jetbrains/mlapi/feature/Feature;", "name", "", "toJsonElement", "Lkotlinx/serialization/json/JsonElement;", "mlapi-core"})
    public static final class Boolean
    implements Primitive {
        private final boolean value;

        public Boolean(boolean value) {
            this.value = value;
        }

        public final boolean getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public JsonElement toJsonElement() {
            return (JsonElement)JsonElementKt.JsonPrimitive((java.lang.Boolean)this.value);
        }

        @Override
        @NotNull
        public Feature toFeature(@NotNull java.lang.String name) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (java.lang.String)"name");
            return new BooleanFeatureHolder(this.value, FeatureDeclaration.Companion.boolean$default(FeatureDeclaration.Companion, name, null, null, 6, null));
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Boolean)) {
                return false;
            }
            return this.value == ((Boolean)other).value;
        }

        public int hashCode() {
            return java.lang.Boolean.hashCode(this.value);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002J\f\u0010\n\u001a\u00020\u000b*\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$Companion;", "", "()V", "fromJsonElement", "Lcom/jetbrains/mlapi/feature/json/JsonFeature;", "element", "Lkotlinx/serialization/json/JsonElement;", "toNumericValue", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Number;", "Lkotlinx/serialization/json/JsonPrimitive;", "toPrimitiveValue", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Primitive;", "mlapi-core"})
    @SourceDebugExtension(value={"SMAP\nJsonFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonFeature$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,564:1\n1549#2:565\n1620#2,3:566\n1549#2:569\n1620#2,3:570\n1549#2:573\n1620#2,3:574\n*S KotlinDebug\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonFeature$Companion\n*L\n515#1:565\n515#1:566,3\n525#1:569\n525#1:570,3\n527#1:573\n527#1:574,3\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final JsonFeature fromJsonElement(@NotNull JsonElement element) {
            JsonFeature jsonFeature;
            Intrinsics.checkNotNullParameter((java.lang.Object)element, (java.lang.String)"element");
            JsonElement jsonElement = element;
            if (jsonElement instanceof JsonNull) {
                jsonFeature = Null.INSTANCE;
            } else if (jsonElement instanceof JsonPrimitive) {
                if (Intrinsics.areEqual((java.lang.Object)((JsonPrimitive)element).getContent(), (java.lang.Object)"NaN")) {
                    // empty if block
                }
                Intrinsics.areEqual((java.lang.Object)((JsonPrimitive)element).getContent(), (java.lang.Object)"NaN");
                jsonFeature = this.toPrimitiveValue((JsonPrimitive)element);
            } else {
                if (jsonElement instanceof JsonArray) {
                    JsonFeature jsonFeature2;
                    Number it;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)element;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (java.lang.Object item$iv$iv : $this$mapTo$iv$iv) {
                        JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        if (!(it instanceof JsonPrimitive)) {
                            boolean bl2 = false;
                            java.lang.String string = "Value " + element + " can't be processed, as its value is not a primitive: " + (JsonElement)it;
                            throw new IllegalArgumentException(string.toString());
                        }
                        collection.add($$INSTANCE.toNumericValue(JsonElementKt.getJsonPrimitive((JsonElement)it)));
                    }
                    List numerics = (List)destination$iv$iv;
                    if (numerics.isEmpty()) {
                        return new EmptyArray();
                    }
                    if (StringsKt.contains$default((CharSequence)((Number)CollectionsKt.first((List)numerics)).getNumberString(), (char)'.', (boolean)false, (int)2, null)) {
                        $this$map$iv = numerics;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (java.lang.Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (Number)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new Floating(it.getNumberString()));
                        }
                        List list = (List)destination$iv$iv;
                        jsonFeature2 = new FloatingArray(list);
                    } else {
                        $this$map$iv = numerics;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (java.lang.Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (Number)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(new Integer(it.getNumberString()));
                        }
                        List list = (List)destination$iv$iv;
                        jsonFeature2 = new IntegerArray(list);
                    }
                    return jsonFeature2;
                }
                throw new IllegalStateException(("Unsupported field type: " + element).toString());
            }
            return jsonFeature;
        }

        private final Number toNumericValue(JsonPrimitive $this$toNumericValue) {
            Number number;
            Float asFloat = JsonElementKt.getFloatOrNull((JsonPrimitive)$this$toNumericValue);
            Double asDouble = JsonElementKt.getDoubleOrNull((JsonPrimitive)$this$toNumericValue);
            java.lang.Integer asInt = StringsKt.toIntOrNull((java.lang.String)$this$toNumericValue.getContent());
            Long asLong = StringsKt.toLongOrNull((java.lang.String)$this$toNumericValue.getContent());
            if (asInt != null || asLong != null) {
                number = new Integer($this$toNumericValue.getContent());
            } else if (asFloat != null || asDouble != null) {
                number = new Floating($this$toNumericValue.getContent());
            } else {
                throw new IllegalStateException(("Json field '" + $this$toNumericValue + "' is not a number").toString());
            }
            return number;
        }

        private final Primitive toPrimitiveValue(JsonPrimitive $this$toPrimitiveValue) {
            Primitive primitive;
            Float asFloat = JsonElementKt.getFloatOrNull((JsonPrimitive)$this$toPrimitiveValue);
            Double asDouble = JsonElementKt.getDoubleOrNull((JsonPrimitive)$this$toPrimitiveValue);
            java.lang.Integer asInt = StringsKt.toIntOrNull((java.lang.String)$this$toPrimitiveValue.getContent());
            Long asLong = StringsKt.toLongOrNull((java.lang.String)$this$toPrimitiveValue.getContent());
            java.lang.Boolean asBoolean = JsonElementKt.getBooleanOrNull((JsonPrimitive)$this$toPrimitiveValue);
            if ($this$toPrimitiveValue.isString()) {
                primitive = new String($this$toPrimitiveValue.getContent());
            } else if (asInt != null || asLong != null) {
                primitive = new Integer($this$toPrimitiveValue.getContent());
            } else if (asFloat != null || asDouble != null) {
                primitive = new Floating($this$toPrimitiveValue.getContent());
            } else if (asBoolean != null) {
                primitive = new Boolean(asBoolean);
            } else {
                throw new IllegalStateException(("Unsupported primitive field type: " + $this$toPrimitiveValue).toString());
            }
            return primitive;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0096\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$EmptyArray;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Nested;", "()V", "equals", "", "other", "", "hashCode", "", "toFeature", "Lcom/jetbrains/mlapi/feature/Feature;", "name", "", "toJsonElement", "Lkotlinx/serialization/json/JsonElement;", "mlapi-core"})
    public static final class EmptyArray
    implements Nested {
        @Override
        @NotNull
        public JsonElement toJsonElement() {
            return (JsonElement)new JsonArray(CollectionsKt.emptyList());
        }

        @Override
        @NotNull
        public Feature toFeature(@NotNull java.lang.String name) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (java.lang.String)"name");
            return new JsonEmptyArrayFeature(name);
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof EmptyArray;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$Floating;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Number;", "asFloatString", "", "(Ljava/lang/String;)V", "getAsFloatString", "()Ljava/lang/String;", "numberString", "getNumberString", "equals", "", "other", "", "hashCode", "", "toFeature", "Lcom/jetbrains/mlapi/feature/Feature;", "name", "toJsonElement", "Lkotlinx/serialization/json/JsonElement;", "mlapi-core"})
    public static final class Floating
    implements Number {
        @NotNull
        private final java.lang.String asFloatString;

        public Floating(@NotNull java.lang.String asFloatString) {
            Intrinsics.checkNotNullParameter((java.lang.Object)asFloatString, (java.lang.String)"asFloatString");
            this.asFloatString = asFloatString;
        }

        @NotNull
        public final java.lang.String getAsFloatString() {
            return this.asFloatString;
        }

        @Override
        @NotNull
        public JsonElement toJsonElement() {
            return (JsonElement)JsonElementKt.JsonUnquotedLiteral((java.lang.String)this.asFloatString);
        }

        @Override
        @NotNull
        public Feature toFeature(@NotNull java.lang.String name) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (java.lang.String)"name");
            return new JsonFloatingFeature(name, this.asFloatString);
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Floating)) {
                return false;
            }
            return Intrinsics.areEqual((java.lang.Object)this.asFloatString, (java.lang.Object)((Floating)other).asFloatString);
        }

        public int hashCode() {
            return this.asFloatString.hashCode();
        }

        @Override
        @NotNull
        public java.lang.String getNumberString() {
            return this.asFloatString;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$FloatingArray;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Nested;", "items", "", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Floating;", "(Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "equals", "", "other", "", "hashCode", "", "toFeature", "Lcom/jetbrains/mlapi/feature/Feature;", "name", "", "toJsonElement", "Lkotlinx/serialization/json/JsonElement;", "mlapi-core"})
    @SourceDebugExtension(value={"SMAP\nJsonFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonFeature$FloatingArray\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,564:1\n1549#2:565\n1620#2,3:566\n*S KotlinDebug\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonFeature$FloatingArray\n*L\n433#1:565\n433#1:566,3\n*E\n"})
    public static final class FloatingArray
    implements Nested {
        @NotNull
        private final List<Floating> items;

        public FloatingArray(@NotNull List<Floating> items) {
            Intrinsics.checkNotNullParameter(items, (java.lang.String)"items");
            this.items = items;
        }

        @NotNull
        public final List<Floating> getItems() {
            return this.items;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public JsonElement toJsonElement() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.items;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (java.lang.Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Floating floating = (Floating)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toJsonElement());
            }
            List list = (List)destination$iv$iv;
            return (JsonElement)new JsonArray(list);
        }

        @Override
        @NotNull
        public Feature toFeature(@NotNull java.lang.String name) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (java.lang.String)"name");
            return new JsonFloatingArrayFeature(name, this.items);
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FloatingArray)) {
                return false;
            }
            return Intrinsics.areEqual(this.items, ((FloatingArray)other).items);
        }

        public int hashCode() {
            return ((java.lang.Object)this.items).hashCode();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$Integer;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Number;", "asIntegerString", "", "(Ljava/lang/String;)V", "getAsIntegerString", "()Ljava/lang/String;", "numberString", "getNumberString", "equals", "", "other", "", "hashCode", "", "toFeature", "Lcom/jetbrains/mlapi/feature/Feature;", "name", "toJsonElement", "Lkotlinx/serialization/json/JsonElement;", "mlapi-core"})
    public static final class Integer
    implements Number {
        @NotNull
        private final java.lang.String asIntegerString;

        public Integer(@NotNull java.lang.String asIntegerString) {
            Intrinsics.checkNotNullParameter((java.lang.Object)asIntegerString, (java.lang.String)"asIntegerString");
            this.asIntegerString = asIntegerString;
        }

        @NotNull
        public final java.lang.String getAsIntegerString() {
            return this.asIntegerString;
        }

        @Override
        @NotNull
        public JsonElement toJsonElement() {
            return (JsonElement)JsonElementKt.JsonUnquotedLiteral((java.lang.String)this.asIntegerString);
        }

        @Override
        @NotNull
        public Feature toFeature(@NotNull java.lang.String name) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (java.lang.String)"name");
            return new JsonIntegerFeature(name, this.asIntegerString);
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Integer)) {
                return false;
            }
            return Intrinsics.areEqual((java.lang.Object)this.asIntegerString, (java.lang.Object)((Integer)other).asIntegerString);
        }

        public int hashCode() {
            return this.asIntegerString.hashCode();
        }

        @Override
        @NotNull
        public java.lang.String getNumberString() {
            return this.asIntegerString;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$IntegerArray;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Nested;", "items", "", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Integer;", "(Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "equals", "", "other", "", "hashCode", "", "toFeature", "Lcom/jetbrains/mlapi/feature/Feature;", "name", "", "toJsonElement", "Lkotlinx/serialization/json/JsonElement;", "mlapi-core"})
    @SourceDebugExtension(value={"SMAP\nJsonFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonFeature$IntegerArray\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,564:1\n1549#2:565\n1620#2,3:566\n*S KotlinDebug\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonFeature$IntegerArray\n*L\n390#1:565\n390#1:566,3\n*E\n"})
    public static final class IntegerArray
    implements Nested {
        @NotNull
        private final List<Integer> items;

        public IntegerArray(@NotNull List<Integer> items) {
            Intrinsics.checkNotNullParameter(items, (java.lang.String)"items");
            this.items = items;
        }

        @NotNull
        public final List<Integer> getItems() {
            return this.items;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public JsonElement toJsonElement() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.items;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (java.lang.Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Integer integer = (Integer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toJsonElement());
            }
            List list = (List)destination$iv$iv;
            return (JsonElement)new JsonArray(list);
        }

        @Override
        @NotNull
        public Feature toFeature(@NotNull java.lang.String name) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (java.lang.String)"name");
            return new JsonIntegerArrayFeature(name, this.items);
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IntegerArray)) {
                return false;
            }
            return Intrinsics.areEqual(this.items, ((IntegerArray)other).items);
        }

        public int hashCode() {
            return ((java.lang.Object)this.items).hashCode();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0005\u0002\u0003\u0004\u0005\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$Nested;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$EmptyArray;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$FloatingArray;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$IntegerArray;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Object;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$ObjectArray;", "mlapi-core"})
    public static interface Nested
    extends JsonFeature {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$Null;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Primitive;", "()V", "equals", "", "other", "", "hashCode", "", "toFeature", "Lcom/jetbrains/mlapi/feature/Feature;", "name", "", "toJsonElement", "Lkotlinx/serialization/json/JsonElement;", "toString", "mlapi-core"})
    public static final class Null
    implements Primitive {
        @NotNull
        public static final Null INSTANCE = new Null();

        private Null() {
        }

        @Override
        @NotNull
        public JsonElement toJsonElement() {
            return (JsonElement)JsonNull.INSTANCE;
        }

        @Override
        @NotNull
        public Feature toFeature(@NotNull java.lang.String name) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (java.lang.String)"name");
            return new NullFeatureHolder(name, null, 2, null);
        }

        @NotNull
        public java.lang.String toString() {
            return "Null";
        }

        public int hashCode() {
            return -764551171;
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Null)) {
                return false;
            }
            Null cfr_ignored_0 = (Null)other;
            return true;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$Number;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Primitive;", "numberString", "", "getNumberString", "()Ljava/lang/String;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Floating;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Integer;", "mlapi-core"})
    public static interface Number
    extends Primitive {
        @NotNull
        public java.lang.String getNumberString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$Object;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Nested;", "fields", "", "", "Lcom/jetbrains/mlapi/feature/json/JsonFeature;", "(Ljava/util/Map;)V", "getFields", "()Ljava/util/Map;", "equals", "", "other", "", "hashCode", "", "toFeature", "Lcom/jetbrains/mlapi/feature/Feature$Object;", "name", "toJsonElement", "Lkotlinx/serialization/json/JsonObject;", "mlapi-core"})
    @SourceDebugExtension(value={"SMAP\nJsonFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonFeature$Object\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,564:1\n453#2:565\n403#2:566\n453#2:571\n403#2:572\n1238#3,4:567\n1238#3,4:573\n1549#3:577\n1620#3,3:578\n*S KotlinDebug\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonFeature$Object\n*L\n455#1:565\n455#1:566\n458#1:571\n458#1:572\n455#1:567,4\n458#1:573,4\n459#1:577\n459#1:578,3\n*E\n"})
    public static final class Object
    implements Nested {
        @NotNull
        private final Map<java.lang.String, JsonFeature> fields;

        public Object(@NotNull Map<java.lang.String, ? extends JsonFeature> fields) {
            Intrinsics.checkNotNullParameter(fields, (java.lang.String)"fields");
            this.fields = fields;
        }

        @NotNull
        public final Map<java.lang.String, JsonFeature> getFields() {
            return this.fields;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public JsonObject toJsonElement() {
            void $this$mapValuesTo$iv$iv;
            Map<java.lang.String, JsonFeature> $this$mapValues$iv = this.fields;
            boolean $i$f$mapValues = false;
            Map<java.lang.String, JsonFeature> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (java.lang.Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                java.lang.Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                JsonElement jsonElement = ((JsonFeature)it.getValue()).toJsonElement();
                map3.put(k, jsonElement);
            }
            Map map4 = destination$iv$iv;
            return new JsonObject(map4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Feature.Object toFeature(@NotNull java.lang.String name) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            java.lang.Object object;
            void $this$mapValuesTo$iv$iv;
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (java.lang.String)"name");
            Map<java.lang.String, JsonFeature> $this$mapValues$iv = this.fields;
            boolean $i$f$mapValues22 = false;
            Map<java.lang.String, JsonFeature> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (java.lang.Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                java.lang.Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                object = ((JsonFeature)it.getValue()).toFeature((java.lang.String)it.getKey());
                map3.put(k, object);
            }
            List features = CollectionsKt.toList((Iterable)destination$iv$iv.values());
            Iterable $i$f$mapValues22 = features;
            object = name;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (java.lang.Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                java.lang.Object element$iv$iv$iv;
                element$iv$iv$iv = (Feature)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getSignature());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 4;
            LogsMetadata logsMetadata = null;
            List list = (List)destination$iv$iv2;
            java.lang.Object object2 = object;
            ObjectFeatureDeclaration declaration = new ObjectFeatureDeclaration((java.lang.String)object2, list, logsMetadata, n, defaultConstructorMarker);
            return new ObjectFeature(declaration, features);
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Object)) {
                return false;
            }
            return Intrinsics.areEqual(this.fields, ((Object)other).fields);
        }

        public int hashCode() {
            return ((java.lang.Object)this.fields).hashCode();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$ObjectArray;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Nested;", "items", "", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Object;", "(Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "equals", "", "other", "", "hashCode", "", "toFeature", "Lcom/jetbrains/mlapi/feature/Feature$ObjectArray;", "name", "", "toJsonElement", "Lkotlinx/serialization/json/JsonArray;", "mlapi-core"})
    @SourceDebugExtension(value={"SMAP\nJsonFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonFeature$ObjectArray\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,564:1\n1549#2:565\n1620#2,3:566\n1559#2:569\n1590#2,4:570\n1549#2:574\n1620#2,3:575\n800#2,11:578\n1360#2:589\n1446#2,5:590\n*S KotlinDebug\n*F\n+ 1 JsonFeature.kt\ncom/jetbrains/mlapi/feature/json/JsonFeature$ObjectArray\n*L\n478#1:565\n478#1:566,3\n481#1:569\n481#1:570,4\n482#1:574\n482#1:575,3\n482#1:578,11\n482#1:589\n482#1:590,5\n*E\n"})
    public static final class ObjectArray
    implements Nested {
        @NotNull
        private final List<Object> items;

        public ObjectArray(@NotNull List<Object> items) {
            Intrinsics.checkNotNullParameter(items, (java.lang.String)"items");
            this.items = items;
        }

        @NotNull
        public final List<Object> getItems() {
            return this.items;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public JsonArray toJsonElement() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.items;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (java.lang.Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object object = (Object)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toJsonElement());
            }
            List list = (List)destination$iv$iv;
            return new JsonArray(list);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Feature.ObjectArray toFeature(@NotNull java.lang.String name) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (java.lang.String)"name");
            Iterable $this$mapIndexed$iv = this.items;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (java.lang.Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void f;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object object = (Object)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(f.toFeature(java.lang.String.valueOf((int)i)));
            }
            List features = (List)destination$iv$iv;
            Iterable $this$map$iv = features;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (java.lang.Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Feature.Object object = (Feature.Object)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getSignature());
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (java.lang.Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ObjectFeatureDeclaration)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv2;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (java.lang.Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ObjectFeatureDeclaration it = (ObjectFeatureDeclaration)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getSignatures();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List elementObjectSignatures = (List)destination$iv$iv2;
            ObjectFeatureDeclaration elementSignature = new ObjectFeatureDeclaration("element", elementObjectSignatures, null, 4, null);
            ObjectArrayDeclaration declaration = new ObjectArrayDeclaration(name, elementSignature, null, 4, null);
            return new ObjectArrayFeature(declaration, features);
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ObjectArray)) {
                return false;
            }
            return Intrinsics.areEqual(this.items, ((ObjectArray)other).items);
        }

        public int hashCode() {
            return ((java.lang.Object)this.items).hashCode();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0004\u0002\u0003\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$Primitive;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Boolean;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Null;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Number;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$String;", "mlapi-core"})
    public static interface Primitive
    extends JsonFeature {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFeature$String;", "Lcom/jetbrains/mlapi/feature/json/JsonFeature$Primitive;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toFeature", "Lcom/jetbrains/mlapi/feature/Feature;", "name", "toJsonElement", "Lkotlinx/serialization/json/JsonElement;", "mlapi-core"})
    public static final class String
    implements Primitive {
        @NotNull
        private final java.lang.String value;

        public String(@NotNull java.lang.String value) {
            Intrinsics.checkNotNullParameter((java.lang.Object)value, (java.lang.String)"value");
            this.value = value;
        }

        @NotNull
        public final java.lang.String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        public JsonElement toJsonElement() {
            return (JsonElement)JsonElementKt.JsonPrimitive((java.lang.String)this.value);
        }

        @Override
        @NotNull
        public Feature toFeature(@NotNull java.lang.String name) {
            Intrinsics.checkNotNullParameter((java.lang.Object)name, (java.lang.String)"name");
            return new StringFeatureHolder(this.value, FeatureDeclaration.Companion.string$default(FeatureDeclaration.Companion, name, null, null, 6, null));
        }

        public boolean equals(@Nullable java.lang.Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof String)) {
                return false;
            }
            return Intrinsics.areEqual((java.lang.Object)this.value, (java.lang.Object)((String)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

