/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.ui.DataAccessType;
import java.util.BitSet;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class HiddenColumnsSelectionHolder {
    private final BitSet mySelectedHiddenColumns;
    private boolean myWholeRowSelected;
    private boolean myIgnoreChanges;

    public HiddenColumnsSelectionHolder() {
        this.mySelectedHiddenColumns = new BitSet();
    }

    private HiddenColumnsSelectionHolder(HiddenColumnsSelectionHolder copy) {
        this.mySelectedHiddenColumns = BitSet.valueOf(copy.mySelectedHiddenColumns.toLongArray());
        this.myWholeRowSelected = copy.myWholeRowSelected;
        this.myIgnoreChanges = copy.myIgnoreChanges;
    }

    public void setWholeRowSelected(boolean selected) {
        if (this.myIgnoreChanges) {
            return;
        }
        this.myWholeRowSelected = selected;
    }

    public void columnHidden(int modelIndex) {
        this.mySelectedHiddenColumns.set(modelIndex);
    }

    public void columnShown(int modelIndex) {
        this.mySelectedHiddenColumns.clear(modelIndex);
    }

    public void startAdjusting() {
        this.myIgnoreChanges = true;
    }

    public void endAdjusting() {
        this.myIgnoreChanges = false;
    }

    public boolean contains(int modelIndex) {
        return this.myWholeRowSelected || this.mySelectedHiddenColumns.get(modelIndex);
    }

    public HiddenColumnsSelectionHolder copy() {
        return new HiddenColumnsSelectionHolder(this);
    }

    public int[] selectedModelIndices(@NotNull DataGrid panel2) {
        if (panel2 == null) {
            HiddenColumnsSelectionHolder.$$$reportNull$$$0(0);
        }
        return this.myWholeRowSelected ? IntStream.range(0, panel2.getDataModel(DataAccessType.DATABASE_DATA).getColumnCount()).toArray() : this.mySelectedHiddenColumns.stream().toArray();
    }

    public void reset() {
        this.mySelectedHiddenColumns.clear();
        this.myWholeRowSelected = false;
        this.myIgnoreChanges = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/run/ui/HiddenColumnsSelectionHolder", "selectedModelIndices"));
    }
}

