/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.actions.GetVersionAction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GetVersionFromRepositoryActionProvider
implements AnActionExtensionProvider {
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            GetVersionFromRepositoryActionProvider.$$$reportNull$$$0(0);
        }
        return e.getData(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS) != null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GetVersionFromRepositoryActionProvider.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GetVersionFromRepositoryActionProvider.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS);
        if (changes == null) {
            return;
        }
        boolean isEnabled = project != null && changes.length > 0;
        e.getPresentation().setEnabledAndVisible(isEnabled);
        e.getPresentation().setText(VcsBundle.message((String)"action.name.get.file.content.from.repository", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GetVersionFromRepositoryActionProvider.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Object[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS);
        if (changes == null) {
            return;
        }
        List fileContentProviders = ContainerUtil.map((Object[])changes, change -> new MyFileContentProvider((Change)change));
        GetVersionAction.doGet(project, VcsBundle.message((String)"activity.name.get", (Object[])new Object[0]), fileContentProviders, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/GetVersionFromRepositoryActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/GetVersionFromRepositoryActionProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyFileContentProvider
    implements GetVersionAction.FileRevisionProvider {
        @NotNull
        private final Change myChange;

        private MyFileContentProvider(@NotNull Change change) {
            if (change == null) {
                MyFileContentProvider.$$$reportNull$$$0(0);
            }
            this.myChange = change;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = ChangesUtil.getFilePath((Change)this.myChange);
            if (filePath == null) {
                MyFileContentProvider.$$$reportNull$$$0(1);
            }
            return filePath;
        }

        @Override
        @Nullable
        public GetVersionAction.FileRevisionContent getContent() throws VcsException {
            ContentRevision revision = this.myChange.getAfterRevision();
            if (revision == null) {
                return null;
            }
            byte[] bytes = ChangesUtil.loadContentRevision((ContentRevision)revision);
            return new GetVersionAction.FileRevisionContent(bytes, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/GetVersionFromRepositoryActionProvider$MyFileContentProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/GetVersionFromRepositoryActionProvider$MyFileContentProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

