/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ImportIntoShelfAction
extends DumbAwareAction {
    public ImportIntoShelfAction() {
        super(VcsBundle.messagePointer((String)"action.ImportIntoShelfAction.text", (Object[])new Object[0]), VcsBundle.messagePointer((String)"action.ImportIntoShelfAction.description", (Object[])new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportIntoShelfAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ImportIntoShelfAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ImportIntoShelfAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ImportIntoShelfAction.importPatchesToShelf(project);
    }

    public static List<ShelvedChangeList> importPatchesToShelf(@NotNull Project project) {
        if (project == null) {
            ImportIntoShelfAction.$$$reportNull$$$0(3);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true);
        ArrayList<ShelvedChangeList> addedLists = new ArrayList<ShelvedChangeList>();
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null, files -> {
            String message;
            int toImport;
            ShelveChangesManager shelveChangesManager;
            ArrayList patchTypeFiles;
            ProgressManager pm = ProgressManager.getInstance();
            boolean filesFound = (Boolean)pm.runProcessWithProgressSynchronously(() -> ImportIntoShelfAction.lambda$importPatchesToShelf$0(patchTypeFiles = new ArrayList(), shelveChangesManager = ShelveChangesManager.getInstance(project), files), VcsBundle.message((String)"looking.for.patch.files", (Object[])new Object[0]), true, project);
            if (!filesFound || patchTypeFiles.isEmpty()) {
                return;
            }
            if (!patchTypeFiles.equals(files) && 1 == (toImport = Messages.showYesNoDialog((Project)project, (String)(message = patchTypeFiles.size() == 1 ? VcsBundle.message((String)"shelve.import.one.patch.file.prompt", (Object[])new Object[]{((VirtualFile)patchTypeFiles.get(0)).getPath()}) : VcsBundle.message((String)"shelve.import.patches.prompt", (Object[])new Object[]{patchTypeFiles.size()})), (String)VcsBundle.message((String)"import.patches", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()))) {
                return;
            }
            pm.runProcessWithProgressSynchronously(() -> {
                ArrayList exceptions = new ArrayList();
                List<ShelvedChangeList> lists = shelveChangesManager.importChangeLists(patchTypeFiles, e1 -> exceptions.add(e1));
                addedLists.addAll(lists);
                if (!lists.isEmpty()) {
                    ShelvedChangesViewManager.getInstance(project).activateView(lists.get(lists.size() - 1));
                }
                if (!exceptions.isEmpty()) {
                    AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, VcsBundle.message((String)"patch.import.to.shelf.tab", (Object[])new Object[0]));
                }
                if (lists.isEmpty() && exceptions.isEmpty()) {
                    VcsBalloonProblemNotifier.showOverChangesView(project, VcsBundle.message((String)"patch.import.no.patches.found.warning", (Object[])new Object[0]), MessageType.WARNING, new NamedRunnable[0]);
                }
            }, VcsBundle.message((String)"import.patches.into.shelf", (Object[])new Object[0]), true, project);
        });
        return addedLists;
    }

    private static /* synthetic */ Boolean lambda$importPatchesToShelf$0(List patchTypeFiles, ShelveChangesManager shelveChangesManager, List files) throws RuntimeException {
        return patchTypeFiles.addAll(shelveChangesManager.gatherPatchFiles(files));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ImportIntoShelfAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ImportIntoShelfAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importPatchesToShelf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

