/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard.actions;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunContentDescriptorId;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.RunDashboardActionUtils;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;

final class ClearContentAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.FrontendOtherwiseBackend {
    ClearContentAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ClearContentAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ClearContentAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        JBIterable targetNodes = RunDashboardActionUtils.getLeafTargets((AnActionEvent)e);
        boolean enabled = targetNodes.filter(node -> {
            RunContentDescriptor descriptor = node.getDescriptor();
            if (descriptor == null) {
                return RunDashboardManagerImpl.getInstance(project).getPersistedStatus(node.getConfigurationSettings().getConfiguration()) != null;
            }
            ProcessHandler processHandler = descriptor.getProcessHandler();
            return processHandler == null || processHandler.isProcessTerminated();
        }).isNotEmpty();
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled || !e.isFromContextMenu());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ClearContentAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        for (RunDashboardRunConfigurationNode node : RunDashboardActionUtils.getLeafTargets((AnActionEvent)e)) {
            Executor executor;
            RunContentDescriptor descriptor = node.getDescriptor();
            if (descriptor == null) {
                RunDashboardManager.getInstance((Project)project).clearConfigurationStatus(node.getConfigurationSettings().getConfiguration());
                continue;
            }
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler != null && !processHandler.isProcessTerminated()) continue;
            Content content = descriptor.getAttachedContent();
            Executor executor2 = executor = content == null ? ExecutorRegistry.getInstance().getExecutorById("Debug") : RunContentManagerImpl.getExecutorByContent((Content)content);
            if (executor == null) continue;
            RunContentDescriptor managedDescriptor = ClearContentAction.getManagedDescriptor(descriptor, project);
            RunContentManager.getInstance((Project)project).removeRunContent(executor, managedDescriptor);
            RunDashboardManager.getInstance((Project)project).clearConfigurationStatus(node.getConfigurationSettings().getConfiguration());
        }
    }

    private static RunContentDescriptor getManagedDescriptor(RunContentDescriptor descriptor, Project project) {
        RunContentDescriptorId descriptorId = descriptor.getId();
        if (descriptorId == null) {
            return descriptor;
        }
        RunContentDescriptor updatedDescriptor = (RunContentDescriptor)ContainerUtil.find((Iterable)RunContentManager.getInstance((Project)project).getRunContentDescriptors(), managedDescriptor -> descriptorId.equals((Object)managedDescriptor.getId()));
        return updatedDescriptor == null ? descriptor : updatedDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/actions/ClearContentAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/actions/ClearContentAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

