/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.CollectorContext;
import com.networknt.schema.Error;
import com.networknt.schema.ExecutionConfig;
import com.networknt.schema.FailFastAssertionException;
import com.networknt.schema.Schema;
import com.networknt.schema.annotation.Annotations;
import com.networknt.schema.keyword.DiscriminatorState;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.walk.WalkConfig;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ExecutionContext {
    private ExecutionConfig executionConfig;
    private WalkConfig walkConfig = null;
    private CollectorContext collectorContext = null;
    private Annotations annotations = null;
    private List<Error> errors = new ArrayList<Error>();
    private final Map<NodePath, DiscriminatorState> discriminatorMapping = new HashMap<NodePath, DiscriminatorState>();
    NodePath evaluationPath;
    final ArrayDeque<Schema> evaluationSchema = new ArrayDeque(64);
    final ArrayDeque<Object> evaluationSchemaPath = new ArrayDeque(64);
    private Boolean failFast = null;
    boolean unevaluatedPropertiesPresent = false;
    boolean unevaluatedItemsPresent = false;

    public NodePath getEvaluationPath() {
        return this.evaluationPath;
    }

    public void evaluationPathAddLast(String token) {
        this.evaluationPath = this.evaluationPath.append(token);
    }

    public void evaluationPathAddLast(int token) {
        this.evaluationPath = this.evaluationPath.append(token);
    }

    public void evaluationPathRemoveLast() {
        this.evaluationPath = this.evaluationPath.getParent();
    }

    public ArrayDeque<Schema> getEvaluationSchema() {
        return this.evaluationSchema;
    }

    public ArrayDeque<Object> getEvaluationSchemaPath() {
        return this.evaluationSchemaPath;
    }

    public Map<NodePath, DiscriminatorState> getDiscriminatorMapping() {
        return this.discriminatorMapping;
    }

    public ExecutionContext() {
        this(ExecutionConfig.getInstance(), null);
    }

    public ExecutionContext(CollectorContext collectorContext) {
        this(ExecutionConfig.getInstance(), collectorContext);
    }

    public ExecutionContext(ExecutionConfig executionConfig) {
        this(executionConfig, null);
    }

    public ExecutionContext(ExecutionConfig executionConfig, CollectorContext collectorContext) {
        this.collectorContext = collectorContext;
        this.executionConfig = executionConfig;
    }

    public void setWalkConfig(WalkConfig walkConfig) {
        this.walkConfig = walkConfig;
    }

    public WalkConfig getWalkConfig() {
        if (this.walkConfig == null) {
            this.walkConfig = WalkConfig.getInstance();
        }
        return this.walkConfig;
    }

    public CollectorContext getCollectorContext() {
        if (this.collectorContext == null) {
            this.collectorContext = new CollectorContext();
        }
        return this.collectorContext;
    }

    public void setCollectorContext(CollectorContext collectorContext) {
        this.collectorContext = collectorContext;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) {
        this.executionConfig = executionConfig;
    }

    public Annotations getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        return this.annotations;
    }

    public boolean isFailFast() {
        if (this.failFast == null) {
            this.failFast = this.getExecutionConfig().isFailFast();
        }
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public void addError(Error error) {
        this.errors.add(error);
        if (this.isFailFast()) {
            throw new FailFastAssertionException(error);
        }
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public void executionConfig(Consumer<ExecutionConfig.Builder> customizer) {
        ExecutionConfig.Builder builder = ExecutionConfig.builder(this.getExecutionConfig());
        customizer.accept(builder);
        this.executionConfig = builder.build();
    }

    public void walkConfig(Consumer<WalkConfig.Builder> customizer) {
        WalkConfig.Builder builder = WalkConfig.builder(this.getWalkConfig());
        customizer.accept(builder);
        this.walkConfig = builder.build();
    }

    public boolean isUnevaluatedPropertiesPresent() {
        return this.unevaluatedPropertiesPresent;
    }

    public boolean isUnevaluatedItemsPresent() {
        return this.unevaluatedItemsPresent;
    }

    public void setUnevaluatedPropertiesPresent(boolean set) {
        this.unevaluatedPropertiesPresent = set;
    }

    public void setUnevaluatedItemsPresent(boolean set) {
        this.unevaluatedItemsPresent = set;
    }
}

