/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.operation.relateng.TopologyPredicate;

abstract class BasicPredicate
implements TopologyPredicate {
    private static final int UNKNOWN = -1;
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private int value = -1;

    BasicPredicate() {
    }

    private static boolean isKnown(int value) {
        return value > -1;
    }

    private static boolean toBoolean(int value) {
        return value == 1;
    }

    private static int toValue(boolean val) {
        return val ? 1 : 0;
    }

    public static boolean isIntersection(int locA, int locB) {
        return locA != 2 && locB != 2;
    }

    @Override
    public boolean isKnown() {
        return BasicPredicate.isKnown(this.value);
    }

    @Override
    public boolean value() {
        return BasicPredicate.toBoolean(this.value);
    }

    protected void setValue(boolean val) {
        if (this.isKnown()) {
            return;
        }
        this.value = BasicPredicate.toValue(val);
    }

    protected void setValue(int val) {
        if (this.isKnown()) {
            return;
        }
        this.value = val;
    }

    protected void setValueIf(boolean value, boolean cond) {
        if (cond) {
            this.setValue(value);
        }
    }

    protected void require(boolean cond) {
        if (!cond) {
            this.setValue(false);
        }
    }

    protected void requireCovers(Envelope a, Envelope b) {
        this.require(a.covers(b));
    }
}

