/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.core.datasource.Storage;

public final class SourcePathHandle {
    private static final String EXTRACTED_DIR = "extracted_sources";
    private static final Logger LOGGER = Logger.getLogger(SourcePathHandle.class.getName());
    private final Path path;
    private final boolean archive;
    private final Charset encoding;
    private Path regularPath;

    SourcePathHandle(Path path, boolean archive, Charset encoding) {
        this.path = path;
        this.archive = archive;
        this.encoding = encoding;
    }

    public Path getPath() {
        return this.path;
    }

    public Path getRegularPath() {
        if (this.archive) {
            if (this.regularPath == null) {
                try {
                    this.regularPath = SourcePathHandle.extractArchivePath(this.path);
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, "Failed extracting archived path " + this.path, e);
                    this.regularPath = this.path;
                }
            }
            return this.regularPath;
        }
        return this.path;
    }

    public String readText() {
        try {
            return new String(Files.readAllBytes(this.path), this.encoding);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Failed resolving source text " + this.path.toAbsolutePath().toString(), ex);
            return null;
        }
    }

    public void close() {
        if (this.archive) {
            try {
                this.path.getFileSystem().close();
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Failed closing filesystem for " + this.path, e);
            }
        }
    }

    private static Path extractArchivePath(Path archive) throws Exception {
        Path extracted = Paths.get(Storage.getTemporaryStorageDirectoryString(), EXTRACTED_DIR, archive.toString());
        Files.createDirectories(extracted.getParent(), new FileAttribute[0]);
        Files.copy(archive, extracted, LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
        return extracted;
    }
}

