/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.javaext;

import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.PrimitiveNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.truffle.javaext.Bundle;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;

public class TrufflePrimitiveArrayItemsProvider
extends HeapViewerNode.Provider {
    public String getName() {
        return Bundle.TrufflePrimitiveArrayItemsProvider_Name();
    }

    public boolean supportsView(Heap heap, String viewID) {
        return !viewID.startsWith("java_");
    }

    public boolean supportsNode(HeapViewerNode parent, Heap heap, String viewID) {
        if (parent instanceof InstanceNode && !InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)((InstanceNode)parent).getMode())) {
            Instance instance = ((InstanceNode)parent).getInstance();
            return instance instanceof PrimitiveArrayInstance;
        }
        return false;
    }

    public HeapViewerNode[] getNodes(HeapViewerNode parent, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        final Instance instance = (Instance)HeapViewerNode.getValue((HeapViewerNode)parent, (DataType)DataType.INSTANCE, (Heap)heap);
        final String type = instance.getJavaClass().getName().replace("[]", "");
        final List items = ((PrimitiveArrayInstance)instance).getValues();
        NodesComputer<Integer> computer = new NodesComputer<Integer>(items.size(), UIThresholds.MAX_ARRAY_ITEMS){

            protected boolean sorts(DataType dataType) {
                return DataType.COUNT != dataType && DataType.OWN_SIZE != dataType && DataType.RETAINED_SIZE != dataType;
            }

            protected HeapViewerNode createNode(Integer index) {
                return new PrimitiveNode.ArrayItem(index.intValue(), type, (String)items.get(index), instance);
            }

            protected ProgressIterator<Integer> objectsIterator(int index, Progress progress) {
                Iterator iterator = 1.integerIterator((int)index, (int)items.size());
                return new ProgressIterator(iterator, index, false, progress);
            }

            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.TrufflePrimitiveArrayItemsProvider_MoreNodes(moreNodesCount);
            }

            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.TrufflePrimitiveArrayItemsProvider_SamplesContainer(objectsCount);
            }

            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.TrufflePrimitiveArrayItemsProvider_NodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes(parent, heap, viewID, null, dataTypes, sortOrders, progress);
    }
}

