/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import nu.validator.checker.Checker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class DebugChecker
extends Checker {
    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuilder buf = new StringBuilder();
        buf.append("Characters: \u201c");
        buf.append(ch, start, length);
        buf.append("\u201d.");
        this.warn(buf.toString());
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.warn("EndElement: \u201c" + localName + "\u201d from namespace \u201c" + uri + "\u201d.");
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.warn("EndPrefixMapping: \u201c" + prefix + "\u201d.");
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.warn("ProcessingInstruction: \u201c" + target + "\u201d, \u201c" + data + "\u201d.");
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.warn("SkippedEntity: \u201c" + name + "\u201d.");
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.warn("StartElement: \u201c" + localName + "\u201d from namespace \u201c" + uri + "\u201d.");
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            this.warn("Attribute: \u201c" + atts.getLocalName(i) + "\u201d" + (String)("".equals(atts.getURI(i)) ? "" : "from namespace \u201c" + atts.getURI(i) + "\u201d") + " has value: \u201c" + atts.getValue(i) + "\u201d.");
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.warn("StartPrefixMapping: \u201c" + prefix + "\u201d, \u201c" + uri + "\u201d.");
    }
}

