/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util.keyrange;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryCursor;
import com.sleepycat.util.keyrange.KeyRange;

public class RangeCursor
implements Cloneable {
    private Cursor cursor;
    private SecondaryCursor secCursor;
    private KeyRange range;
    private KeyRange pkRange;
    private DatabaseEntry privKey;
    private DatabaseEntry privPKey;
    private DatabaseEntry privData;
    private boolean initialized;

    public RangeCursor(KeyRange keyRange, Cursor cursor) throws DatabaseException {
        this.range = keyRange;
        this.cursor = cursor;
        this.init();
    }

    public RangeCursor(KeyRange keyRange, KeyRange keyRange2, Cursor cursor) throws DatabaseException {
        if (keyRange2 != null && !keyRange.singleKey) {
            throw new IllegalArgumentException();
        }
        this.range = keyRange;
        this.pkRange = keyRange2;
        this.cursor = cursor;
        this.init();
        if (keyRange2 != null && this.secCursor == null) {
            throw new IllegalArgumentException();
        }
    }

    public RangeCursor dup(boolean bl) throws DatabaseException {
        try {
            RangeCursor rangeCursor = (RangeCursor)super.clone();
            rangeCursor.cursor = this.dupCursor(this.cursor, bl);
            rangeCursor.init();
            return rangeCursor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void init() {
        this.secCursor = this.cursor instanceof SecondaryCursor ? (SecondaryCursor)this.cursor : null;
        if (this.range.hasBound()) {
            this.privKey = new DatabaseEntry();
            this.privPKey = new DatabaseEntry();
            this.privData = new DatabaseEntry();
        } else {
            this.privKey = null;
            this.privPKey = null;
            this.privData = null;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    private void setParams(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) {
        this.privKey = databaseEntry;
        this.privPKey = databaseEntry2;
        this.privData = databaseEntry3;
    }

    private Cursor beginOperation() throws DatabaseException {
        Cursor cursor = this.cursor;
        if (this.initialized) {
            this.cursor = this.dupCursor(this.cursor, true);
            if (this.secCursor != null) {
                this.secCursor = (SecondaryCursor)this.cursor;
            }
        } else {
            return this.cursor;
        }
        return cursor;
    }

    private void endOperation(Cursor cursor, OperationStatus operationStatus, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3) throws DatabaseException {
        if (operationStatus == OperationStatus.SUCCESS) {
            if (cursor != null && cursor != this.cursor) {
                this.closeCursor(cursor);
            }
            if (databaseEntry != null) {
                RangeCursor.swapData(databaseEntry, this.privKey);
            }
            if (databaseEntry2 != null && this.secCursor != null) {
                RangeCursor.swapData(databaseEntry2, this.privPKey);
            }
            if (databaseEntry3 != null) {
                RangeCursor.swapData(databaseEntry3, this.privData);
            }
            this.initialized = true;
        } else if (cursor != null && cursor != this.cursor) {
            this.closeCursor(this.cursor);
            this.cursor = cursor;
            if (this.secCursor != null) {
                this.secCursor = (SecondaryCursor)this.cursor;
            }
        }
    }

    private static void swapData(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        byte[] byArray = databaseEntry.getData();
        int n = databaseEntry.getOffset();
        int n2 = databaseEntry.getSize();
        databaseEntry.setData(databaseEntry2.getData(), databaseEntry2.getOffset(), databaseEntry2.getSize());
        databaseEntry2.setData(byArray, n, n2);
    }

    private static void shareData(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) {
        if (databaseEntry != null) {
            databaseEntry2.setData(databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationStatus getFirst(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            OperationStatus operationStatus2 = this.doGetFirst(lockMode);
            this.endOperation(null, operationStatus2, null, null, null);
            return operationStatus2;
        }
        if (this.pkRange != null) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            if (this.pkRange.singleKey) {
                KeyRange.copy(this.pkRange.beginKey, this.privPKey);
                operationStatus = this.doGetSearchBoth(lockMode);
                this.endOperation(null, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
                return operationStatus;
            } else {
                operationStatus = OperationStatus.NOTFOUND;
                Cursor cursor = this.beginOperation();
                try {
                    if (this.pkRange.beginKey == null) {
                        operationStatus = this.doGetSearchKey(lockMode);
                    } else {
                        KeyRange.copy(this.pkRange.beginKey, this.privPKey);
                        operationStatus = this.doGetSearchBothRange(lockMode);
                        if (operationStatus == OperationStatus.SUCCESS && !this.pkRange.beginInclusive && this.pkRange.compare(this.privPKey, this.pkRange.beginKey) == 0) {
                            operationStatus = this.doGetNextDup(lockMode);
                        }
                    }
                    if (operationStatus != OperationStatus.SUCCESS || this.pkRange.check(this.privPKey)) return operationStatus;
                    operationStatus = OperationStatus.NOTFOUND;
                    return operationStatus;
                }
                finally {
                    this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
                }
            }
        }
        if (this.range.singleKey) {
            KeyRange.copy(this.range.beginKey, this.privKey);
            operationStatus = this.doGetSearchKey(lockMode);
            this.endOperation(null, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
            return operationStatus;
        }
        operationStatus = OperationStatus.NOTFOUND;
        Cursor cursor = this.beginOperation();
        try {
            if (this.range.beginKey == null) {
                operationStatus = this.doGetFirst(lockMode);
            } else {
                KeyRange.copy(this.range.beginKey, this.privKey);
                operationStatus = this.doGetSearchKeyRange(lockMode);
                if (operationStatus == OperationStatus.SUCCESS && !this.range.beginInclusive && this.range.compare(this.privKey, this.range.beginKey) == 0) {
                    operationStatus = this.doGetNextNoDup(lockMode);
                }
            }
            if (operationStatus != OperationStatus.SUCCESS || this.range.check(this.privKey)) return operationStatus;
            operationStatus = OperationStatus.NOTFOUND;
            return operationStatus;
        }
        finally {
            this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getLast(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus = OperationStatus.NOTFOUND;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            operationStatus = this.doGetLast(lockMode);
            this.endOperation(null, operationStatus, null, null, null);
            return operationStatus;
        }
        Cursor cursor = this.beginOperation();
        try {
            if (this.pkRange != null) {
                KeyRange.copy(this.range.beginKey, this.privKey);
                boolean bl = false;
                if (this.pkRange.endKey == null) {
                    bl = true;
                } else {
                    KeyRange.copy(this.pkRange.endKey, this.privPKey);
                    operationStatus = this.doGetSearchBothRange(lockMode);
                    if (operationStatus == OperationStatus.SUCCESS) {
                        if (!this.pkRange.endInclusive || this.pkRange.compare(this.pkRange.endKey, this.privPKey) != 0) {
                            operationStatus = this.doGetPrevDup(lockMode);
                        }
                    } else {
                        KeyRange.copy(this.range.beginKey, this.privKey);
                        bl = true;
                    }
                }
                if (bl && (operationStatus = this.doGetSearchKey(lockMode)) == OperationStatus.SUCCESS) {
                    operationStatus = this.doGetNextNoDup(lockMode);
                    operationStatus = operationStatus == OperationStatus.SUCCESS ? this.doGetPrev(lockMode) : this.doGetLast(lockMode);
                }
                if (operationStatus == OperationStatus.SUCCESS && !this.pkRange.check(this.privPKey)) {
                    operationStatus = OperationStatus.NOTFOUND;
                }
            } else if (this.range.endKey == null) {
                operationStatus = this.doGetLast(lockMode);
            } else {
                KeyRange.copy(this.range.endKey, this.privKey);
                operationStatus = this.doGetSearchKeyRange(lockMode);
                operationStatus = operationStatus == OperationStatus.SUCCESS ? (this.range.endInclusive && this.range.compare(this.range.endKey, this.privKey) == 0 ? ((operationStatus = this.doGetNextNoDup(lockMode)) == OperationStatus.SUCCESS ? this.doGetPrev(lockMode) : this.doGetLast(lockMode)) : this.doGetPrev(lockMode)) : this.doGetLast(lockMode);
            }
            if (operationStatus == OperationStatus.SUCCESS && !this.range.checkBegin(this.privKey, true)) {
                operationStatus = OperationStatus.NOTFOUND;
            }
        }
        finally {
            this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationStatus getNext(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        if (!this.initialized) {
            return this.getFirst(databaseEntry, databaseEntry2, databaseEntry3, lockMode);
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            OperationStatus operationStatus2 = this.doGetNext(lockMode);
            this.endOperation(null, operationStatus2, null, null, null);
            return operationStatus2;
        }
        if (this.pkRange != null) {
            if (this.pkRange.endKey == null) {
                operationStatus = this.doGetNextDup(lockMode);
                this.endOperation(null, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
                return operationStatus;
            } else {
                operationStatus = OperationStatus.NOTFOUND;
                Cursor cursor = this.beginOperation();
                try {
                    operationStatus = this.doGetNextDup(lockMode);
                    if (operationStatus != OperationStatus.SUCCESS || this.pkRange.checkEnd(this.privPKey, true)) return operationStatus;
                    operationStatus = OperationStatus.NOTFOUND;
                    return operationStatus;
                }
                finally {
                    this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
                }
            }
        }
        if (this.range.singleKey) {
            operationStatus = this.doGetNextDup(lockMode);
            this.endOperation(null, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
            return operationStatus;
        }
        operationStatus = OperationStatus.NOTFOUND;
        Cursor cursor = this.beginOperation();
        try {
            operationStatus = this.doGetNext(lockMode);
            if (operationStatus != OperationStatus.SUCCESS || this.range.check(this.privKey)) return operationStatus;
            operationStatus = OperationStatus.NOTFOUND;
            return operationStatus;
        }
        finally {
            this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getNextNoDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        if (!this.initialized) {
            return this.getFirst(databaseEntry, databaseEntry2, databaseEntry3, lockMode);
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            OperationStatus operationStatus2 = this.doGetNextNoDup(lockMode);
            this.endOperation(null, operationStatus2, null, null, null);
            return operationStatus2;
        }
        if (this.range.singleKey) {
            operationStatus = OperationStatus.NOTFOUND;
        } else {
            operationStatus = OperationStatus.NOTFOUND;
            Cursor cursor = this.beginOperation();
            try {
                operationStatus = this.doGetNextNoDup(lockMode);
                if (operationStatus == OperationStatus.SUCCESS && !this.range.check(this.privKey)) {
                    operationStatus = OperationStatus.NOTFOUND;
                }
            }
            finally {
                this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
            }
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationStatus getPrev(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        if (!this.initialized) {
            return this.getLast(databaseEntry, databaseEntry2, databaseEntry3, lockMode);
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            OperationStatus operationStatus2 = this.doGetPrev(lockMode);
            this.endOperation(null, operationStatus2, null, null, null);
            return operationStatus2;
        }
        if (this.pkRange != null) {
            if (this.pkRange.beginKey == null) {
                operationStatus = this.doGetPrevDup(lockMode);
                this.endOperation(null, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
                return operationStatus;
            } else {
                operationStatus = OperationStatus.NOTFOUND;
                Cursor cursor = this.beginOperation();
                try {
                    operationStatus = this.doGetPrevDup(lockMode);
                    if (operationStatus != OperationStatus.SUCCESS || this.pkRange.checkBegin(this.privPKey, true)) return operationStatus;
                    operationStatus = OperationStatus.NOTFOUND;
                    return operationStatus;
                }
                finally {
                    this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
                }
            }
        }
        if (this.range.singleKey) {
            operationStatus = this.doGetPrevDup(lockMode);
            this.endOperation(null, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
            return operationStatus;
        }
        operationStatus = OperationStatus.NOTFOUND;
        Cursor cursor = this.beginOperation();
        try {
            operationStatus = this.doGetPrev(lockMode);
            if (operationStatus != OperationStatus.SUCCESS || this.range.check(this.privKey)) return operationStatus;
            operationStatus = OperationStatus.NOTFOUND;
            return operationStatus;
        }
        finally {
            this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getPrevNoDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        if (!this.initialized) {
            return this.getLast(databaseEntry, databaseEntry2, databaseEntry3, lockMode);
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            OperationStatus operationStatus2 = this.doGetPrevNoDup(lockMode);
            this.endOperation(null, operationStatus2, null, null, null);
            return operationStatus2;
        }
        if (this.range.singleKey) {
            operationStatus = OperationStatus.NOTFOUND;
        } else {
            operationStatus = OperationStatus.NOTFOUND;
            Cursor cursor = this.beginOperation();
            try {
                operationStatus = this.doGetPrevNoDup(lockMode);
                if (operationStatus == OperationStatus.SUCCESS && !this.range.check(this.privKey)) {
                    operationStatus = OperationStatus.NOTFOUND;
                }
            }
            finally {
                this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
            }
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationStatus getSearchKey(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            OperationStatus operationStatus2 = this.doGetSearchKey(lockMode);
            this.endOperation(null, operationStatus2, null, null, null);
            return operationStatus2;
        }
        if (!this.range.check(databaseEntry)) {
            return OperationStatus.NOTFOUND;
        }
        if (this.pkRange != null) {
            operationStatus = OperationStatus.NOTFOUND;
            Cursor cursor = this.beginOperation();
            try {
                RangeCursor.shareData(databaseEntry, this.privKey);
                operationStatus = this.doGetSearchKey(lockMode);
                if (operationStatus != OperationStatus.SUCCESS) return operationStatus;
                if (this.pkRange.check(this.privPKey)) return operationStatus;
                operationStatus = OperationStatus.NOTFOUND;
                return operationStatus;
            }
            finally {
                this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
            }
        } else {
            RangeCursor.shareData(databaseEntry, this.privKey);
            operationStatus = this.doGetSearchKey(lockMode);
            this.endOperation(null, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return operationStatus;
    }

    public OperationStatus getSearchBoth(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            OperationStatus operationStatus2 = this.doGetSearchBoth(lockMode);
            this.endOperation(null, operationStatus2, null, null, null);
            return operationStatus2;
        }
        if (!this.range.check(databaseEntry) || this.pkRange != null && !this.pkRange.check(databaseEntry2)) {
            operationStatus = OperationStatus.NOTFOUND;
        } else {
            RangeCursor.shareData(databaseEntry, this.privKey);
            if (this.secCursor != null) {
                RangeCursor.shareData(databaseEntry2, this.privPKey);
            } else {
                RangeCursor.shareData(databaseEntry3, this.privData);
            }
            operationStatus = this.doGetSearchBoth(lockMode);
            this.endOperation(null, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getSearchKeyRange(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus = OperationStatus.NOTFOUND;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            operationStatus = this.doGetSearchKeyRange(lockMode);
            this.endOperation(null, operationStatus, null, null, null);
            return operationStatus;
        }
        Cursor cursor = this.beginOperation();
        try {
            RangeCursor.shareData(databaseEntry, this.privKey);
            operationStatus = this.doGetSearchKeyRange(lockMode);
            if (operationStatus == OperationStatus.SUCCESS && (!this.range.check(this.privKey) || this.pkRange != null && !this.pkRange.check(databaseEntry2))) {
                operationStatus = OperationStatus.NOTFOUND;
            }
        }
        finally {
            this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getSearchBothRange(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus = OperationStatus.NOTFOUND;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            operationStatus = this.doGetSearchBothRange(lockMode);
            this.endOperation(null, operationStatus, null, null, null);
            return operationStatus;
        }
        Cursor cursor = this.beginOperation();
        try {
            RangeCursor.shareData(databaseEntry, this.privKey);
            if (this.secCursor != null) {
                RangeCursor.shareData(databaseEntry2, this.privPKey);
            } else {
                RangeCursor.shareData(databaseEntry3, this.privData);
            }
            operationStatus = this.doGetSearchBothRange(lockMode);
            if (operationStatus == OperationStatus.SUCCESS && (!this.range.check(this.privKey) || this.pkRange != null && !this.pkRange.check(databaseEntry2))) {
                operationStatus = OperationStatus.NOTFOUND;
            }
        }
        finally {
            this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return operationStatus;
    }

    public OperationStatus getSearchRecordNumber(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            OperationStatus operationStatus2 = this.doGetSearchRecordNumber(lockMode);
            this.endOperation(null, operationStatus2, null, null, null);
            return operationStatus2;
        }
        if (!this.range.check(databaseEntry)) {
            operationStatus = OperationStatus.NOTFOUND;
        } else {
            RangeCursor.shareData(databaseEntry, this.privKey);
            operationStatus = this.doGetSearchRecordNumber(lockMode);
            this.endOperation(null, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationStatus getNextDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        if (!this.initialized) {
            throw new DatabaseException("Cursor not initialized");
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            operationStatus = this.doGetNextDup(lockMode);
            this.endOperation(null, operationStatus, null, null, null);
            return operationStatus;
        } else if (this.pkRange != null && this.pkRange.endKey != null) {
            operationStatus = OperationStatus.NOTFOUND;
            Cursor cursor = this.beginOperation();
            try {
                operationStatus = this.doGetNextDup(lockMode);
                if (operationStatus != OperationStatus.SUCCESS || this.pkRange.checkEnd(this.privPKey, true)) return operationStatus;
                operationStatus = OperationStatus.NOTFOUND;
                return operationStatus;
            }
            finally {
                this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
            }
        } else {
            operationStatus = this.doGetNextDup(lockMode);
            this.endOperation(null, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationStatus getPrevDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        if (!this.initialized) {
            throw new DatabaseException("Cursor not initialized");
        }
        if (!this.range.hasBound()) {
            this.setParams(databaseEntry, databaseEntry2, databaseEntry3);
            operationStatus = this.doGetPrevDup(lockMode);
            this.endOperation(null, operationStatus, null, null, null);
            return operationStatus;
        } else if (this.pkRange != null && this.pkRange.beginKey != null) {
            operationStatus = OperationStatus.NOTFOUND;
            Cursor cursor = this.beginOperation();
            try {
                operationStatus = this.doGetPrevDup(lockMode);
                if (operationStatus != OperationStatus.SUCCESS || this.pkRange.checkBegin(this.privPKey, true)) return operationStatus;
                operationStatus = OperationStatus.NOTFOUND;
                return operationStatus;
            }
            finally {
                this.endOperation(cursor, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
            }
        } else {
            operationStatus = this.doGetPrevDup(lockMode);
            this.endOperation(null, operationStatus, databaseEntry, databaseEntry2, databaseEntry3);
        }
        return operationStatus;
    }

    public OperationStatus getCurrent(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, DatabaseEntry databaseEntry3, LockMode lockMode) throws DatabaseException {
        if (!this.initialized) {
            throw new DatabaseException("Cursor not initialized");
        }
        if (this.secCursor != null && databaseEntry2 != null) {
            return this.secCursor.getCurrent(databaseEntry, databaseEntry2, databaseEntry3, lockMode);
        }
        return this.cursor.getCurrent(databaseEntry, databaseEntry3, lockMode);
    }

    public void close() throws DatabaseException {
        this.closeCursor(this.cursor);
    }

    public int count() throws DatabaseException {
        return this.cursor.count();
    }

    public OperationStatus delete() throws DatabaseException {
        return this.cursor.delete();
    }

    public OperationStatus put(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return this.cursor.put(databaseEntry, databaseEntry2);
    }

    public OperationStatus putNoOverwrite(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return this.cursor.putNoOverwrite(databaseEntry, databaseEntry2);
    }

    public OperationStatus putNoDupData(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return this.cursor.putNoDupData(databaseEntry, databaseEntry2);
    }

    public OperationStatus putCurrent(DatabaseEntry databaseEntry) throws DatabaseException {
        return this.cursor.putCurrent(databaseEntry);
    }

    public OperationStatus putAfter(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return DbCompat.putAfter(this.cursor, databaseEntry, databaseEntry2);
    }

    public OperationStatus putBefore(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return DbCompat.putBefore(this.cursor, databaseEntry, databaseEntry2);
    }

    private OperationStatus doGetFirst(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getFirst(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getFirst(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetLast(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getLast(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getLast(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetNext(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getNext(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getNext(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetNextDup(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getNextDup(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getNextDup(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetNextNoDup(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getNextNoDup(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getNextNoDup(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetPrev(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getPrev(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getPrev(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetPrevDup(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getPrevDup(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getPrevDup(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetPrevNoDup(LockMode lockMode) throws DatabaseException {
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getPrevNoDup(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getPrevNoDup(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetSearchKey(LockMode lockMode) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return OperationStatus.NOTFOUND;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getSearchKey(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getSearchKey(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetSearchKeyRange(LockMode lockMode) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return OperationStatus.NOTFOUND;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getSearchKeyRange(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getSearchKeyRange(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetSearchBoth(LockMode lockMode) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return OperationStatus.NOTFOUND;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getSearchBoth(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getSearchBoth(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetSearchBothRange(LockMode lockMode) throws DatabaseException {
        if (this.checkRecordNumber() && DbCompat.getRecordNumber(this.privKey) <= 0) {
            return OperationStatus.NOTFOUND;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return this.secCursor.getSearchBothRange(this.privKey, this.privPKey, this.privData, lockMode);
        }
        return this.cursor.getSearchBothRange(this.privKey, this.privData, lockMode);
    }

    private OperationStatus doGetSearchRecordNumber(LockMode lockMode) throws DatabaseException {
        if (DbCompat.getRecordNumber(this.privKey) <= 0) {
            return OperationStatus.NOTFOUND;
        }
        if (this.secCursor != null && this.privPKey != null) {
            return DbCompat.getSearchRecordNumber(this.secCursor, this.privKey, this.privPKey, this.privData, lockMode);
        }
        return DbCompat.getSearchRecordNumber(this.cursor, this.privKey, this.privData, lockMode);
    }

    protected Cursor dupCursor(Cursor cursor, boolean bl) throws DatabaseException {
        return cursor.dup(bl);
    }

    protected void closeCursor(Cursor cursor) throws DatabaseException {
        cursor.close();
    }

    protected boolean checkRecordNumber() {
        return false;
    }
}

