/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.search.SearchTerm;

public final class FlagTerm
extends SearchTerm {
    protected boolean set;
    protected Flags flags;

    public FlagTerm(Flags flags, boolean bl) {
        this.flags = flags;
        this.set = bl;
    }

    public Flags getFlags() {
        return (Flags)this.flags.clone();
    }

    public boolean getTestSet() {
        return this.set;
    }

    public boolean match(Message message) {
        try {
            Flags flags = message.getFlags();
            if (this.set) {
                return flags.contains(this.flags);
            }
            Flags.Flag[] flagArray = this.flags.getSystemFlags();
            int n = 0;
            while (n < flagArray.length) {
                if (flags.contains(flagArray[n])) {
                    return false;
                }
                ++n;
            }
            String[] stringArray = this.flags.getUserFlags();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (flags.contains(stringArray[n2])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof FlagTerm)) {
            return false;
        }
        FlagTerm flagTerm = (FlagTerm)object;
        return flagTerm.set == this.set && flagTerm.flags.equals(this.flags);
    }

    public int hashCode() {
        if (this.set) {
            return this.flags.hashCode();
        }
        return ~this.flags.hashCode();
    }
}

