/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.filestore;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.endpoint.ClusterFileStoreApis;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.UploadToFileStoreResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.filestore.DistribFileStore;
import org.apache.solr.filestore.FileStore;
import org.apache.solr.filestore.FileStoreAPI;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.CryptoKeys;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterFileStore
extends JerseyResource
implements ClusterFileStoreApis {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String FILESTORE_DIRECTORY = "filestore";
    public static final String TRUSTED_DIR = "_trusted_";
    public static final String KEYS_DIR = "/_trusted_/keys";
    static final String TMP_ZK_NODE = "/fileStoreWriteInProgress";
    private final CoreContainer coreContainer;
    private final SolrQueryRequest req;
    private final SolrQueryResponse rsp;
    private final FileStore fileStore;
    static final String INVALIDCHARS = " /\\#&*\n\t%@~`=+^$><?{}[]|:;!";

    @Inject
    public ClusterFileStore(CoreContainer coreContainer, DistribFileStore fileStore, SolrQueryRequest req, SolrQueryResponse rsp) {
        this.coreContainer = coreContainer;
        this.req = req;
        this.rsp = rsp;
        this.fileStore = fileStore;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PermissionName(value=PermissionNameProvider.Name.FILESTORE_WRITE_PERM)
    public UploadToFileStoreResponse uploadFile(String filePath, List<String> sig, InputStream requestBody) {
        UploadToFileStoreResponse response = this.instantiateJerseyResponse(UploadToFileStoreResponse.class);
        if (!this.coreContainer.getPackageLoader().getPackageAPI().isEnabled()) {
            throw new RuntimeException("Package loading is not enabled , Start your nodes with -Denable.packages=true");
        }
        try {
            this.coreContainer.getZkController().getZkClient().create(TMP_ZK_NODE, "true".getBytes(StandardCharsets.UTF_8), CreateMode.EPHEMERAL, true);
            if (requestBody == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no payload");
            }
            if (filePath == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No path");
            }
            ClusterFileStore.validateName(filePath, true);
            try {
                byte[] buf = requestBody.readAllBytes();
                List<String> signatures = this.readSignatures(sig, buf);
                FileStoreAPI.MetaData meta = ClusterFileStore._createJsonMetaData(buf, signatures);
                FileStore.FileType type = this.fileStore.getType(filePath, true);
                if (type == FileStore.FileType.FILE) {
                    this.fileStore.get(filePath, fileEntry -> {
                        if (meta.equals(fileEntry.meta)) {
                            response.file = filePath;
                            response.message = "File with same metadata exists ";
                        }
                    }, true);
                    if (response.message != null) {
                        UploadToFileStoreResponse uploadToFileStoreResponse = response;
                        return uploadToFileStoreResponse;
                    }
                } else if (type != FileStore.FileType.NOFILE) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Path already exists " + filePath);
                }
                this.fileStore.put(new FileStore.FileEntry(ByteBuffer.wrap(buf), meta, filePath));
                response.file = filePath;
                return response;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            log.error("Unexpected error", (Throwable)e);
            return response;
        }
        catch (KeeperException.NodeExistsException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A write is already in process , try later");
        }
        catch (KeeperException e) {
            log.error("Unexpected error", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e.getMessage());
        }
        finally {
            try {
                this.coreContainer.getZkController().getZkClient().delete(TMP_ZK_NODE, -1, true);
            }
            catch (Exception e) {
                log.error("Unexpected error  ", (Throwable)e);
            }
        }
    }

    private void doLocalDelete(String filePath) {
        this.fileStore.deleteLocal(filePath);
    }

    private void doClusterDelete(String filePath) {
        FileStore.FileType type = this.fileStore.getType(filePath, true);
        if (type == FileStore.FileType.NOFILE) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Path does not exist: " + filePath);
        }
        try {
            this.coreContainer.getZkController().getZkClient().create(TMP_ZK_NODE, "true".getBytes(StandardCharsets.UTF_8), CreateMode.EPHEMERAL, true);
            this.fileStore.delete(filePath);
        }
        catch (Exception e) {
            log.error("Unknown error", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        finally {
            try {
                this.coreContainer.getZkController().getZkClient().delete(TMP_ZK_NODE, -1, true);
            }
            catch (Exception e) {
                log.error("Unexpected error  ", (Throwable)e);
            }
        }
    }

    private void doDelete(String filePath, Boolean localDelete) {
        if (Boolean.TRUE.equals(localDelete)) {
            this.doLocalDelete(filePath);
        } else {
            this.doClusterDelete(filePath);
        }
    }

    @PermissionName(value=PermissionNameProvider.Name.FILESTORE_WRITE_PERM)
    public SolrJerseyResponse deleteFile(String filePath, Boolean localDelete) {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        if (!this.coreContainer.getPackageLoader().getPackageAPI().isEnabled()) {
            throw new RuntimeException("Package loading is not enabled , Start your nodes with -Denable.packages=true");
        }
        ClusterFileStore.validateName(filePath, true);
        if (this.coreContainer.getPackageLoader().getPackageAPI().isJarInuse(filePath)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "jar in use, can't delete");
        }
        this.doDelete(filePath, localDelete);
        return response;
    }

    private List<String> readSignatures(List<String> signatures, byte[] buf) throws SolrException, IOException {
        if (signatures == null || signatures.isEmpty()) {
            return null;
        }
        this.fileStore.refresh(KEYS_DIR);
        this.validate(signatures, buf);
        return signatures;
    }

    private void validate(List<String> sigs, byte[] buf) throws SolrException, IOException {
        Map<String, byte[]> keys = this.fileStore.getKeys();
        if (keys == null || keys.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "File store does not have any keys");
        }
        CryptoKeys cryptoKeys = null;
        try {
            cryptoKeys = new CryptoKeys(keys);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing public keys in file store");
        }
        for (String sig : sigs) {
            if (cryptoKeys.verify(sig, ByteBuffer.wrap(buf)) != null) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Signature does not match any public key : " + sig + " len: " + buf.length + " content sha512: " + DigestUtils.sha512Hex((byte[])buf));
        }
    }

    public static FileStoreAPI.MetaData _createJsonMetaData(byte[] buf, List<String> signatures) throws IOException {
        String sha512 = DigestUtils.sha512Hex((byte[])buf);
        HashMap<String, Object> vals = new HashMap<String, Object>();
        vals.put("sha512", sha512);
        if (signatures != null) {
            vals.put("sig", signatures);
        }
        return new FileStoreAPI.MetaData(vals);
    }

    public static void validateName(String path, boolean failForTrusted) {
        if (path == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "empty path");
        }
        List parts = StrUtils.splitSmart((String)path, (char)'/', (boolean)true);
        for (String part : parts) {
            if (part.charAt(0) == '.') {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "cannot start with period");
            }
            for (int i = 0; i < part.length(); ++i) {
                for (int j = 0; j < INVALIDCHARS.length(); ++j) {
                    if (part.charAt(i) != INVALIDCHARS.charAt(j)) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported char in file name: " + part);
                }
            }
        }
        if (failForTrusted && TRUSTED_DIR.equals(parts.get(0))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "trying to write into /_trusted_/ directory");
        }
    }
}

