/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.jcip.annotations.NotThreadSafe;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.ExitableDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MoreLikeThisParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.api.MoreLikeThisAPI;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryCommand;
import org.apache.solr.search.QueryLimits;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreLikeThisHandler
extends RequestHandlerBase {
    private static final Pattern splitList = Pattern.compile(",| ");
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String ERR_MSG_QUERY_OR_TEXT_REQUIRED = "MoreLikeThis requires either a query (?q=) or text to find similar documents.";
    static final String ERR_MSG_SINGLE_STREAM_ONLY = "MoreLikeThis does not support multiple ContentStreams";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        try {
            DocListAndSet mltDocs;
            MoreLikeThisParams.TermStyle termStyle;
            MoreLikeThisHelper mlt;
            List<Query> filters;
            String q;
            block36: {
                SolrReturnFields returnFields = new SolrReturnFields(req);
                rsp.setReturnFields(returnFields);
                int flags = 0;
                if (((ReturnFields)returnFields).wantsScore()) {
                    flags |= 1;
                }
                String defType = params.get("defType", "lucene");
                q = params.get("q");
                Query query = null;
                SortSpec sortSpec = null;
                filters = null;
                try {
                    if (q != null) {
                        QParser parser = QParser.getParser(q, defType, req);
                        query = parser.getQuery();
                        sortSpec = parser.getSortSpec(true);
                    }
                    filters = QueryUtils.parseFilterQueries(req);
                }
                catch (SyntaxError e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
                SolrIndexSearcher searcher = req.getSearcher();
                mlt = new MoreLikeThisHelper(params, searcher);
                termStyle = MoreLikeThisParams.TermStyle.get((String)params.get("mlt.interestingTerms"));
                mltDocs = null;
                try (Reader reader = null;){
                    Iterable<ContentStream> streams;
                    if ((q == null || q.trim().length() < 1) && (streams = req.getContentStreams()) != null) {
                        Iterator<ContentStream> iter = streams.iterator();
                        if (iter.hasNext()) {
                            reader = iter.next().getReader();
                        }
                        if (iter.hasNext()) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ERR_MSG_SINGLE_STREAM_ONLY);
                        }
                    }
                    int start = params.getInt("start", 0);
                    int rows = params.getInt("rows", 10);
                    if (reader != null) {
                        mltDocs = mlt.getMoreLikeThis(reader, start, rows, filters, flags);
                        break block36;
                    }
                    if (q != null) {
                        DocIterator iterator;
                        Iterator<InterestingTerm> match = new QueryCommand().setQuery(query).setOffset(params.getInt("mlt.match.offset", 0)).setLen(1).setFlags(flags).search(searcher).getDocList();
                        if (params.getBool("mlt.match.include", true)) {
                            rsp.add("match", match);
                        }
                        if ((iterator = match.iterator()).hasNext()) {
                            int id = iterator.nextDoc();
                            mltDocs = mlt.getMoreLikeThis(id, start, rows, filters, flags);
                        }
                        break block36;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ERR_MSG_QUERY_OR_TEXT_REQUIRED);
                }
            }
            if (mltDocs == null) {
                mltDocs = new DocListAndSet();
            }
            rsp.addResponse(mltDocs.docList);
            if (termStyle != MoreLikeThisParams.TermStyle.NONE) {
                List<InterestingTerm> interesting = mlt.getInterestingTerms(mlt.getBoostedMLTQuery(), mlt.mlt.getMaxQueryTerms());
                if (termStyle == MoreLikeThisParams.TermStyle.DETAILS) {
                    NamedList it = new NamedList();
                    for (InterestingTerm t : interesting) {
                        it.add(t.term.toString(), (Object)Float.valueOf(t.boost));
                    }
                    rsp.add("interestingTerms", it);
                } else {
                    ArrayList<String> it = new ArrayList<String>(interesting.size());
                    for (InterestingTerm t : interesting) {
                        it.add(t.term.text());
                    }
                    rsp.add("interestingTerms", it);
                }
            }
            if (params.getBool("facet", false)) {
                if (mltDocs.docSet == null) {
                    rsp.add("facet_counts", null);
                } else {
                    ResponseBuilder responseBuilder = new ResponseBuilder(req, rsp, Collections.emptyList());
                    responseBuilder.setQuery(mlt.getRealMLTQuery());
                    SimpleFacets f = new SimpleFacets(req, mltDocs.docSet, params, responseBuilder);
                    FacetComponent.FacetContext.initContext(responseBuilder);
                    rsp.add("facet_counts", FacetComponent.getFacetCounts(f));
                }
            }
            boolean dbg = req.getParams().getBool("debugQuery", false);
            boolean dbgQuery = false;
            boolean dbgResults = false;
            if (!dbg) {
                String[] dbgParams = req.getParams().getParams("debug");
                if (dbgParams != null) {
                    for (String dbgParam : dbgParams) {
                        if (dbgParam.equals("query")) {
                            dbgQuery = true;
                            continue;
                        }
                        if (!dbgParam.equals("results")) continue;
                        dbgResults = true;
                    }
                }
            } else {
                dbgQuery = true;
                dbgResults = true;
            }
            if (dbg) {
                try {
                    NamedList<Object> dbgInfo = SolrPluginUtils.doStandardDebug(req, q, mlt.getRawMLTQuery(), mltDocs.docList, dbgQuery, dbgResults);
                    if (null != filters) {
                        dbgInfo.add("filter_queries", (Object)req.getParams().getParams("fq"));
                        ArrayList<String> fqs = new ArrayList<String>(filters.size());
                        for (Query fq : filters) {
                            fqs.add(QueryParsing.toString(fq, req.getSchema()));
                        }
                        dbgInfo.add("parsed_filter_queries", fqs);
                    }
                    rsp.add("debug", dbgInfo);
                }
                catch (Exception e) {
                    log.error("Exception during debug: {}", (Object)e, (Object)e);
                    rsp.add("exception_during_debug", e.getMessage());
                }
            }
        }
        catch (ExitableDirectoryReader.ExitingReaderException ex) {
            log.warn("Query: {}; ", (Object)req.getParamString(), (Object)ex);
            QueryLimits queryLimits = QueryLimits.getCurrentLimits();
            queryLimits.maybeExitWithPartialResults("MoreLikeThis");
        }
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    @Override
    public String getDescription() {
        return "Solr MoreLikeThis";
    }

    @Override
    public Collection<Api> getApis() {
        return List.copyOf(AnnotatedApi.getApis(new MoreLikeThisAPI(this)));
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @NotThreadSafe
    public static class MoreLikeThisHelper {
        final SolrIndexSearcher searcher;
        final MoreLikeThis mlt;
        final IndexReader reader;
        final StoredFields storedFields;
        final SchemaField uniqueKeyField;
        final boolean needDocSet;
        Map<String, Float> boostFields;
        private Query rawMLTQuery;
        private BooleanQuery boostedMLTQuery;
        private BooleanQuery realMLTQuery;

        public MoreLikeThisHelper(SolrParams params, SolrIndexSearcher searcher) throws IOException {
            this.searcher = searcher;
            this.reader = searcher.getIndexReader();
            this.storedFields = this.reader.storedFields();
            this.uniqueKeyField = searcher.getSchema().getUniqueKeyField();
            this.needDocSet = params.getBool("facet", false);
            RequiredSolrParams required = params.required();
            String[] fl = required.getParams("mlt.fl");
            ArrayList<String> list = new ArrayList<String>();
            for (String f : fl) {
                String[] strings;
                if (!StrUtils.isNotNullOrEmpty((String)f)) continue;
                for (String string : strings = splitList.split(f)) {
                    if (!StrUtils.isNotNullOrEmpty((String)string)) continue;
                    list.add(string);
                }
            }
            String[] fields = list.toArray(new String[0]);
            if (fields.length < 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "MoreLikeThis requires at least one similarity field: mlt.fl");
            }
            this.mlt = new MoreLikeThis(this.reader);
            this.mlt.setFieldNames(fields);
            this.mlt.setAnalyzer(searcher.getSchema().getIndexAnalyzer());
            this.mlt.setMinTermFreq(params.getInt("mlt.mintf", 2));
            this.mlt.setMinDocFreq(params.getInt("mlt.mindf", 5));
            this.mlt.setMaxDocFreq(params.getInt("mlt.maxdf", Integer.MAX_VALUE));
            this.mlt.setMinWordLen(params.getInt("mlt.minwl", 0));
            this.mlt.setMaxWordLen(params.getInt("mlt.maxwl", 0));
            this.mlt.setMaxQueryTerms(params.getInt("mlt.maxqt", 25));
            this.mlt.setMaxNumTokensParsed(params.getInt("mlt.maxntp", 5000));
            this.mlt.setBoost(params.getBool("mlt.boost", false));
            if (params.getInt("mlt.maxdfpct") != null) {
                this.mlt.setMaxDocFreqPct(params.getInt("mlt.maxdfpct").intValue());
            }
            this.boostFields = SolrPluginUtils.parseFieldBoosts(params.getParams("mlt.qf"));
        }

        public Query getRawMLTQuery() {
            return this.rawMLTQuery;
        }

        public BooleanQuery getBoostedMLTQuery() {
            return this.boostedMLTQuery;
        }

        public Query getRealMLTQuery() {
            return this.realMLTQuery;
        }

        private BooleanQuery getBoostedQuery(Query mltquery) {
            BooleanQuery boostedQuery = (BooleanQuery)mltquery;
            if (this.boostFields.size() > 0) {
                BooleanQuery.Builder newQ = new BooleanQuery.Builder();
                newQ.setMinimumNumberShouldMatch(boostedQuery.getMinimumNumberShouldMatch());
                for (BooleanClause clause : boostedQuery) {
                    Float fieldBoost;
                    Query q = clause.getQuery();
                    float originalBoost = 1.0f;
                    if (q instanceof BoostQuery) {
                        BoostQuery bq = (BoostQuery)q;
                        q = bq.getQuery();
                        originalBoost = bq.getBoost();
                    }
                    q = (fieldBoost = this.boostFields.get(((TermQuery)q).getTerm().field())) != null ? new BoostQuery(q, fieldBoost.floatValue() * originalBoost) : clause.getQuery();
                    newQ.add(q, clause.getOccur());
                }
                boostedQuery = newQ.build();
            }
            return boostedQuery;
        }

        public DocListAndSet getMoreLikeThis(int id, int start, int rows, List<Query> filters, int flags) throws IOException {
            Document doc = this.storedFields.document(id);
            BooleanQuery boostedQuery = this.getBoostedMLTQuery(id);
            BooleanQuery.Builder realMLTQuery = new BooleanQuery.Builder();
            realMLTQuery.add((Query)boostedQuery, BooleanClause.Occur.MUST);
            realMLTQuery.add((Query)new TermQuery(new Term(this.uniqueKeyField.getName(), this.uniqueKeyField.getType().storedToIndexed(doc.getField(this.uniqueKeyField.getName())))), BooleanClause.Occur.MUST_NOT);
            this.realMLTQuery = realMLTQuery.build();
            DocListAndSet results = new DocListAndSet();
            if (this.needDocSet) {
                results = this.searcher.getDocListAndSet((Query)this.realMLTQuery, filters, null, start, rows, flags);
            } else {
                results.docList = this.searcher.getDocList((Query)this.realMLTQuery, filters, null, start, rows, flags);
            }
            return results;
        }

        public BooleanQuery getBoostedMLTQuery(int docNum) throws IOException {
            this.rawMLTQuery = this.mlt.like(docNum);
            this.boostedMLTQuery = this.getBoostedQuery(this.rawMLTQuery);
            return this.boostedMLTQuery;
        }

        public DocListAndSet getMoreLikeThis(Reader reader, int start, int rows, List<Query> filters, int flags) throws IOException {
            String[] fields = this.mlt.getFieldNames();
            if (fields.length == 1) {
                this.rawMLTQuery = this.mlt.like(fields[0], new Reader[]{reader});
            } else {
                int len;
                CharsRefBuilder buffered = new CharsRefBuilder();
                char[] chunk = new char[1024];
                while ((len = reader.read(chunk)) >= 0) {
                    buffered.append(chunk, 0, len);
                }
                Set<String> streamValue = Collections.singleton(buffered.get().toString());
                HashMap multifieldDoc = CollectionUtil.newHashMap((int)fields.length);
                for (String field : fields) {
                    multifieldDoc.put(field, streamValue);
                }
                this.rawMLTQuery = this.mlt.like((Map)multifieldDoc);
            }
            this.boostedMLTQuery = this.getBoostedQuery(this.rawMLTQuery);
            DocListAndSet results = new DocListAndSet();
            if (this.needDocSet) {
                results = this.searcher.getDocListAndSet((Query)this.boostedMLTQuery, filters, null, start, rows, flags);
            } else {
                results.docList = this.searcher.getDocList((Query)this.boostedMLTQuery, filters, null, start, rows, flags);
            }
            return results;
        }

        public List<InterestingTerm> getInterestingTerms(BooleanQuery boostedMLTQuery, int maxTerms) {
            assert (boostedMLTQuery != null) : "strictly expecting it's set";
            List clauses = boostedMLTQuery.clauses();
            ArrayList<InterestingTerm> output = new ArrayList<InterestingTerm>(maxTerms < 0 ? clauses.size() : maxTerms);
            for (BooleanClause o : clauses) {
                if (maxTerms > -1 && output.size() >= maxTerms) break;
                Query q = o.getQuery();
                float boost = 1.0f;
                if (q instanceof BoostQuery) {
                    BoostQuery bq = (BoostQuery)q;
                    q = bq.getQuery();
                    boost = bq.getBoost();
                }
                InterestingTerm it = new InterestingTerm();
                it.boost = boost;
                it.term = ((TermQuery)q).getTerm();
                output.add(it);
            }
            return output;
        }

        public MoreLikeThis getMoreLikeThis() {
            return this.mlt;
        }
    }

    public static class InterestingTerm {
        public Term term;
        public float boost;
    }
}

