/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.configsets;

import java.util.HashMap;
import org.apache.solr.api.EndPoint;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.configsets.ConfigSetAPIBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class DeleteConfigSetAPI
extends ConfigSetAPIBase {
    public static final String CONFIGSET_NAME_PLACEHOLDER = "name";

    public DeleteConfigSetAPI(CoreContainer coreContainer) {
        super(coreContainer);
    }

    @EndPoint(method={SolrRequest.METHOD.DELETE}, path={"/cluster/configs/{name}"}, permission=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public void deleteConfigSet(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String configSetName = req.getPathTemplateValues().get(CONFIGSET_NAME_PLACEHOLDER);
        if (StrUtils.isNullOrEmpty((String)configSetName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No configset name provided to delete");
        }
        HashMap<String, Object> configsetCommandMsg = new HashMap<String, Object>();
        configsetCommandMsg.put(CONFIGSET_NAME_PLACEHOLDER, configSetName);
        this.runConfigSetCommand(rsp, ConfigSetParams.ConfigSetAction.DELETE, configsetCommandMsg);
    }
}

