/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.streams.TaskMetadata;
import org.apache.kafka.streams.ThreadMetadata;

public class ThreadMetadataImpl
implements ThreadMetadata {
    private final String threadName;
    private final String threadState;
    private final Set<TaskMetadata> activeTasks;
    private final Set<TaskMetadata> standbyTasks;
    private final String mainConsumerClientId;
    private final String restoreConsumerClientId;
    private final Set<String> producerClientIds;
    private final String adminClientId;

    public ThreadMetadataImpl(String threadName, String threadState, String mainConsumerClientId, String restoreConsumerClientId, Set<String> producerClientIds, String adminClientId, Set<TaskMetadata> activeTasks, Set<TaskMetadata> standbyTasks) {
        this.mainConsumerClientId = mainConsumerClientId;
        this.restoreConsumerClientId = restoreConsumerClientId;
        this.producerClientIds = Collections.unmodifiableSet(producerClientIds);
        this.adminClientId = adminClientId;
        this.threadName = threadName;
        this.threadState = threadState;
        this.activeTasks = Collections.unmodifiableSet(activeTasks);
        this.standbyTasks = Collections.unmodifiableSet(standbyTasks);
    }

    @Override
    public String threadState() {
        return this.threadState;
    }

    @Override
    public String threadName() {
        return this.threadName;
    }

    @Override
    public Set<TaskMetadata> activeTasks() {
        return this.activeTasks;
    }

    @Override
    public Set<TaskMetadata> standbyTasks() {
        return this.standbyTasks;
    }

    @Override
    public String consumerClientId() {
        return this.mainConsumerClientId;
    }

    @Override
    public String restoreConsumerClientId() {
        return this.restoreConsumerClientId;
    }

    @Override
    public Set<String> producerClientIds() {
        return this.producerClientIds;
    }

    @Override
    public String adminClientId() {
        return this.adminClientId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadMetadataImpl that = (ThreadMetadataImpl)o;
        return Objects.equals(this.threadName, that.threadName) && Objects.equals(this.threadState, that.threadState) && Objects.equals(this.activeTasks, that.activeTasks) && Objects.equals(this.standbyTasks, that.standbyTasks) && this.mainConsumerClientId.equals(that.mainConsumerClientId) && this.restoreConsumerClientId.equals(that.restoreConsumerClientId) && Objects.equals(this.producerClientIds, that.producerClientIds) && this.adminClientId.equals(that.adminClientId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.threadName, this.threadState, this.activeTasks, this.standbyTasks, this.mainConsumerClientId, this.restoreConsumerClientId, this.producerClientIds, this.adminClientId);
    }

    public String toString() {
        return "ThreadMetadata{threadName=" + this.threadName + ", threadState=" + this.threadState + ", activeTasks=" + this.activeTasks + ", standbyTasks=" + this.standbyTasks + ", consumerClientId=" + this.mainConsumerClientId + ", restoreConsumerClientId=" + this.restoreConsumerClientId + ", producerClientIds=" + this.producerClientIds + ", adminClientId=" + this.adminClientId + '}';
    }
}

