/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.arnx.jsonic.util.BeanInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorInfo
implements Comparable<ConstructorInfo> {
    private Class<?> beanClass;
    List<Constructor<?>> constructors = new ArrayList();

    public ConstructorInfo(Class<?> clazz, Collection<Constructor<?>> collection) {
        this.beanClass = clazz;
        if (collection != null) {
            this.constructors.addAll(collection);
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Object newInstance(Object ... objectArray) {
        Constructor<?> constructor = this.findConstructor(objectArray);
        try {
            return constructor.newInstance(objectArray);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    public int compareTo(ConstructorInfo constructorInfo) {
        if (!this.beanClass.equals(constructorInfo.beanClass)) {
            return this.beanClass.getName().compareTo(constructorInfo.beanClass.getName());
        }
        return 0;
    }

    public Constructor<?> findConstructor(Object ... objectArray) {
        Constructor<?> constructor = null;
        Class<?>[] classArray = null;
        Constructor<?> constructor2 = null;
        Class<?>[] classArray2 = null;
        for (Constructor<?> constructor3 : this.constructors) {
            Class<?>[] classArray3 = constructor3.getParameterTypes();
            if (constructor3.isVarArgs()) {
                if (objectArray.length < classArray3.length - 1) continue;
                if (constructor2 == null) {
                    Class<?> clazz = classArray3[classArray3.length - 1].getComponentType();
                    Class[] classArray4 = new Class[objectArray.length];
                    System.arraycopy(classArray3, 0, classArray4, 0, classArray3.length - 1);
                    for (int i = classArray3.length - 1; i < classArray4.length; ++i) {
                        classArray4[i] = clazz;
                    }
                    constructor2 = constructor3;
                    classArray2 = classArray4;
                    continue;
                }
                int n = BeanInfo.calcurateDistance(classArray2, objectArray);
                int n2 = BeanInfo.calcurateDistance(classArray3, objectArray);
                if (n2 > n) {
                    constructor2 = constructor3;
                    classArray2 = classArray3;
                    continue;
                }
                if (n2 != n) continue;
                constructor3 = null;
                classArray3 = null;
                continue;
            }
            if (objectArray.length != classArray3.length) continue;
            if (constructor == null) {
                constructor = constructor3;
                classArray = classArray3;
                continue;
            }
            int n = BeanInfo.calcurateDistance(classArray, objectArray);
            int n3 = BeanInfo.calcurateDistance(classArray3, objectArray);
            if (n3 > n) {
                constructor = constructor3;
                classArray = classArray3;
                continue;
            }
            if (n3 != n) continue;
            constructor3 = null;
            classArray3 = null;
        }
        if (constructor2 != null) {
            if (constructor == null) {
                constructor = constructor2;
            } else {
                int n = BeanInfo.calcurateDistance(classArray, objectArray);
                int n4 = BeanInfo.calcurateDistance(classArray2, objectArray);
                if (n4 > n) {
                    constructor = constructor2;
                }
            }
        }
        if (constructor == null) {
            throw new IllegalStateException("suitable constructor is not found.");
        }
        return constructor;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.beanClass == null ? 0 : this.beanClass.hashCode());
        n = 31 * n + (this.constructors == null ? 0 : this.constructors.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ConstructorInfo constructorInfo = (ConstructorInfo)object;
        if (this.beanClass == null ? constructorInfo.beanClass != null : !this.beanClass.equals(constructorInfo.beanClass)) {
            return false;
        }
        return !(this.constructors == null ? constructorInfo.constructors != null : !this.constructors.equals(constructorInfo.constructors));
    }

    public String toString() {
        return "ConstructorInfo [beanClass=" + this.beanClass + ", constructors=" + this.constructors + "]";
    }
}

