/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.io.IOException;
import java.util.HashSet;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.PRJDataStore;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.image.FormatFilter;
import org.apache.sis.internal.storage.image.FormatFinder;
import org.apache.sis.internal.storage.image.MultiImageStore;
import org.apache.sis.internal.storage.image.SingleImageStore;
import org.apache.sis.internal.storage.image.WorldFileStore;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;

@StoreMetadata(formatName="World file", fileSuffixes={"jpeg", "jpg", "png", "gif", "bmp"}, capabilities={Capability.READ, Capability.WRITE, Capability.CREATE}, resourceTypes={Aggregate.class, GridCoverageResource.class})
public final class WorldFileStoreProvider
extends PRJDataStore.Provider {
    static final String NAME = "World file";
    private static final String[] SINGLE_IMAGE_FORMATS = new String[]{"PNG", "BMP", "WBMP", "JPEG"};
    private final boolean allowSingleton;

    public WorldFileStoreProvider() {
        this.allowSingleton = true;
    }

    public WorldFileStoreProvider(boolean bl) {
        this.allowSingleton = bl;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public WorldFileStore open(StorageConnector storageConnector) throws DataStoreException {
        WorldFileStore worldFileStore;
        try (FormatFinder formatFinder = new FormatFinder(this, storageConnector);){
            String[] stringArray;
            boolean bl = false;
            if (this.allowSingleton && (stringArray = formatFinder.getFormatName()) != null) {
                String string;
                String[] stringArray2 = stringArray;
                int n = stringArray2.length;
                for (int i = 0; i < n && !(bl = ArraysExt.containsIgnoreCase(SINGLE_IMAGE_FORMATS, string = stringArray2[i])); ++i) {
                }
            }
            worldFileStore = formatFinder.isWritable ? (bl ? new SingleImageStore.Writable(formatFinder) : new MultiImageStore.Writable(formatFinder)) : (bl ? new SingleImageStore(formatFinder) : new MultiImageStore(formatFinder));
        }
        catch (IOException iOException) {
            throw new DataStoreException(iOException);
        }
        return worldFileStore;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        ImageReaderSpi imageReaderSpi;
        HashSet<ImageReaderSpi> hashSet = new HashSet<ImageReaderSpi>();
        String string = IOUtilities.extension(storageConnector.getStorage());
        try {
            imageReaderSpi = FormatFilter.SUFFIX.findProvider(string, storageConnector, hashSet);
            if (imageReaderSpi == null && (imageReaderSpi = FormatFilter.SUFFIX.findProvider(null, storageConnector, hashSet)) == null) {
                return ProbeResult.UNSUPPORTED_STORAGE;
            }
        }
        catch (IOException iOException) {
            throw new DataStoreException(iOException);
        }
        String[] stringArray = imageReaderSpi.getMIMETypes();
        if (stringArray != null && stringArray.length != 0) {
            return new ProbeResult(true, stringArray[0], null);
        }
        return ProbeResult.SUPPORTED;
    }
}

