


CLISP(1)                 USER COMMANDS                   CLISP(1)



NAME
     clisp - Common Lisp language interpreter and compiler

SYNOPSIS
     clisp [ -h | --help ] [ --version  ]  [  --license  ]  [  -B
     _l_i_s_p_l_i_b_d_i_r  ] [ -K _l_i_n_k_i_n_g-_s_e_t ] [ -M _m_e_m_f_i_l_e ] [ -m _m_e_m_s_i_z_e
     ] [ -L _l_a_n_g_u_a_g_e ] [ -N _l_o_c_a_l_e_d_i_r ] [ -E_d_o_m_a_i_n _e_n_c_o_d_i_n_g  ]  [
     -q  |  --quiet  | --silent ] [ -w ] [ -I ] [ -a ] [ -p _p_a_c_k_-
     _a_g_e_n_a_m_e ] [ -C ] [ -norc ] [ -i _i_n_i_t_f_i_l_e ...  ] [ -c [ -l  ]
     _l_i_s_p_f_i_l_e  [  -o  _o_u_t_p_u_t_f_i_l_e  ]  ...   ]  [ -x _e_x_p_r_e_s_s_i_o_n ] [
     _l_i_s_p_f_i_l_e [ _a_r_g_u_m_e_n_t ] ]

DESCRIPTION
     Invokes the common lisp interpreter and  compiler.   Invoked
     without arguments, executes a read-eval-print loop, in which
     expressions are in turn read from standard input,  evaluated
     by  the  lisp interpreter, and their results output to stan-
     dard output.  Invoked with -c, the specified lisp files  are
     compiled  to  a  bytecode  that  can  be executed more effi-
     ciently.

OPTIONS
     -h, --help
          Displays a help message on how to use clisp.

     --version
          Displays the clisp version  number,  as  given  by  the
          function call (_l_i_s_p-_i_m_p_l_e_m_e_n_t_a_t_i_o_n-_v_e_r_s_i_o_n).

     --license
          Displays a summary of the  licensing  information,  the
          GNU GPL.

     -B _l_i_s_p_l_i_b_d_i_r
          Specifies  the  installation  directory.  This  is  the
          directory  containing  the  linking sets and other data
          files.  This option is normally not necessary,  because
          the  installation  directory is already built-in in the
          clisp executable.

     -K _l_i_n_k_i_n_g-_s_e_t
          Specifies the linking set to be run. This is  a  direc-
          tory  containing at least a main executable and an ini-
          tial memory image. Possible values are base, full.  The
          default is base.

     -M _m_e_m_f_i_l_e
          Specifies the initial memory image.   This  must  be  a
          memory  dump  produced by the _s_a_v_e_i_n_i_t_m_e_m function.  It
          may have been compressed using GNU gzip.

     -m _m_e_m_s_i_z_e



Sun Release 4.1   Last change: 15 January 2000                  1






CLISP(1)                 USER COMMANDS                   CLISP(1)



          Sets the amount  of  memory  clisp  tries  to  grab  on
          startup.   The amount may be given as _n_n_n_n_n_n_n (measured
          in bytes), _n_n_n_nK or _n_n_n_nKB (measured in  kilobytes)  or
          _nM  or _nMB (measured in megabytes).  Default is 2 mega-
          bytes.  The argument is constrained above 100  KB.   --
          This version of clisp is not likely to actually use the
          entire _m_e_m_s_i_z_e since garbage collection  will  periodi-
          cally  reduce  the amount of used memory.  It is there-
          fore common to specify 10 MB even  if  only  2  MB  are
          going to be used.

     -L _l_a_n_g_u_a_g_e
          Specifies the language clisp uses to  communicate  with
          the user. This may be english, deutsch, francais, Other
          languages may  be  specified  through  the  environment
          variable LANG, provided the corresponding message cata-
          log is installed.

     -N _l_o_c_a_l_e_d_i_r
          Specifies the base directory of  locale  files.   clisp
          will     search     its     message     catalogs     in
          _l_o_c_a_l_e_d_i_r/_l_a_n_g_u_a_g_e/LC_MESSAGES/clisp.mo.

     -E_d_o_m_a_i_n _e_n_c_o_d_i_n_g
          Specifies the encoding used for a given  domain,  over-
          riding  the  default  which  depends on the environment
          variables LC_ALL, LC_CTYPE, LANG.  _d_o_m_a_i_n can be  file,
          affecting *default-file-encoding*, or pathname, affect-
          ing   *pathname-encoding*,   or   terminal,   affecting
          *terminal-encoding*,  or  foreign,  affecting *foreign-
          encoding*, or misc, affecting *misc-encoding*.

     -q, --quiet, --silent
          Quiet: clisp displays  no  banner  at  startup  and  no
          good-bye message when quitting.

     -w   Wait for keypress after program termination.

     -I   Be ILISP friendly. ILISP is an alternative Emacs inter-
          face  to  Common  Lisp systems. With this option, clisp
          interacts in a way that ILISP can deal with.  Currently
          the only effect of this is that unnecessary prompts are
          not suppressed.  Furthermore, the GNU readline  library
          treats Tab as a normal self-inserting character.

     -a   ANSI CL compliant: Comply with the ANSI  CL  specifica-
          tion even on those issues where ANSI CL is broken. This
          option is provided for maximum portability of Lisp pro-
          grams,  and  is not useful for actual everyday work. It
          sets the variable *_p_a_c_k_a_g_e*  to  COMMON-LISP-USER,  and
          the  symbol macro *_a_n_s_i* to t.  See impnotes.html, sec-
          tion "Maximum ANSI CL compliance", for details.



Sun Release 4.1   Last change: 15 January 2000                  2






CLISP(1)                 USER COMMANDS                   CLISP(1)



     -p _p_a_c_k_a_g_e_n_a_m_e
          At startup the value of the variable *_p_a_c_k_a_g_e* will  be
          set  to  the package named _p_a_c_k_a_g_e_n_a_m_e.  The default is
          the package which was active when the image was  saved,
          normally USER, or COMMON-LISP-USER if the option -a was
          specified.

     -C   Compile when load: At startup the value of the variable
          *_l_o_a_d-_c_o_m_p_i_l_i_n_g*  will  be set to t.  Code being _l_o_a_ded
          will then be compiled  on  the  fly.  This  results  in
          slower loading, but faster execution.

     -norc
          Normally clisp loads a user run control  (RC)  file  on
          startup  (this  happens  after  the  -C  option is pro-
          cessed).  The file loaded  is  ${HOME}/.clisprc.lsp  or
          ${HOME}/.clisprc.fas, whichever is newest. This option,
          -norc, prevents loading of the RC file.

     -i _i_n_i_t_f_i_l_e ...
          Specifies initialization files to be _l_o_a_ded at startup.
          These  should  be  lisp  files  (source  or  compiled).
          Several -i options can  be  given;  all  the  specified
          files will be loaded in order.

     -c _l_i_s_p_f_i_l_e ...
          Compiles the specified _l_i_s_p_f_i_l_es to  bytecode  (*.fas).
          The  compiled  files  can then be _l_o_a_ded instead of the
          sources to gain efficiency.

     -o _o_u_t_p_u_t_f_i_l_e
          Specifies the output file or directory for the compila-
          tion of the last specified _l_i_s_p_f_i_l_e.

     -l   A bytecode listing (*.lis) of the files being  compiled
          will  be produced.  Useful only for debugging purposes.
          See the documentation of _c_o_m_p_i_l_e-_f_i_l_e for details.

     -x _e_x_p_r_e_s_s_i_o_n_s
          Executes a series of arbitrary expressions instead of a
          read-eval-print  loop.   The  values of the expressions
          will be output to standard output.  Due to the argument
          processing  done  by the shell, the _e_x_p_r_e_s_s_i_o_n_s must be
          enclosed  in  double  quotes,  and  double  quotes  and
          backslashes must be preceded by backslashes.

     _l_i_s_p_f_i_l_e [_a_r_g_u_m_e_n_t ...]
          Loads and executes a _l_i_s_p_f_i_l_e.  There will be no  read-
          eval-print  loop.  Before _l_i_s_p_f_i_l_e is loaded, the vari-
          able *_a_r_g_s*  will  be  bound  to  a  list  of  strings,
          representing the _a_r_g_u_m_e_n_ts.  The first line of _l_i_s_p_f_i_l_e
          may start with #!, thus permitting clisp to be used  as



Sun Release 4.1   Last change: 15 January 2000                  3






CLISP(1)                 USER COMMANDS                   CLISP(1)



          a  script  interpreter.  If _l_i_s_p_f_i_l_e is -, the standard
          input is used instead of a file.  This option  must  be
          the last one. No RC file will be executed.

REFERENCE
     The language implemented mostly conforms to
            ANSI Common Lisp standard X3.226-1994
            http://www.x3.org/tc_home/j13sd4.htm
     available online as the
            Common Lisp HyperSpec
            http://www.harlequin.com/education/books/HyperSpec/
            ("CLHS" for short)
     which supersedes the earlier specifications
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 2nd edition 1990, 1032 pages.
            http://www.cs.cmu.edu/afs/cs.cmu.edu/project/ai-
      repository/ai/html/cltl/cltl2.html
            ("CLtL2" for short)
     and
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 1st edition 1984, 465 pages.
            ("CLtL1" for short)

USE
     help to get some on-line help.

     (apropos _n_a_m_e)
          lists the symbols relating to _n_a_m_e.

     (exit) or (quit) or (bye)
          to quit clisp.

     EOF (Ctrl-D)
          to leave the current read-eval-print loop.

     arrow keys
          for editing and viewing the input history.

     Tab key
          to complete the symbol's name you are just typing.

FILES
     _c_l_i_s_p
          startup script

     _l_i_s_p._r_u_n
          main executable

     _l_i_s_p_i_n_i_t._m_e_m
          initial memory image

     _c_o_n_f_i_g._l_s_p



Sun Release 4.1   Last change: 15 January 2000                  4






CLISP(1)                 USER COMMANDS                   CLISP(1)



          site-dependent configuration

     *._l_s_p
          lisp source

     *._f_a_s
          lisp code, compiled by clisp

     *._l_i_b
          lisp source library information, generated and used  by
          the clisp compiler

     *._c  C code, compiled from lisp source by clisp

ENVIRONMENT
     CLISP_LANGUAGE
          specifies the language clisp uses to  communicate  with
          the  user.  The value may be english, deutsch, francais
          and defaults to english.  The -L option can be used  to
          override this environment variable.

     LC_CTYPE
          specifies the locale which determines the character set
          in  use.   The  value  can  be  of the form _l_a_n_g_u_a_g_e or
          _l_a_n_g_u_a_g_e__c_o_u_n_t_r_y  or  _l_a_n_g_u_a_g_e__c_o_u_n_t_r_y._c_h_a_r_s_e_t,   where
          _l_a_n_g_u_a_g_e  is  a two-letter ISO 639 language code (lower
          case), and _c_o_u_n_t_r_y is a  two-letter  ISO  3166  country
          code  (upper  case).   _c_h_a_r_s_e_t is an optional character
          set specification, and  needs  normally  not  be  given
          because  the  character  set  can  be inferred from the
          language and country.

     LANG specifies the language clisp uses to  communicate  with
          the  user,  unless  it is already specified through the
          environment variable CLISP_LANGUAGE or the  -L  option.
          It  also specifies the locale determining the character
          set  in  use,  unless  already  specified  through  the
          environment  variable  LC_CTYPE.   The  value may begin
          with a two-letter ISO 639 language  code,  for  example
          en, de, fr.

     HOME and USER
          are used for determining  the  value  of  the  function
          _u_s_e_r-_h_o_m_e_d_i_r-_p_a_t_h_n_a_m_e.  (Unix implementation only.)

     SHELL (Unix implementation only)
          is used to find  the  interactive  command  interpreter
          called by (_s_h_e_l_l).

     TERM determines the screen size  recognized  by  the  pretty
          printer.   This  environment variable is also mandatory
          for the built-in screen editor.



Sun Release 4.1   Last change: 15 January 2000                  5






CLISP(1)                 USER COMMANDS                   CLISP(1)



SEE ALSO
     impnotes.html, _c_m_u_c_l(1), _x_e_m_a_c_s(1).

BUGS
     The function _i_n_s_p_e_c_t is not implemented.

     Not all extensions from CLtL2 are supported.

     No on-line documentation  beyond  _a_p_r_o_p_o_s  and  _d_e_s_c_r_i_b_e  is
     available.

PROJECTS
     Writing on-line documentation.

     Write _i_n_s_p_e_c_t.

     Enhance the compiler such that it  can  inline  local  func-
     tions.

     Specify a portable set of window and graphics operations.

AUTHORS
     Bruno Haible <haible@clisp.cons.org> and Michael Stoll.
































Sun Release 4.1   Last change: 15 January 2000                  6



