--
-- This file is part of TALER
-- Copyright (C) 2024 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

-- @file merchant-0006.sql
-- @brief add selected choice index to contract terms
-- @author Christian Blättler

-- Everything in one big transaction
BEGIN;

-- Check patch versioning is in place.
SELECT _v.register_patch('merchant-0006', NULL, NULL);

SET search_path TO merchant;

ALTER TABLE merchant_inventory
  ALTER COLUMN image SET DATA TYPE TEXT;

CREATE TABLE IF NOT EXISTS merchant_categories
  (category_serial BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY
  ,merchant_serial BIGINT NOT NULL
    REFERENCES merchant_instances (merchant_serial) ON DELETE CASCADE
  ,category_name TEXT NOT NULL UNIQUE
  ,category_name_i18n BYTEA NOT NULL
  );

COMMENT ON TABLE merchant_categories
  IS 'product categories (with translations) to group products from inventory (primarily for the point-of-sale app)';
COMMENT ON COLUMN merchant_categories.category_name
  IS 'name of the category';
COMMENT ON COLUMN merchant_categories.category_name_i18n
  IS 'JSON with translations of the category name';

CREATE TABLE merchant_product_categories
  (category_serial BIGINT NOT NULL
    REFERENCES merchant_categories (category_serial) ON DELETE CASCADE
  ,product_serial BIGINT NOT NULL
    REFERENCES merchant_inventory (product_serial) ON DELETE CASCADE);
CREATE INDEX merchant_categories_by_category
  ON merchant_product_categories (category_serial);
CREATE INDEX merchant_categories_by_product
  ON merchant_product_categories (product_serial);

COMMENT ON TABLE merchant_product_categories
  IS 'N:M map from products to categories (a product can be in any number of categories, including zero)';
COMMENT ON COLUMN merchant_product_categories.category_serial
  IS 'Reference to a category the product is part of';
COMMENT ON COLUMN merchant_product_categories.product_serial
  IS 'Reference to a product which is in the given category';


-- Complete transaction
COMMIT;
