.pragma library

/* dataset format
  - for each level we have:
    - bg: an optional background image
    - colorMask: the color of the shadowed target items
    - a list of pieces that each holds:
      - img: piece file name
      - flippable: is the piece flippable
      - flipping: target flipping state
      - x: target x position
      - y: target y position
      - width: item width
      - height: item height
      - rotation: item target rotation
      - moduloRotation: modulo rotation
      - initX: initial x position
      - initY: innitial y position
      - initRotation: initial rotation
      - initFlipping: initial flipping
*/

/* Warning: there are more levels in toBeAligned.js there are a lot of levels
   the needs to be manually aligned in editor mode and added to this file
*/

var dataset = [
            {
                'bg': '',
                'name': 'train1',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'train/loco.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.238,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.84868,
                        'initY': 0.14357,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.237,
                        'x': 0.16136986301369866,
                        'y': 0.5003377010125074
                    },
                    {
                        'img': 'train/coal.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.144,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.40198,
                        'initY': 0.10248,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.221,
                        'x': 0.38829064919595,
                        'y': 0.5456027397260274
                    },
                    {
                        'img': 'train/wood.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.141,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.58434,
                        'initY': 0.23488,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.235,
                        'x': 0.6111453245979751,
                        'y': 0.5469714115544966
                    },
                    {
                        'img': 'train/passenger.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.213,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.15311,
                        'initY': 0.15368,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.238,
                        'x': 0.8362608695652176,
                        'y': 0.5122281119714115
                    },
                ]
            },
            {
                'bg': '',
                'name': 'train2',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'train/loco.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.238,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.84868,
                        'initY': 0.14357,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.237,
                        'x': 0.16136986301369866,
                        'y': 0.5003377010125074
                    },
                    {
                        'img': 'train/coal.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.144,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.40198,
                        'initY': 0.10248,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.221,
                        'x': 0.6116378796902918,
                        'y': 0.5491762954139369
                    },
                    {
                        'img': 'train/wood.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.141,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.58434,
                        'initY': 0.23488,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.235,
                        'x': 0.8368749255509234,
                        'y': 0.5493537820131029
                    },
                    {
                        'img': 'train/passenger.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.213,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.15311,
                        'initY': 0.15368,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.238,
                        'x': 0.3913531864204886,
                        'y': 0.5140148898153662
                    },
                ]
            },
            {
                'bg': '',
                'name': 'train3',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'train/loco.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.238,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.84868,
                        'initY': 0.14357,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.237,
                        'x': 0.19114949374627757,
                        'y': 0.22279154258487197
                    },
                    {
                        'img': 'train/coal.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.144,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.40198,
                        'initY': 0.10248,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.221,
                        'x': 0.6336748064324003,
                        'y': 0.7272584871947588
                    },
                    {
                        'img': 'train/wood.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.141,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.58434,
                        'initY': 0.23488,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.235,
                        'x': 0.4801149493746279,
                        'y': 0.5791334127456819
                    },
                    {
                        'img': 'train/passenger.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.213,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.84311,
                        'initY': 0.42368,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.238,
                        'x': 0.34251459201905915,
                        'y': 0.3925139964264443
                    },
                ]
            },
            {
                'bg': '',
                'name': 'train4',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'train/loco.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.238,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.84868,
                        'initY': 0.14357,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.237,
                        'x': 0.20365693865396073,
                        'y': 0.4241018463371054
                    },
                    {
                        'img': 'train/coal.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.144,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.40198,
                        'initY': 0.10248,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.221,
                        'x': 0.7575580702799286,
                        'y': 0.6540005955926147
                    },
                    {
                        'img': 'train/wood.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.141,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.58434,
                        'initY': 0.23488,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.235,
                        'x': 0.6689178082191782,
                        'y': 0.4540589636688504
                    },
                    {
                        'img': 'train/passenger.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.213,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.84311,
                        'initY': 0.42368,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.238,
                        'x': 0.4550815961882075,
                        'y': 0.3317635497319833
                    },
                ]
            },
            {
                'bg': '',
                'name': 'train5',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'train/loco.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.238,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.84868,
                        'initY': 0.14357,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.237,
                        'x': 0.8474925550923169,
                        'y': 0.48902144133412745
                    },
                    {
                        'img': 'train/coal.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.144,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.40198,
                        'initY': 0.10248,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.221,
                        'x': 0.619976176295414,
                        'y': 0.5354776652769506
                    },
                    {
                        'img': 'train/wood.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.141,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.58434,
                        'initY': 0.2348,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.235,
                        'x': 0.39375402025014905,
                        'y': 0.5374419297200713
                    },
                    {
                        'img': 'train/passenger.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.213,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.15311,
                        'initY': 0.15368,
                        'moduloRotation': 0,
                        'rotation': 0,
                        'width': 0.238,
                        'x': 0.16741036331149514,
                        'y': 0.5015074449076831
                    },
                ]
            },
            {
                'name': 'Level 1',
                'bg': 'truck/traffic_bg.svg',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'truck/engine.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.860,
                        'y': 0.573,
                        'width': 0.233,
                        'height': 0.109,
                        'rotation': 0,
                        'moduloRotation': 0,
                        'initX': 0.866,
                        'initY': 0.754,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'truck/cabin.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.847,
                        'y': 0.435,
                        'width': 0.207,
                        'height': 0.178,
                        'rotation': 0,
                        'moduloRotation': 0,
                        'initX': 0.153,
                        'initY': 0.789,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'truck/container.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.358,
                        'y': 0.489,
                        'width': 0.676,
                        'height': 0.271,
                        'rotation': 0,
                        'moduloRotation': 0,
                        'initX': 0.338,
                        'initY': 0.135,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'truck/back_road.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.181,
                        'y': 0.633,
                        'width': 0.198,
                        'height': 0.092,
                        'rotation': 0,
                        'moduloRotation': 0,
                        'initX': 0.799,
                        'initY': 0.146,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'truck/front_road.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.766,
                        'y': 0.617,
                        'width': 0.403,
                        'height': 0.121,
                        'rotation': 0,
                        'moduloRotation': 0,
                        'initX': 0.501,
                        'initY': 0.760,
                        'initRotation': 0,
                        'initFlipping': 0
                    }
                ]
            },
            {
                'name': 'Level 2',
                'bg': 'truck/traffic_bg.svg',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'truck/engine.svg',
                        'flippable': 1,
                        'flipping': 0,
                        'x': 0.860,
                        'y': 0.573,
                        'width': 0.233,
                        'height': 0.109,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.866,
                        'initY': 0.754,
                        'initRotation': 0,
                        'initFlipping': 1
                    },
                    {
                        'img': 'truck/cabin.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.847,
                        'y': 0.435,
                        'width': 0.207,
                        'height': 0.178,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.153,
                        'initY': 0.789,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'truck/container.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.358,
                        'y': 0.489,
                        'width': 0.676,
                        'height': 0.271,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.338,
                        'initY': 0.135,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'truck/back_road.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.181,
                        'y': 0.633,
                        'width': 0.198,
                        'height': 0.092,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.799,
                        'initY': 0.146,
                        'initRotation': 270,
                        'initFlipping': 0
                    },
                    {
                        'img': 'truck/front_road.svg',
                        'flippable': 1,
                        'flipping': 0,
                        'x': 0.766,
                        'y': 0.617,
                        'width': 0.403,
                        'height': 0.121,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.501,
                        'initY': 0.760,
                        'initRotation': 90,
                        'initFlipping': 1
                    }
                ]
            },
            {
                'name': 'Level 3',
                'bg': 'truck/traffic_bg.svg',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'truck/engine.svg',
                        'flippable': 1,
                        'flipping': 0,
                        'x': 0.860,
                        'y': 0.573,
                        'width': 0.233,
                        'height': 0.109,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.866,
                        'initY': 0.754,
                        'initRotation': 0,
                        'initFlipping': 1
                    },
                    {
                        'img': 'truck/cabin.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.847,
                        'y': 0.435,
                        'width': 0.207,
                        'height': 0.178,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.153,
                        'initY': 0.789,
                        'initRotation': 45,
                        'initFlipping': 0
                    },
                    {
                        'img': 'truck/container.svg',
                        'flippable': 1,
                        'flipping': 0,
                        'x': 0.358,
                        'y': 0.489,
                        'width': 0.676,
                        'height': 0.271,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.338,
                        'initY': 0.135,
                        'initRotation': 0,
                        'initFlipping': 1
                    },
                    {
                        'img': 'truck/back_road.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.181,
                        'y': 0.633,
                        'width': 0.198,
                        'height': 0.092,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.799,
                        'initY': 0.146,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'truck/front_road.svg',
                        'flippable': 1,
                        'flipping': 0,
                        'x': 0.766,
                        'y': 0.617,
                        'width': 0.403,
                        'height': 0.121,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.501,
                        'initY': 0.760,
                        'initRotation': 270,
                        'initFlipping': 0
                    }
                ]
            },
            {
                'name': 'Level 4',
                'bg': 'car1/car.svg',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'car1/windshield.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.492,
                        'y': 0.309,
                        'width': 0.563,
                        'height': 0.227,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.301,
                        'initY': 0.133,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'car1/tire_right.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.226,
                        'y': 0.720,
                        'width': 0.126,
                        'height': 0.147,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.863,
                        'initY': 0.123,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'car1/tire_right.svg',
                        'flippable': 0,
                        'flipping': 1,
                        'x': 0.782,
                        'y': 0.720,
                        'width': 0.126,
                        'height': 0.147,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.663,
                        'initY': 0.123,
                        'initRotation': 0,
                        'initFlipping': 1
                    },
                    {
                        'img': 'car1/bumper.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.502,
                        'y': 0.656,
                        'width': 0.710,
                        'height': 0.184,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.405,
                        'initY': 0.892,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'car1/grille.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.505,
                        'y': 0.600,
                        'width': 0.365,
                        'height': 0.051,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.382,
                        'initY': 0.825,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'car1/headlights.svg',
                        'flippable': 0,
                        'flipping': 0,
                        'x': 0.782,
                        'y': 0.506,
                        'width': 0.134,
                        'height': 0.125,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.90,
                        'initY': 0.85,
                        'initRotation': 0,
                        'initFlipping': 0
                    },
                    {
                        'img': 'car1/headlights.svg',
                        'flippable': 0,
                        'flipping': 1,
                        'x': 0.222,
                        'y': 0.506,
                        'width': 0.134,
                        'height': 0.125,
                        'rotation': 0,
                        'moduloRotation': 360,
                        'initX': 0.90,
                        'initY': 0.30,
                        'initRotation': 0,
                        'initFlipping': 1
                    }
                ]
            },
            {
                'bg': '',
                'name': 'Level 5 Real Tangram',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.22,
                        'initY': 0.12,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.501,
                        'y': 0.349
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.216,
                        'initY': 0.8,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.429,
                        'x': 0.715,
                        'y': 0.349
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.45,
                        'initY': 0.11,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.304,
                        'x': 0.6649999999999999,
                        'y': 0.6066176295413936
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.7,
                        'initY': 0.11,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.5145955926146515,
                        'y': 0.5308088147706969
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 1,
                        'initRotation': -90,
                        'initX': 0.94,
                        'initY': 0.17,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.7515955926146516,
                        'y': 0.5094044073853484
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.6,
                        'initY': 0.85,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.18189398451459207,
                        'y': 0.40211435378201305
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.8,
                        'initY': 0.85,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.4021441334127456,
                        'y': 0.49324002382370435
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 0',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.429,
                        'x': 0.42724419297200705,
                        'y': 0.32462656343061347
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.429,
                        'x': 0.15611554496724236,
                        'y': 0.7651739130434781
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.304,
                        'x': 0.7600893388921978,
                        'y': 0.689886837403216
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.45834961286480047,
                        'y': 0.614650982727814
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.2307069684335914,
                        'y': 0.4632888624181061
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.3449309112567005,
                        'y': 0.5766063132817155
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.5708940134670106,
                        'y': 0.6522900536033351
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 2',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.429,
                        'x': 0.48799463966646806,
                        'y': 0.4943704586063133
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.48845622394282306,
                        'y': 0.8604687313877308
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.48849910661107804,
                        'y': 0.6767837998808813
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.4976587254318046,
                        'y': 0.2817147111375819
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.6386879094699226,
                        'y': 0.6771066110780227
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.215,
                        'x': 0.4437992852888625,
                        'y': 0.1757724836212031
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.215,
                        'x': 0.5505265038713519,
                        'y': 0.17522036926742104
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 4',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.32317555083808397,
                        'y': 0.2654765399472475
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.4737469885135711,
                        'y': 0.2660721325618991
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.39746081230324165,
                        'y': 0.8445284176805921
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.39816354479707317,
                        'y': 0.4480313383816898
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.5480606591508552,
                        'y': 0.8445425508380838
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.215,
                        'x': 0.3442415387560623,
                        'y': 0.6619736192461498
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.215,
                        'x': 0.45089422275163776,
                        'y': 0.6607824340168467
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 5',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.429,
                        'x': 0.5177031283076662,
                        'y': 0.7001436053773504
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.429,
                        'x': 0.3043979031736578,
                        'y': 0.7001436053773504
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.41036384378456564,
                        'y': 0.4105894716242662
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.41105058716923326,
                        'y': 0.22803467318982387
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.5615592832468307,
                        'y': 0.41060360478175784
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.51623502118608,
                        'y': 0.8613553511443885
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.30527056053773494,
                        'y': 0.8613553511443885
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 6',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.4596351325618991,
                        'y': 0.8658572572960096
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.6113977554666894,
                        'y': 0.8658572572960096
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.5352187191355399,
                        'y': 0.5652531562154344
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.536409904364843,
                        'y': 0.3820744988513571
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 90,
                        'width': 0.322,
                        'x': 0.5898954388666723,
                        'y': 0.2222133451033778
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.215,
                        'x': 0.4827649630732577,
                        'y': 0.2745076943759041
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.215,
                        'x': 0.48308363379562685,
                        'y': 0.16872766774440565
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 7',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.429,
                        'x': 0.7163858008168126,
                        'y': 0.6799288850506253
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.429,
                        'x': 0.5030805756828045,
                        'y': 0.6799288850506253
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.5340062384922999,
                        'y': 0.23920757815025945
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.6101995508380837,
                        'y': 0.39098447706968437
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.6857972705692164,
                        'y': 0.2391934449927678
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.5021664552029269,
                        'y': 0.8393538529737087
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.716108736067387,
                        'y': 0.8405450382030119
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 8',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.5023814654981706,
                        'y': 0.8294092119458861
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.429,
                        'x': 0.5044453080915509,
                        'y': 0.24822376218837738
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.304,
                        'x': 0.5580901065259934,
                        'y': 0.4091168372330469
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.5038929788139199,
                        'y': 0.6465217524887263
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 90,
                        'width': 0.322,
                        'x': 0.3443070895941462,
                        'y': 0.1959292700587084
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.215,
                        'x': 0.5053594285714285,
                        'y': 0.5166836417084999
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.215,
                        'x': 0.34410621968859023,
                        'y': 0.3554304328256615
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 9',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.429,
                        'x': 0.38185774993618643,
                        'y': 0.49611427193057084
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.8324945144218497,
                        'y': 0.49611427193057084
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.6068782644431209,
                        'y': 0.497305457159874
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.8264392276014633,
                        'y': 0.34552855824044926
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.15451412151791039,
                        'y': 0.49675131796137156
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.721980888624181,
                        'y': 0.2324369129583935
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.215,
                        'x': 0.9487881809750702,
                        'y': 0.2324369129583935
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 10',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.429,
                        'x': 0.7177664225304178,
                        'y': 0.27648363456138847
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.429,
                        'x': 0.2771954897472985,
                        'y': 0.7580107131796135
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.6425140732578916,
                        'y': 0.5773520909555007
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.5179394382710797,
                        'y': 0.5193719275078705
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 90,
                        'width': 0.322,
                        'x': 0.4650494963839018,
                        'y': 0.35951077375989116
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.6050201477069685,
                        'y': 0.6904580122521908
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.4490578874329959,
                        'y': 0.1929193179613716
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 11',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.343738391049094,
                        'y': 0.5413064867693356
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.429,
                        'x': 0.47293088198757754,
                        'y': 0.7540161192886923
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.7088762542329619,
                        'y': 0.5729427676337956
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.34395914592019045,
                        'y': 0.3584161114609036
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 90,
                        'width': 0.322,
                        'x': 0.6111663492725262,
                        'y': 0.48809787415978895
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.215,
                        'x': 0.7179782972007147,
                        'y': 0.30080569922572953
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.215,
                        'x': 0.8913969315919342,
                        'y': 0.701881033948779
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 12',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 157.5,
                        'width': 0.429,
                        'x': 0.48378610108057524,
                        'y': 0.5281706585552625
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 337.5,
                        'width': 0.429,
                        'x': 0.6813192857142856,
                        'y': 0.44696344975750885
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 337.5,
                        'width': 0.304,
                        'x': 0.412606268186846,
                        'y': 0.1967451961201396
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 67.5,
                        'width': 0.152,
                        'x': 0.3444424485663234,
                        'y': 0.38844723423806676
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.7404922390028078,
                        'y': 0.2614944703479963
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 22.5,
                        'width': 0.215,
                        'x': 0.7627900962307498,
                        'y': 0.569599191270314
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 337.5,
                        'width': 0.215,
                        'x': 0.40648443886667235,
                        'y': 0.6178664400578577
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 13',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.429,
                        'x': 0.2638586309027482,
                        'y': 0.6620276109078531
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.7175584431209051,
                        'y': 0.6625947943503786
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.304,
                        'x': 0.5402684068748407,
                        'y': 0.5333664093422956
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.5934897143707991,
                        'y': 0.2656298300859355
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.8691330121671061,
                        'y': 0.7381158602909895
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.4908645017442356,
                        'y': 0.6394517670382031
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.18407762971156308,
                        'y': 0.5332945214838765
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 14',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.4457249624776654,
                        'y': 0.3811788395303327
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.7475202487875435,
                        'y': 0.6829741258402109
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.304,
                        'x': 0.46828760954649884,
                        'y': 0.6164643159193397
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.596934535097422,
                        'y': 0.5317645532204544
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 90,
                        'width': 0.322,
                        'x': 0.7260177893303837,
                        'y': 0.4038724842167957
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.5594263335318641,
                        'y': 0.64485619850251
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.215,
                        'x': 0.7789078740747042,
                        'y': 0.2973376010380328
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 15',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.3699737826086957,
                        'y': 0.3832792040330129
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.671769068918574,
                        'y': 0.6838833051135882
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.304,
                        'x': 0.2832376501318812,
                        'y': 0.5544194613290223
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.5199639036841659,
                        'y': 0.532106549051306
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.5955616234152982,
                        'y': 0.38150670220369254
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.3316203964945121,
                        'y': 0.6455583281715307
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.215,
                        'x': 0.19150319067472138,
                        'y': 0.5072279001956946
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 16',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.2883534285714286,
                        'y': 0.18657742857142856
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.7144513553135369,
                        'y': 0.18657742857142856
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.304,
                        'x': 0.6615862948183441,
                        'y': 0.5612425913383816
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.5011571107802262,
                        'y': 0.4000471022717604
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.34090533293627173,
                        'y': 0.3467173444227006
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.215,
                        'x': 0.5547518238747553,
                        'y': 0.50742457925636
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.5018052899685187,
                        'y': 0.5605088904109589
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 17',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.36401785646217993,
                        'y': 0.4041249455458182
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.6664087353867099,
                        'y': 0.7059202318556965
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.304,
                        'x': 0.5998989254658383,
                        'y': 0.4254964073853485
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.5151991627669532,
                        'y': 0.5547390684080661
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.3867115011486428,
                        'y': 0.6838223226410278
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.6282908080490088,
                        'y': 0.5166352742278567
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.22625468335744067,
                        'y': 0.6839815865736408
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 18',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.3689950665362035,
                        'y': 0.5227800890836382
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.429,
                        'x': 0.5067583110695142,
                        'y': 0.7050162167957115
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.304,
                        'x': 0.44099048966221394,
                        'y': 0.22960923985365442
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.4943167602314302,
                        'y': 0.3910979075129754
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.6541779139794095,
                        'y': 0.33642118778184305
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.25532196179698813,
                        'y': 0.3340623148983238
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.215,
                        'x': 0.4971569993193226,
                        'y': 0.8557539934484812
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 19',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.429,
                        'x': 0.5092028486343912,
                        'y': 0.5608064499276779
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.32756231353696913,
                        'y': 0.5485370310559007
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.304,
                        'x': 0.4552808425933804,
                        'y': 0.292942163022207
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.5628892530417767,
                        'y': 0.7206607294307836
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.6694137118182593,
                        'y': 0.5074142660597296
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.6692648722879264,
                        'y': 0.7737099352505743
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.6159281773164298,
                        'y': 0.4006023181315411
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 20',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.429,
                        'x': 0.7089075290564113,
                        'y': 0.35880960946141416
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.494965105334808,
                        'y': 0.35885121543435716
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.304,
                        'x': 0.6602167415128053,
                        'y': 0.6172947886497064
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.5090070260359059,
                        'y': 0.5411014763039222
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.7450616349868119,
                        'y': 0.518989433931762
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.3953197881391984,
                        'y': 0.5035934175955075
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.17413425670041696,
                        'y': 0.4116645374797924
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 21',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.2931057209223177,
                        'y': 0.5933563100484984
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.7197992402790777,
                        'y': 0.5933563100484984
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.5058568165574747,
                        'y': 0.7756208469326983
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.5064524091721263,
                        'y': 0.3790953584616694
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 90,
                        'width': 0.322,
                        'x': 0.5599380865310986,
                        'y': 0.5383609195949971
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.215,
                        'x': 0.4534032033523357,
                        'y': 0.4854709777078194
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.215,
                        'x': 0.45312613860290984,
                        'y': 0.5918465969539692
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 22',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.8013717475538161,
                        'y': 0.4862541065259934
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.13619710958904108,
                        'y': 0.48684969914064496
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.46521087288351914,
                        'y': 0.7456118002212202
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.4687844285714286,
                        'y': 0.5624331428571429
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.30773208959414605,
                        'y': 0.6159188202161151
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.574564455202927,
                        'y': 0.6160780841487281
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.215,
                        'x': 0.6815356670637285,
                        'y': 0.6157595562835021
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 23',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.29609742074363987,
                        'y': 0.49720990632179013
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.7503075980600699,
                        'y': 0.49720990632179013
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.507419305113588,
                        'y': 0.6484053457840553
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.5235003057091806,
                        'y': 0.4661774651720127
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.9014889043648434,
                        'y': 0.4215980534331661
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.18301990861907608,
                        'y': 0.4590919789840891
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.10800350548796049,
                        'y': 0.38410412788224285
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 24',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.429,
                        'x': 0.4735713910490937,
                        'y': 0.5605857965625799
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.688705,
                        'y': 0.3472805714285715
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.304,
                        'x': 0.3126783160044244,
                        'y': 0.40088390674721347
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.4735713910490937,
                        'y': 0.3481532287926487
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 90,
                        'width': 0.322,
                        'x': 0.2055478402110099,
                        'y': 0.40163890615162084
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.215,
                        'x': 0.7938894340168466,
                        'y': 0.5072595259933633
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.215,
                        'x': 0.0993316277546158,
                        'y': 0.4545288480387986
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 25',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.31210792495533063,
                        'y': 0.4947798753509741
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.7429705926146515,
                        'y': 0.4953754679656257
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.5320062748234494,
                        'y': 0.6764486767633795
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.5278371265208884,
                        'y': 0.4962479824725602
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.15105558597804822,
                        'y': 0.44216685535607925
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.215,
                        'x': 0.849941804475453,
                        'y': 0.44200759142346635
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.956913016336255,
                        'y': 0.44232611928869225
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 26',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.429,
                        'x': 0.870166751808049,
                        'y': 0.5098080346294563
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.5507629721773163,
                        'y': 0.6165021817408322
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.304,
                        'x': 0.2843669352505742,
                        'y': 0.454972050965711
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.3374161410703649,
                        'y': 0.6161836538756061
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 90,
                        'width': 0.322,
                        'x': 0.7106241259252957,
                        'y': 0.5626981193737769
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.215,
                        'x': 0.39106108236195014,
                        'y': 0.5098080346294566
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.215,
                        'x': 0.23104066468135803,
                        'y': 0.5619432628265124
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 27',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.429,
                        'x': 0.8417641737428743,
                        'y': 0.4076161376669786
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.429,
                        'x': 0.2041477997107121,
                        'y': 0.4016602115204628
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.304,
                        'x': 0.575686807538501,
                        'y': 0.45796444516293716
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.4165805103377862,
                        'y': 0.4040425819790691
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 90,
                        'width': 0.322,
                        'x': 0.6828172833319153,
                        'y': 0.4599106297966477
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.215,
                        'x': 0.5229559867267933,
                        'y': 0.5649356570237386
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.215,
                        'x': 0.3635311616608525,
                        'y': 0.5092270159959159
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 28',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.6627741289032587,
                        'y': 0.6464996858674382
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.429,
                        'x': 0.5127414654981706,
                        'y': 0.49527583723304697
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.304,
                        'x': 0.3615460260359058,
                        'y': 0.42028784327405777
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.3615603020505404,
                        'y': 0.6470810024674549
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.4371580217816727,
                        'y': 0.79827644192972
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.47524753994724755,
                        'y': 0.30718206483451027
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.32405210048498245,
                        'y': 0.5339893571853995
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 29',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.8606828474432059,
                        'y': 0.4573111362205395
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.7100545914234663,
                        'y': 0.607939392240279
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.7856664443120907,
                        'y': 0.7585392390878924
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.2576735914234664,
                        'y': 0.3073210151450693
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.5588732851186932,
                        'y': 0.5335185817238152
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.445186047221986,
                        'y': 0.4204128032842679
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.37076537956266487,
                        'y': 0.3454248093252786
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 30',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.4035540489236792,
                        'y': 0.5776136265634306
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.5547210792138176,
                        'y': 0.5770464431209054
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.6303330749595848,
                        'y': 0.4258510036586403
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.40294432315153583,
                        'y': 0.4264323202586574
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.4785420428826684,
                        'y': 0.27523688079639236
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.215,
                        'x': 0.28925699954054296,
                        'y': 0.4639405218242151
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.5172271536628946,
                        'y': 0.765140215519442
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 31',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.37139204773249396,
                        'y': 0.3805859649451203
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.37139204773249396,
                        'y': 0.5317529952352591
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.5981710737683996,
                        'y': 0.5323485878499107
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.522573354037267,
                        'y': 0.3805716889304859
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.6737687934995319,
                        'y': 0.4561694086616183
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.48506515247170934,
                        'y': 0.494259069684336
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.7118724448225985,
                        'y': 0.3430636302220709
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 32',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.24633358776482608,
                        'y': 0.2252940417765677
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.429,
                        'x': 0.460275868629286,
                        'y': 0.22584802841827617
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.304,
                        'x': 0.6199777584446524,
                        'y': 0.2794929697098613
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.3846781488981537,
                        'y': 0.40754430264613295
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.38408255628350213,
                        'y': 0.6343374618395303
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.4215907578490598,
                        'y': 0.5206359479281886
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.3459789049604357,
                        'y': 0.7480389757508721
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 33',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.707001553816047,
                        'y': 0.492399627244108
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.429,
                        'x': 0.2235373232366204,
                        'y': 0.4048757792053093
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.48019411860801503,
                        'y': 0.3417997803964945
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.4045963988768825,
                        'y': 0.4929809438441249
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.5557918383391476,
                        'y': 0.41797881672764403
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.3676839327831192,
                        'y': 0.38048489117672085
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.6694792190929976,
                        'y': 0.30427744567344506
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 34',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.429,
                        'x': 0.504379130604952,
                        'y': 0.4494455162937122
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.429,
                        'x': 0.504060602739726,
                        'y': 0.663706467880541
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.5185716287756318,
                        'y': 0.11598558280439036
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.5237238987492555,
                        'y': 0.26719525542414696
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 90,
                        'width': 0.322,
                        'x': 0.5578646651067812,
                        'y': 0.822972029013869
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.215,
                        'x': 0.5580239290393942,
                        'y': 0.5567352560197396
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.215,
                        'x': 0.4510528600357355,
                        'y': 0.876457706372841
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 35',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.429,
                        'x': 0.4689311082276865,
                        'y': 0.550903053943674
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.429,
                        'x': 0.4701638994299329,
                        'y': 0.7642498850506254
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.304,
                        'x': 0.5225760495192718,
                        'y': 0.3912011641283076
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.4841483509742195,
                        'y': 0.11076320650046798
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.4085506312430869,
                        'y': 0.26195864596273294
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.5984313243427211,
                        'y': 0.2994668475282907
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.215,
                        'x': 0.5228477377690802,
                        'y': 0.2994668475282907
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 36',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.5801178967072239,
                        'y': 0.2575823995575598
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.5801178967072239,
                        'y': 0.5587820932527866
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.5062928216625543,
                        'y': 0.8617402984769846
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.5806993561643836,
                        'y': 0.7099633995575599
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.5045060438185995,
                        'y': 0.4087637058623329
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.215,
                        'x': 0.46760756802518494,
                        'y': 0.7474716011231176
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.6188030074874501,
                        'y': 0.8236506374542669
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 38',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.429,
                        'x': 0.4530528890496044,
                        'y': 0.7751819788990045
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.429,
                        'x': 0.4536900876371992,
                        'y': 0.5618352906491959
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.409509975070195,
                        'y': 0.2746916508125585
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.4638991675316941,
                        'y': 0.1240776708074534
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.55974703616098,
                        'y': 0.2748476869735387
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.4472368503360845,
                        'y': 0.3877691629371225
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.2958085183017103,
                        'y': 0.3121857192206245
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 39',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.429,
                        'x': 0.3989706585552626,
                        'y': 0.6143359515868289
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.429,
                        'x': 0.39892905258231937,
                        'y': 0.8282783753084318
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.304,
                        'x': 0.34651690249298045,
                        'y': 0.4546340617714626
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.40674169182336434,
                        'y': 0.21961151697438946
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.4908511851442184,
                        'y': 0.3475035859780482
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.33158562401089087,
                        'y': 0.3476628499106612
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.215,
                        'x': 0.41025328988343385,
                        'y': 0.0918787119033438
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 40',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.429,
                        'x': 0.20306670824470355,
                        'y': 0.35521182821407304
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.8072812826512382,
                        'y': 0.35461623559942146
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.5810695829150003,
                        'y': 0.35521182821407304
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.5036850853399131,
                        'y': 0.5059467879690291
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.4292785508380837,
                        'y': 0.35463036875691323
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.215,
                        'x': 0.23999345035310138,
                        'y': 0.5439296023993875
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.7697589479281888,
                        'y': 0.5433340097847359
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 41',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.31727268339998316,
                        'y': 0.5903339898749256
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.6196352960095293,
                        'y': 0.5915251751042289
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.304,
                        'x': 0.6196352960095293,
                        'y': 0.36471788275333955
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.4678583970901046,
                        'y': 0.28971575563685875
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.3166629576278398,
                        'y': 0.36471788275333955
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.2785591634476306,
                        'y': 0.2516119614566492
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.5815456349868118,
                        'y': 0.2516119614566492
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 42',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.3995143365098274,
                        'y': 0.4468099189994045
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.6989556615332255,
                        'y': 0.44439913936867176
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.6239394012592531,
                        'y': 0.2937992925210585
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.24892876567684843,
                        'y': 0.5967998972177316
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.24833317306219685,
                        'y': 0.3711979232536373
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.215,
                        'x': 0.2858412317706117,
                        'y': 0.48508607686453575
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.6638156972687824,
                        'y': 0.636094876627244
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 43',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.6415304739215519,
                        'y': 0.30553992197736757
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.48971117552965193,
                        'y': 0.4555725853824556
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.304,
                        'x': 0.3379201434527355,
                        'y': 0.38115191772313445
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.6415163407640602,
                        'y': 0.6073494843018805
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.3379342766102273,
                        'y': 0.5323473571853995
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.2998304824300178,
                        'y': 0.2674504038117928
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.3004260750446694,
                        'y': 0.6454531356249467
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 44',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.820187705862333,
                        'y': 0.5773473210244193
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.21543435718539952,
                        'y': 0.5773473210244193
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.4422133832213051,
                        'y': 0.4279102502339828
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.5172155103377861,
                        'y': 0.5785243730962307
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.5928132300689186,
                        'y': 0.42732893363396585
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.215,
                        'x': 0.32910746192461493,
                        'y': 0.3892251394537565
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.7065146011231174,
                        'y': 0.3892251394537565
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 45',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.2840290624521398,
                        'y': 0.29693865753424653
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.429,
                        'x': 0.5852003469752403,
                        'y': 0.29693865753424653
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.304,
                        'x': 0.5852003469752403,
                        'y': 0.5231503572704841
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.43461477614226157,
                        'y': 0.2969527906917383
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.28461052190929986,
                        'y': 0.5219591720411809
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.5477064214243171,
                        'y': 0.6368518711818261
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.24710232034374197,
                        'y': 0.6350650933378713
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 46',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.429,
                        'x': 0.19889755994214248,
                        'y': 0.3403220128477836
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.6537034727303668,
                        'y': 0.34091760546243516
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.4257049951501742,
                        'y': 0.339726420233132
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.19891183595677708,
                        'y': 0.6427270249298053
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.653689339572875,
                        'y': 0.5665337125840212
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.215,
                        'x': 0.23582430205054034,
                        'y': 0.5296353796477495
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.6155855453926657,
                        'y': 0.6796396338807114
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 47',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.429,
                        'x': 0.3198028607164129,
                        'y': 0.5452058722879265
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.4709318037947758,
                        'y': 0.21236989772823966
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 270,
                        'width': 0.304,
                        'x': 0.6227893322555944,
                        'y': 0.6202221325618993
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.4710125761933123,
                        'y': 0.39402456598315316
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.5466102959244447,
                        'y': 0.5446244128307667
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.215,
                        'x': 0.3579207880541139,
                        'y': 0.7333280538585892
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.5852954067046711,
                        'y': 0.7339236464732408
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 48',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 315,
                        'width': 0.429,
                        'x': 0.1935372264102783,
                        'y': 0.4487198687143708
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.429,
                        'x': 0.7959650229728582,
                        'y': 0.4493154613290224
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.5703489158512719,
                        'y': 0.4493154613290224
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.495346788734791,
                        'y': 0.2975385624095975
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.41974906900365844,
                        'y': 0.4487340018718626
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.215,
                        'x': 0.2316551537479793,
                        'y': 0.6374376428996851
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.7590382808644603,
                        'y': 0.6386288281289882
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 49',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.429,
                        'x': 0.7386076616183104,
                        'y': 0.44329757050965707
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.429,
                        'x': 0.3125097348762019,
                        'y': 0.44329757050965707
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.5258564231260104,
                        'y': 0.41341968688845404
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.2375076077597209,
                        'y': 0.6261850585382456
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.8136097887347911,
                        'y': 0.54939615357781
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.20059499880881482,
                        'y': 0.5136890058708415
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.215,
                        'x': 0.8511179903003486,
                        'y': 0.6636932601038034
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 50',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.15798852667404065,
                        'y': 0.5899251818259166
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.7621464255934653,
                        'y': 0.5899251818259166
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.304,
                        'x': 0.3085883735216539,
                        'y': 0.5166956993958991
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.6103695266740408,
                        'y': 0.4393112018208117
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.3829807748659918,
                        'y': 0.43990679443546327
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.49668228877733356,
                        'y': 0.4023985928699055
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.64847332085425,
                        'y': 0.5529984397175187
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 51',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.168208660427125,
                        'y': 0.4500991049093849
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.7724232348336595,
                        'y': 0.4500991049093849
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.304,
                        'x': 0.546211392240279,
                        'y': 0.45069469752403646
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.16822279358461667,
                        'y': 0.6012802683570151
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': true,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.3950159527780142,
                        'y': 0.45068042150940196
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.8099171603845827,
                        'y': 0.5637722096486005
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.73490090011061,
                        'y': 0.6399796551518759
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 52',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.23011831055900622,
                        'y': 0.5500260498596102
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.8719452960095293,
                        'y': 0.5524084203182166
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.304,
                        'x': 0.7119248783289375,
                        'y': 0.39179226716583
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.3364937869480133,
                        'y': 0.4445230879775377
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.4975462687824384,
                        'y': 0.391633003233217
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.215,
                        'x': 0.5504362106696163,
                        'y': 0.49904054377605733
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.215,
                        'x': 0.818896090189739,
                        'y': 0.44571427320684087
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 53',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.12875665200374367,
                        'y': 0.5200925202926914
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.429,
                        'x': 0.7705837803114098,
                        'y': 0.520688112907343
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.44967014472900535,
                        'y': 0.3820107478941547
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 45,
                        'width': 0.152,
                        'x': 0.23572786386454517,
                        'y': 0.4133983731813154
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 0,
                        'width': 0.322,
                        'x': 0.6107226265634307,
                        'y': 0.3599128386794861
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.215,
                        'x': 0.3421034831106951,
                        'y': 0.3597535747468732
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 180,
                        'width': 0.215,
                        'x': 0.6636125684506083,
                        'y': 0.4667246437505319
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 54',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.22622124155534765,
                        'y': 0.6502168881987578
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.8327613680762359,
                        'y': 0.6520036660427124
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 90,
                        'width': 0.304,
                        'x': 0.3780122736322641,
                        'y': 0.4263874160639836
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.5297890296945461,
                        'y': 0.35019410371819965
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 45,
                        'width': 0.322,
                        'x': 0.680984469156811,
                        'y': 0.4257918234493321
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.4161017917978387,
                        'y': 0.3126860450097848
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.7190882633370205,
                        'y': 0.3126860450097848
                    },
                ]
            },
            {
                'bg': '',
                'name': 'Imported level 55',
                'colorMask': '#999',
                'pieces': [
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.217,
                        'initY': 0.112,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.429,
                        'x': 0.7617353783714795,
                        'y': 0.6207799602654641
                    },
                    {
                        'img': 'tangram/p0.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.214,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.442,
                        'initY': 0.113,
                        'moduloRotation': 360,
                        'rotation': 135,
                        'width': 0.429,
                        'x': 0.1575774794520548,
                        'y': 0.6213755528801157
                    },
                    {
                        'img': 'tangram/p1.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 180,
                        'initX': 0.61,
                        'initY': 0.08,
                        'moduloRotation': 360,
                        'rotation': 0,
                        'width': 0.304,
                        'x': 0.5349563523355739,
                        'y': 0.32014745001276274
                    },
                    {
                        'img': 'tangram/p2.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.152,
                        'initFlipping': 0,
                        'initRotation': 0,
                        'initX': 0.911,
                        'initY': 0.081,
                        'moduloRotation': 90,
                        'rotation': 0,
                        'width': 0.152,
                        'x': 0.46054981783374455,
                        'y': 0.6207658271079726
                    },
                    {
                        'img': 'tangram/p3.svg',
                        'flippable': 1,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.083,
                        'initY': 0.178,
                        'moduloRotation': 180,
                        'rotation': 135,
                        'width': 0.322,
                        'x': 0.3843565054879607,
                        'y': 0.32016172602739723
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 135,
                        'initX': 0.741,
                        'initY': 0.118,
                        'moduloRotation': 360,
                        'rotation': 45,
                        'width': 0.215,
                        'x': 0.49805801939930244,
                        'y': 0.43325337130945296
                    },
                    {
                        'img': 'tangram/p4.svg',
                        'flippable': 0,
                        'flipping': false,
                        'height': 0.108,
                        'initFlipping': 0,
                        'initRotation': 45,
                        'initX': 0.946,
                        'initY': 0.205,
                        'moduloRotation': 360,
                        'rotation': 225,
                        'width': 0.215,
                        'x': 0.4224460236535353,
                        'y': 0.5076740389687742
                    },
                ]
            }
        ]
