/*
   This file is part of Massif Visualizer

   Copyright 2010 Milian Wolff <mail@milianw.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include <KLocalizedString>
#include <KAboutData>
#include <KApplication>
#include <KCmdLineArgs>
#include <KCmdLineOptions>
#include <KUrl>

#include <QtCore/QDebug>

#include "mainwindow.h"

int main( int argc, char *argv[] )
{
    KAboutData aboutData( "massif-visualizer", 0, ki18n( "Massif Visualizer" ),
                          "0.3", ki18n("A visualizer for output generated by Valgrind's massif tool."), KAboutData::License_LGPL,
                          ki18n( "Copyright 2010, Milian Wolff <mail@milianw.de>" ),
                          KLocalizedString(), "", "mail@milianw.de" );
    aboutData.setProgramIconName("office-chart-area");

    KCmdLineArgs::init( argc, argv, &aboutData, KCmdLineArgs::CmdLineArgNone );
    KCmdLineOptions options;
    options.add("+file", ki18n("Opens given output file and visualize it."));

    KCmdLineArgs::addCmdLineOptions( options );
    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
    KApplication app;

    for ( int i = 0; i < args->count(); ++i ) {
        Massif::MainWindow* window = new Massif::MainWindow;
        window->openFile(args->url(i));
        window->show();
    }
    if (!args->count()) {
        // at least one window has to be shown...
        Massif::MainWindow* window = new Massif::MainWindow;
        window->show();
    }
    return app.exec();
}
