/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KLDESIGNERPRIV_H
#define KLDESIGNERPRIV_H

#include "qobject.h"
#include "klhelper.h"
#include "kldialog.h"
#include "klgroup.h"
#include "klgroupbox.h"
#include "qtimer.h"
#include "kltreelist.h"
#include "qdragobject.h"
#include "qdropsite.h"


///////////////////////////////////////////////////////////////////////////////
// KLDesLine -- Draw any kind of marks
///////////////////////////////////////////////////////////////////////////////
class KLDesLine : public QWidget 
{
  Q_OBJECT
public:
  QTimer timer;
  KLDesLine(QWidget *parent) : QWidget(parent), asMark(false), shiftval(0) {};
  void setupTimer();
  void cleanupTimer();
  bool asMark;
  ulong shiftval;
  virtual void paintEvent ( QPaintEvent *e);
  const int PARTSIZE = 5;
public slots:
  void drawUpdate();
};


///////////////////////////////////////////////////////////////////////////////
// Registration tree item
///////////////////////////////////////////////////////////////////////////////
class KLDesTreeListItem : public KTreeListItem 
{
public:
  KLChildMeta *metaClass;
};

///////////////////////////////////////////////////////////////////////////////
// Types to manage tree items
///////////////////////////////////////////////////////////////////////////////
typedef QList<KLDesTreeListItem> KLDTLIList;
typedef QListIterator<KLDesTreeListItem> KLDTLIListIt;


///////////////////////////////////////////////////////////////////////////////
// Drag&Drop object 
///////////////////////////////////////////////////////////////////////////////
class KLDesignerPrivate;
class KLDragObject : public QDragObject 
{   
  KLDesignerPrivate *despriv;
  KLChild *dragChild;
  QString dragClass;
public:
  KLDragObject(KLDesignerPrivate *, QWidget *widget);
  static bool canDecode( QDragMoveEvent* e, KLDesignerPrivate *despriv );
  static KLChild *decode( QDropEvent* e, KLDesignerPrivate *despriv );


  virtual const char * format(int i) const;
  virtual QByteArray encodedData(const char* fmt) const;

  void setDragChild( KLChild *child );
  void setDragClass( QString _class );

};


///////////////////////////////////////////////////////////////////////////////
// Tree to display registratet classes
///////////////////////////////////////////////////////////////////////////////
class KLRegClassTree : public KLTreeList 
{
  Q_OBJECT
public:
  KLRegClassTree(KLDesignerPrivate *despriv);
  ~KLRegClassTree();
  void fill(KLMetaRegList *reglist);
  KLDTLIList treelist;

private slots:
  void startDrag(int index);

private:
  void createPath(QStrList &paths, QString currPath, KPath path);
  QPixmap iconPix;
  KLDragObject *drag;
};


///////////////////////////////////////////////////////////////////////////////
// Designer Device information
///////////////////////////////////////////////////////////////////////////////
class KLDesignerDevInfo {
public:
  KLDesignerDevInfo(KLDevice *dev,KLDesignerPrivate *_despriv);
  ~KLDesignerDevInfo();
  KLDevice *dev;
  KLDesLine *t;
  KLDesLine *b;
  KLDesLine *l;
  KLDesLine *r;
  KLDesLine *mark;
  KLDropMarkList dml;
  bool doUpdateDropmarks;
  KLDesignerPrivate *despriv;
};


///////////////////////////////////////////////////////////////////////////////
// Designer private data 
///////////////////////////////////////////////////////////////////////////////
class KLDesignerPrivate : public QObject {
  Q_OBJECT
public:
  KLDesignerPrivate();
  ~KLDesignerPrivate();

  // General Data
  KLMetaRegList regList;
  QList<KLDesignerDevInfo> deviceList;
  QString inAppMimeType;
  void *appEnv;

  // Dialogs & co 
  KLDialog *propwin;
  KLDialog *treewin;
  KLGroupBox *propGroup;
  KLChild *actPropEdit;
  KLRegClassTree *regClassTree;
  
  // Working data
  KLChild *actSelectedChild;  // Actual selected child
  KLChild *actPropChild;      // Child the actual Propedit is for
  KLDropMark *actMark;
  KLDevice *actSelChildDev;
  KLDevice *actMarkDev;

  // Funcs
  void updateStates();
  void clearProp();

  void showDesigner(ulong showFlags);
  void hideDesigner();
  void attachDevice(KLDevice *dev);
  void detachDevice(KLDevice *dev);

  void updateSelDisplay(KLDesignerDevInfo *di);
  void updateDropMarks(KLDesignerDevInfo *di);

  KLDesignerDevInfo *findDevInfo( KLDevice *dev );
  KLDesignerDevInfo *findDevInfo( QObject *widget );

  bool grapEvent(QEvent *e, KLDesignerDevInfo *dev);
  virtual bool eventFilter ( QObject *, QEvent * );

  void checkDragMove(QDragMoveEvent *e, KLDesignerDevInfo *di );
  void doDrop(QDropEvent *e);

  KLChild *checkForEmptyGroup(KLChild *group);

  QString &mimeTypeInAppChild();
};


#define MIME_TYPE           "apps/kledesigner"
#define MIME_TYPE_METACLASS MIME_TYPE "/klchildmeta"


#endif 

