/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KLGROUPBOX_H
#define KLGROUPBOX_H

#include "klwidgetbase.h"
#include "qgrpbox.h"
#include "klgroup.h"

class KLGroupBox : public QGroupBox, public KLWidgetBase {
  Q_OBJECT
public:
  KLGroupBox(const char *title = 0,bool horiz=false);
  void setTitle(const char *); 

  virtual bool klAskMinMax(KLMinMaxSizes *minMaxSizes);
  virtual bool klSetup( KLSetupInfo *setupInfo );
  virtual bool klShow(KLShowInfo *showInfo);
  virtual void klHide();
  virtual void klCleanup();

  virtual void setupGrap();
  virtual void cleanupGrap();

  virtual KLChild *findChild( ulong x, ulong y ) const;
  virtual void addDropMarks( KLDropMarkList * dml ) const;
  virtual bool isAChild( KLChild * ) const;

  KLGroupBox &operator<<(_child_change_func func);
  KLStreamHelp &operator<<(_child_change_p1_func func);
  KLGroupBox &operator<<(KLGroup::_grp_change_func func);
  KLGroupBox &operator<<(KLChild *child);
  KLGroupBox &operator<<(KLChild &child);

  KLHVGroup &group();
private:
  KLHVGroup a_group;
  enum { KLGroupBox_LeftBorder = 6, 
         KLGroupBox_RightBorder = 6,
         KLGroupBox_BottomBorder = 6,
         KLGroupBox_TopBorder = 1,  // You must add the height of the title to get the real topborder
         KLGroupBox_TitleBorder = 9, // Border of the title
       };

  DECLARE_KLMETA_STANDALONE();
  KLWDIGET_DELEGATES(KLGroupBox,QGroupBox);
};

// Inline attribute GET funcs
inline KLHVGroup &KLGroupBox::group()
{ return a_group; };

#endif 

